/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.auto.JDFAutoComponent;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDF;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkResLink;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.process.JDFComponent;

public class WalkProduct
extends WalkJDF {
    private static final StringArray copyKeep = new StringArray(new String[]{"ExternalID", "ProductType", "PartVersion", "ProductTypeDetails", "DescriptiveName"});

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFNode node = (JDFNode)jdf;
        boolean matchesID = this.matchesRootID(node);
        if (matchesID) {
            this.prepareRoot(node, xjdf);
            this.jdfToXJDF.first.add(jdf.getID());
        }
        this.walkProduct(jdf, xjdf);
        return xjdf;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && this.jdfToXJDF.isWantProduct() && JDFNode.EnumType.Product.equals((Object)((JDFNode)toCheck).getEnumType());
    }

    @Override
    protected void removeUnusedElements(KElement newRootP) {
        newRootP.removeAttribute("Status");
        newRootP.removeAttribute("StatusDetails");
        newRootP.removeAttribute("Activation");
        newRootP.removeAttribute("Template");
        super.removeUnusedElements(newRootP);
    }

    private void calcChildren(JDFNode node, KElement prod) {
        VString kids = new VString();
        VElement vComp = node.getPredecessors(true, true);
        if (vComp != null) {
            for (KElement e : vComp) {
                JDFNode nPre = (JDFNode)e;
                if (!JDFNode.EnumType.Product.equals((Object)nPre.getEnumType())) continue;
                kids.add(this.getXJDFProductID(nPre));
            }
        }
        for (String kid : kids) {
            prod.appendAttribute("ChildRefs", kid, null, null, false);
        }
    }

    boolean readComponent(JDFNode node, KElement prod) {
        JDFResourceLink cOutLink = node.getLink(0, "Component", new JDFAttributeMap("Usage", JDFResourceLink.EnumUsage.Output), null);
        if (cOutLink == null) {
            return false;
        }
        int amount = (int)cOutLink.getAmountPoolSumDouble("Amount", null);
        if (amount > 0) {
            prod.setAttribute("Amount", amount, (String)null);
        }
        prod.renameAttribute("AmountGood", "Amount", null, null);
        prod.removeAttribute("AmountWaste");
        JDFComponent component = (JDFComponent)cOutLink.getTarget();
        if (component != null) {
            JDFAttributeMap map = component.getAttributeMap();
            map.removeEmpty();
            map.renameKey("ProductID", "ExternalID");
            map.reduceMap(copyKeep);
            prod.setAttributes(map);
            if (component.isComponentType(JDFAutoComponent.EnumComponentType.FinalProduct)) {
                new ProductHelper(prod).setRoot();
            }
            this.jdfToXJDF.putComponentProduct(component.getID(), prod.getID());
        }
        return true;
    }

    KElement walkProduct(KElement jdf, KElement xjdf) {
        JDFNode node = (JDFNode)jdf;
        KElement prod = this.getProductForElement(xjdf, node);
        if (node.isJDFRoot()) {
            new ProductHelper(prod).setRoot();
        }
        if (this.readComponent(node, prod)) {
            JDFAttributeMap map = jdf.getAttributeMap();
            if (prod.getNonEmpty("ExternalID") == null) {
                String xid = WalkResLink.getXJDFExternalID(node);
                map.put("ExternalID", xid);
            }
            this.updateAttributes(map);
            prod.setAttributes(map);
            this.calcChildren(node, prod);
            return prod;
        }
        prod.deleteNode();
        return xjdf;
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        map.remove("ID");
        map.remove("Category");
        map.remove("Type");
        map.remove("Activation");
        map.remove("Version");
        map.remove("MaxVersion");
        map.remove("ICSVersions");
        map.remove("ProjectID");
        map.remove("Status");
        map.remove("StatusDetails");
        map.remove("xmlns");
        map.remove("xsi:type");
        map.remove("JobID");
        map.remove("xmlns:xsi");
        map.remove("JobPartID");
        super.updateAttributes(map);
    }
}

