/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFAttributeMapArray;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.IDFinder;
import org.cip4.jdflib.extensions.xjdfwalker.IDPart;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class WalkSet
extends WalkXElement {
    @Override
    public KElement walk(KElement xjdf, KElement jdf) {
        if (jdf instanceof JDFNode) {
            JDFNode parentNode = (JDFNode)jdf;
            String procUsage = StringUtil.getNonEmpty(xjdf.getAttribute("ProcessUsage"));
            if ("Product".equals(procUsage) && !JDFNode.EnumType.Product.equals((Object)parentNode.getEnumType())) {
                return null;
            }
            VString types = parentNode.getTypes();
            if (types == null || types.size() <= 1) {
                xjdf.removeAttribute("CombinedProcessIndex");
            }
        }
        this.reorderResources(xjdf);
        return jdf;
    }

    void reorderResources(KElement xjdf) {
        List<ResourceHelper> vp = this.addLowerParts(xjdf);
        if (ContainerUtil.size(vp) > 1) {
            vp.sort(new PartSizeComparator());
        }
        for (ResourceHelper p : vp) {
            xjdf.moveElement(p.getRoot(), null);
        }
    }

    List<ResourceHelper> addLowerParts(KElement xjdf) {
        SetHelper h = new SetHelper(xjdf);
        List<ResourceHelper> vp = h.getPartitionList();
        JDFAttributeMapArray foundparts = this.findCommonParts(vp);
        StringArray seq = this.findSubSequence(foundparts);
        if (!seq.isEmpty()) {
            return this.reallyAddSubParts(h, seq);
        }
        return vp;
    }

    private JDFAttributeMapArray findCommonParts(List<ResourceHelper> vp) {
        JDFAttributeMapArray foundparts = new JDFAttributeMapArray();
        StringArray sss = new StringArray("SignatureName SheetName Side Separation");
        JDFAttributeMap map = new JDFAttributeMap();
        HashSet<String> keyset = new HashSet<String>();
        for (ResourceHelper p : vp) {
            JDFAttributeMap pMap = p.getPartMap();
            JDFAttributeMap map2 = map.getCommonMap(pMap);
            if (!JDFAttributeMap.isEmpty(map2)) {
                map2.removeKeys(sss);
                if (!map2.keySet().containsAll(keyset)) {
                    map2.reduceMap(keyset);
                }
                if (!map2.isEmpty()) {
                    foundparts.add(map2);
                    keyset.addAll(map2.keySet());
                }
            }
            map = pMap;
        }
        return foundparts;
    }

    private StringArray findSubSequence(JDFAttributeMapArray foundparts) {
        StringArray seq = new StringArray();
        boolean nostop = true;
        int i = 1;
        while (nostop) {
            nostop = false;
            for (JDFAttributeMap found : foundparts) {
                int size = found.size();
                boolean bl = nostop = nostop || size >= i;
                if (size != i) continue;
                StringArray keys = new StringArray(found.getKeyList());
                keys.removeAll(seq);
                seq.add(keys.get(0));
                break;
            }
            ++i;
        }
        return seq;
    }

    private List<ResourceHelper> reallyAddSubParts(SetHelper h, StringArray seq) {
        VJDFAttributeMap allParts = h.getPartMapVector();
        for (JDFAttributeMap found : allParts) {
            String key;
            String value;
            JDFAttributeMap subMap = new JDFAttributeMap();
            Iterator iterator = seq.iterator();
            while (iterator.hasNext() && !StringUtil.isEmpty(value = found.get(key = (String)iterator.next()))) {
                subMap.put(key, value);
                h.getCreateResource(subMap, false);
            }
        }
        Map<String, IDPart> ids = new IDFinder().getMap(h.getRoot());
        ContainerUtil.putAll(this.xjdfToJDFImpl.idMap, ids);
        return h.getPartitionList();
    }

    protected String getJDFResName(KElement e) {
        SetHelper h = new SetHelper(e);
        String name = h.getName();
        return name;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return SetHelper.isSet(toCheck);
    }

    static class PartSizeComparator
    implements Comparator<ResourceHelper> {
        PartSizeComparator() {
        }

        @Override
        public int compare(ResourceHelper o1, ResourceHelper o2) {
            return o1.getPartMap().size() - o2.getPartMap().size();
        }
    }
}

