/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.List;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.JDFToXJDFDataCache;
import org.cip4.jdflib.resource.process.JDFContact;

class XJDFPrepWalker
extends BaseElementWalker {
    XJDFPrepWalker() {
        super(new BaseWalkerFactory());
    }

    protected class WalkStripMark
    extends WalkElement {
        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            List<KElement> kids = xjdf.getChildList();
            StringArray names = JDFToXJDFDataCache.getStripMarkElements();
            for (KElement kid : kids) {
                if (!names.contains(kid.getLocalName())) continue;
                KElement parent = xjdf.getParentNode_KElement();
                KElement mo = parent.getElement("PlacedObject/MarkObject");
                if (mo == null) {
                    KElement po = parent.insertBefore("PlacedObject", xjdf, null);
                    mo = po.appendElement("MarkObject");
                }
                for (KElement kid2 : kids) {
                    mo.moveElement(kid2, null);
                }
                KElement dm = mo.appendElement("DeviceMark");
                dm.setAttributes(xjdf);
                xjdf.deleteNode();
                return super.walk(mo, dummy);
            }
            return super.walk(xjdf, dummy);
        }

        @Override
        public VString getElementNames() {
            return new VString("StripMark");
        }
    }

    protected class WalkResourceInfo
    extends WalkElement {
        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            SetHelper sh;
            KElement parent = xjdf.getParentNode_KElement();
            if (parent != null && (sh = SetHelper.getHelper(xjdf.getElement("ResourceSet"))) != null) {
                boolean i = true;
                while (1 < sh.size()) {
                    KElement newRI = parent.appendElement("ResourceInfo");
                    newRI.setAttributes(xjdf);
                    KElement newSet = newRI.appendElement("ResourceSet");
                    newSet.setAttributes(sh.getRoot());
                    ResourceHelper part = sh.getPartition(1);
                    newSet.moveElement(part.getRoot(), null);
                }
            }
            return super.walk(xjdf, dummy);
        }

        @Override
        public VString getElementNames() {
            return new VString("ResourceInfo");
        }
    }

    protected class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(XJDFPrepWalker.this.getFactory());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            return xjdf;
        }
    }

    protected class WalkContact
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            VString cTypes;
            VJDFAttributeMap vMap;
            JDFContact c = (JDFContact)e;
            ResourceHelper h = ResourceHelper.getHelper(c);
            VJDFAttributeMap vJDFAttributeMap = vMap = h == null ? null : h.getPartMapVector();
            if (!VJDFAttributeMap.isEmpty(vMap) && !VString.isEmpty(cTypes = vMap.getPartValues("ContactType", true))) {
                String ctypeString;
                SetHelper sh = h.getSet();
                c.setContactTypes(cTypes);
                vMap.removeKey("ContactType");
                if (vMap.getKeys().isEmpty() && sh.size() > 1 && !"Employee".equals(ctypeString = cTypes.getString("_", null, null))) {
                    vMap.put("Option", ctypeString);
                }
                vMap.unify();
                h.setPartMapVector(vMap);
            }
            KElement ret = super.walk(e, trackElem);
            return ret;
        }

        @Override
        public VString getElementNames() {
            return VString.getVString("Contact", null);
        }
    }
}

