/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.goldenticket;

import org.cip4.jdflib.auto.JDFAutoConventionalPrintingParams;
import org.cip4.jdflib.auto.JDFAutoMedia;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFIntegerRange;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.goldenticket.MISGoldenTicket;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.JDFEmbossingParams;
import org.cip4.jdflib.resource.JDFLaminatingParams;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFShapeCuttingParams;
import org.cip4.jdflib.resource.JDFTool;
import org.cip4.jdflib.resource.process.JDFConventionalPrintingParams;
import org.cip4.jdflib.resource.process.JDFMedia;

public class NarrowWebGoldenTicket
extends MISGoldenTicket {
    boolean bLaminate;
    boolean bEmboss;
    boolean bShapeCut;

    public NarrowWebGoldenTicket(int level, JDFElement.EnumVersion jdfVersion, int jmfLevel) {
        super(level, jdfVersion, jmfLevel);
        this.bPartitionedPlateMedia = true;
    }

    public boolean isLaminate() {
        return this.bLaminate;
    }

    public void setLaminate(boolean laminate) {
        this.bLaminate = laminate;
    }

    public boolean isEmboss() {
        return this.bEmboss;
    }

    public void setEmboss(boolean emboss) {
        this.bEmboss = emboss;
    }

    public boolean isShapeCut() {
        return this.bShapeCut;
    }

    public void setShapeCut(boolean shapeCut) {
        this.bShapeCut = shapeCut;
    }

    @Override
    public VString getTypes() {
        VString v = new VString();
        v.add(JDFNode.EnumType.ConventionalPrinting.getName());
        if (this.bEmboss) {
            v.add(JDFNode.EnumType.Embossing.getName());
        }
        if (this.bLaminate) {
            v.add(JDFNode.EnumType.Laminating.getName());
        }
        if (this.bShapeCut) {
            v.add(JDFNode.EnumType.ShapeCutting.getName());
        }
        return v;
    }

    @Override
    public void init() {
        this.cols = new VString("Black,Cyan,Magenta,Yellow,FlexoBlack,GravureBlack", ",");
        this.vParts = new VJDFAttributeMap();
        JDFAttributeMap map = new JDFAttributeMap("SheetName", "Bogen1");
        map.put("Side", "Front");
        this.partIDKeys = new VString("SheetName Side", null);
        this.vParts.add(map);
        this.nCols[0] = this.cols.size();
        this.nCols[1] = 0;
        this.plateReduction = null;
        super.init();
        this.initColorantControl();
        this.initPlateXM(JDFResourceLink.EnumUsage.Input);
        this.initConventionalPrinting();
        if (this.bEmboss) {
            this.initEmbossing();
        }
        if (this.bLaminate) {
            this.initLaminating();
        }
        if (this.bShapeCut) {
            this.initShapeCutting();
        }
    }

    private void initConventionalPrinting() {
        JDFConventionalPrintingParams cp = (JDFConventionalPrintingParams)this.theNode.addResource("ConventionalPrintingParams", JDFResourceLink.EnumUsage.Input);
        cp.addPartitions(JDFResource.EnumPartIDKey.Separation, this.cols);
        VElement cpLeaves = cp.getLeaves(false);
        for (int i = 0; i < cpLeaves.size(); ++i) {
            JDFConventionalPrintingParams cpLeaf = (JDFConventionalPrintingParams)cpLeaves.get(i);
            JDFAutoConventionalPrintingParams.EnumPrintingType pt = JDFAutoConventionalPrintingParams.EnumPrintingType.WebSingle;
            JDFAutoConventionalPrintingParams.EnumPrintingTechnology tech = JDFAutoConventionalPrintingParams.EnumPrintingTechnology.Offset;
            if (this.cols.get(i).indexOf("Flexo") >= 0) {
                tech = JDFAutoConventionalPrintingParams.EnumPrintingTechnology.Flexo;
            }
            if (this.cols.get(i).indexOf("Gravure") >= 0) {
                tech = JDFAutoConventionalPrintingParams.EnumPrintingTechnology.Gravure;
            }
            if (this.cols.get(i).indexOf("Screen") >= 0) {
                tech = JDFAutoConventionalPrintingParams.EnumPrintingTechnology.Screen;
            }
            cpLeaf.setPrintingType(pt);
            cpLeaf.setPrintingTechnology(tech);
            cpLeaf.setModuleIndex(new JDFIntegerRangeList(new JDFIntegerRange(i)));
        }
    }

    private void initShapeCutting() {
        JDFShapeCuttingParams sp = (JDFShapeCuttingParams)this.theNode.addResource("ShapeCuttingParams", JDFResourceLink.EnumUsage.Input);
        sp.setAttribute("ModuleIndex", 8, (String)null);
        sp.setDescriptiveName("Modulzuordnung Stanzen");
        JDFTool tool = (JDFTool)this.theNode.addResource("Tool", JDFResourceLink.EnumUsage.Input);
        tool.setToolType("ToolSet");
        tool.setProductID("Stanz_ID");
        tool.setDescriptiveName("Werkzeugsatz Stanzen");
        JDFResourceLink rlt = this.theNode.getLink((JDFResource)tool, null);
        rlt.setCombinedProcessIndex(this.theNode.getCombinedProcessIndex(JDFNode.EnumType.ShapeCutting, 0));
    }

    private void initEmbossing() {
        JDFEmbossingParams ep = (JDFEmbossingParams)this.theNode.addResource("EmbossingParams", JDFResourceLink.EnumUsage.Input);
        ep.setAttribute("ModuleIndex", 7, (String)null);
        ep.setDescriptiveName("Modulzuordnung Pr\u00e4gen");
        JDFTool tool = (JDFTool)this.theNode.addResource("Tool", JDFResourceLink.EnumUsage.Input);
        tool.setToolType("ToolSet");
        tool.setProductID("Praege_ID");
        tool.setDescriptiveName("Werkzeugsatz Pr\u00e4gen");
        JDFResourceLink rlt = this.theNode.getLink((JDFResource)tool, null);
        rlt.setCombinedProcessIndex(this.theNode.getCombinedProcessIndex(JDFNode.EnumType.Embossing, 0));
    }

    private void initLaminating() {
        JDFLaminatingParams lp = (JDFLaminatingParams)this.theNode.addResource("LaminatingParams", JDFResourceLink.EnumUsage.Input);
        lp.setAttribute("ModuleIndex", 6, (String)null);
        lp.setDescriptiveName("Modulzuordnung Laminieren");
        JDFMedia foil = (JDFMedia)this.theNode.addResource("Media", JDFResourceLink.EnumUsage.Input);
        foil.setMediaType(JDFAutoMedia.EnumMediaType.LaminatingFoil);
    }

    @Override
    protected JDFDevice initDevice(JDFNode reuseNode) {
        return super.initDevice(reuseNode);
    }
}

