/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoResourceInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFAttributeMapArray;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.ifaces.IAmountPoolContainer;
import org.cip4.jdflib.ifaces.IMatches;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFResourceQuParams;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFResourceInfo
extends JDFAutoResourceInfo
implements IAmountPoolContainer,
IMatches {
    private static final long serialVersionUID = 1L;
    private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[2];

    public JDFResourceInfo(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFResourceInfo(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFResourceInfo(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    public static JDFResourceInfo createResourceInfo(JDFMessage parent, JDFResourceLink resourceLink, boolean copyResource) {
        if (parent == null) {
            LogFactory.getLog(JDFResourceInfo.class).error((Object)"cannot create ResourceInfo in null parent");
            return null;
        }
        JDFResourceInfo ri = parent.appendResourceInfo();
        ri.setLink(resourceLink, copyResource);
        return ri;
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    @Override
    public String toString() {
        return "JDFResourceInfo[  --> " + super.toString() + " ]";
    }

    public JDFResource getCreateResource(String resName) {
        JDFResource e = this.getResource(resName);
        if (e == null) {
            e = this.appendResource(resName);
        }
        return e;
    }

    public JDFResource getResource(String resName) {
        int i = 0;
        KElement e;
        while ((e = this.getElement(resName, null, i)) != null) {
            if (e instanceof JDFResource) {
                return (JDFResource)e;
            }
            ++i;
        }
        return null;
    }

    public VElement getResourceVector() {
        VElement v0 = this.getChildElementVector(null, null);
        if (v0 == null) {
            return null;
        }
        for (int i = v0.size() - 1; i >= 0; --i) {
            KElement e = v0.get(i);
            if (e instanceof JDFResource) continue;
            v0.remove(i);
        }
        return v0.size() == 0 ? null : v0;
    }

    public JDFResource appendResource(String resName) {
        KElement e;
        if (StringUtil.isEmpty(resName)) {
            resName = this.getResourceName();
        }
        if (!StringUtil.isEmpty(resName) && (e = this.appendElement(resName, null)) instanceof JDFResource) {
            return (JDFResource)e;
        }
        throw new JDFException("JDFResouceInfo.appendResource tried to append a JDFElement instead of a JDFResource");
    }

    @Override
    public VString getUnknownElements(boolean bIgnorePrivate, int nMax) {
        return this.getUnknownPoolElements(JDFElement.EnumPoolType.ResourcePool, nMax);
    }

    @Override
    public VString getInvalidElements(JDFElement.EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        VString s = this.getInvalidElements_JDFElement(level, bIgnorePrivate, nMax);
        if (s.size() > nMax || this.hasAttribute("ResourceName")) {
            return s;
        }
        VElement v = this.getChildElementVector(null, null, null, true, 0, false);
        int size = v.size();
        if (size > 1) {
            for (int i = size - 1; i >= 0; --i) {
                if (v.elementAt(i) instanceof JDFResource) continue;
                v.remove(i);
            }
            size = v.size();
            if (size > 1) {
                for (int j = 0; j < size; ++j) {
                    s.appendUnique(v.item(j).getLocalName());
                }
            }
        }
        return s;
    }

    @Override
    public JDFAttributeMapArray getPartMapArray() {
        return super.getPartMapArray();
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        return super.getPartMapVector();
    }

    @Override
    public void setPartMapVector(VJDFAttributeMap vParts) {
        super.setPartMapVector(vParts);
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        super.setPartMap(mPart);
    }

    @Override
    public void removePartMap(JDFAttributeMap mPart) {
        super.removePartMap(mPart);
    }

    @Override
    public boolean hasPartMap(JDFAttributeMap mPart) {
        return super.hasPartMap(mPart);
    }

    public void setLink(JDFResourceLink resourceLink, boolean copyResource) {
        if (resourceLink == null) {
            return;
        }
        this.setPartMapVector(resourceLink.getPartMapVector());
        JDFAmountPool ap = resourceLink.getAmountPool();
        if (ap != null) {
            this.copyElement(ap, null);
        } else {
            if (resourceLink.hasAttribute("ActualAmount")) {
                this.setActualAmount(resourceLink.getActualAmount(null));
            }
            if (resourceLink.hasAttribute("Amount")) {
                this.setAmount(resourceLink.getAmount(null));
            }
        }
        this.setProcessUsage(StringUtil.getNonEmpty(resourceLink.getProcessUsage()));
        this.setUsage(resourceLink.getUsage());
        this.setResourceName(resourceLink.getLinkedResourceName());
        this.copyAttribute("Orientation", resourceLink);
        JDFResource r = resourceLink.getTarget();
        if (r != null) {
            this.setLinkResource(copyResource, r);
        }
    }

    void setLinkResource(boolean copyResource, JDFResource r) {
        this.copyAttribute("ProductID", r);
        this.copyAttribute("DescriptiveName", r);
        this.setResStatus(r.getResStatus(false));
        if (copyResource) {
            JDFResource resourceRoot = r.getResourceRoot();
            JDFResource rr = (JDFResource)resourceRoot.getParentNode_KElement().copyElement(resourceRoot, null);
            rr.inlineRefElements(null, null, true);
            this.moveElement(rr, null);
        }
    }

    public void setLink(JDFResourceLink resourceLink, JDFResourceQuParams rqp) {
        if (resourceLink == null) {
            return;
        }
        JDFResource r = resourceLink.getTarget();
        if (r == null && rqp != null) {
            rqp.setExact(false);
        }
        boolean bExact = rqp == null ? false : rqp.getExact();
        this.setLink(resourceLink, bExact);
    }

    public void setProcessUsage(JDFNode.EnumProcessUsage processUsage) {
        this.setAttribute("ProcessUsage", processUsage == null ? null : processUsage.getName(), null);
    }

    @Override
    public String getProductID() {
        String _name = super.getProductID();
        if (JDFResourceInfo.isWildCard(_name)) {
            JDFResource r = this.getResource(null);
            if (r == null) {
                return null;
            }
            _name = r.getProductID();
        }
        return StringUtil.getNonEmpty(_name);
    }

    @Override
    public String getResourceID() {
        String _name = super.getResourceID();
        if (JDFResourceInfo.isWildCard(_name)) {
            JDFResource r = this.getResource(null);
            if (r == null) {
                return null;
            }
            _name = r.getID();
        }
        return _name;
    }

    @Override
    public String getResourceName() {
        String _name = super.getResourceName();
        if (JDFResourceInfo.isWildCard(_name)) {
            JDFResource r = this.getResource(null);
            if (r == null) {
                return null;
            }
            _name = r.getLocalName();
        }
        return _name;
    }

    @Override
    public JDFResource.EnumResStatus getResStatus() {
        JDFResource.EnumResStatus s = super.getResStatus();
        if (s == null) {
            JDFResource r = this.getResource(null);
            if (r == null) {
                return null;
            }
            s = r.getResStatus(false);
        }
        return s;
    }

    @Override
    public JDFResource getLinkRoot() {
        return this.getResource(this.getResourceName());
    }

    public void setActualAmount(double value, JDFAttributeMap mPart) {
        this.setAmountPoolAttribute("ActualAmount", StringUtil.formatDouble(value), null, mPart);
    }

    public void setAmount(double value, JDFAttributeMap mPart) {
        this.setAmountPoolAttribute("Amount", StringUtil.formatDouble(value), null, mPart);
    }

    public void setAmountPoolAttribute(String attrib, String value, String nameSpaceURI, JDFAttributeMap mPart) {
        JDFAmountPool.AmountPoolHelper.setAmountPoolAttribute((IAmountPoolContainer)this, attrib, value, nameSpaceURI, mPart);
    }

    public void setAmountPoolAttribute(String attrib, String value, String nameSpaceURI, VJDFAttributeMap vPart) {
        JDFAmountPool.AmountPoolHelper.setAmountPoolAttribute((IAmountPoolContainer)this, attrib, value, nameSpaceURI, vPart);
    }

    public String getAmountPoolAttribute(String attrib, String nameSpaceURI, JDFAttributeMap mPart, int iSkip) {
        return JDFAmountPool.AmountPoolHelper.getAmountPoolAttribute(this, attrib, nameSpaceURI, mPart, iSkip);
    }

    public String getAmountPoolAttribute(String attrib, String nameSpaceURI, VJDFAttributeMap vPart) {
        return JDFAmountPool.AmountPoolHelper.getAmountPoolAttribute(this, attrib, nameSpaceURI, vPart);
    }

    public double getAmountPoolDouble(String attName, JDFAttributeMap mPart) {
        return JDFAmountPool.AmountPoolHelper.getAmountPoolDouble((IAmountPoolContainer)this, attName, mPart);
    }

    public double getAmountPoolDouble(String attName, VJDFAttributeMap vPart) {
        return JDFAmountPool.AmountPoolHelper.getAmountPoolDouble((IAmountPoolContainer)this, attName, vPart);
    }

    public double getAmountPoolSumDouble(String attName, VJDFAttributeMap vPart) {
        return JDFAmountPool.AmountPoolHelper.getAmountPoolSumDouble(this, attName, vPart);
    }

    @Override
    public boolean matches(Object subset) {
        if (subset == null) {
            return true;
        }
        String resourceName = this.getResourceName();
        if (subset instanceof String) {
            return subset.equals(resourceName);
        }
        if (subset instanceof JDFResource) {
            return subset.getClass().getSimpleName().equals("JDF" + resourceName);
        }
        if (subset instanceof JDFResourceQuParams) {
            JDFResourceQuParams rqp = (JDFResourceQuParams)subset;
            return this.matchersRQP(resourceName, rqp);
        }
        return false;
    }

    protected boolean matchersRQP(String resourceName, JDFResourceQuParams rqp) {
        String resourceID;
        VString resourceNames = rqp.getResourceName();
        boolean bRet = resourceNames.isEmpty() || resourceNames.contains(resourceName);
        String productID = rqp.getProductID();
        if (StringUtil.getNonEmpty(productID) != null) {
            boolean bl = bRet = bRet && ContainerUtil.equals(this.getProductID(), productID);
        }
        if (StringUtil.getNonEmpty(resourceID = rqp.getResourceID()) != null) {
            bRet = bRet && ContainerUtil.equals(this.getResourceID(), resourceID);
        }
        return bRet;
    }

    static {
        int i = 0;
        JDFResourceInfo.elemInfoTable[i++] = new ElemInfoTable("Preview", 0x33333333L);
        JDFResourceInfo.elemInfoTable[i++] = new ElemInfoTable("Part", 0x3333333333L);
    }
}

