/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.pool;

import java.util.HashSet;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDocUserData;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.pool.JDFPool;
import org.cip4.jdflib.resource.JDFResource;
import org.w3c.dom.Attr;

public class JDFResourcePool
extends JDFPool {
    private static final long serialVersionUID = 1L;
    private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[91];

    public JDFResourcePool(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFResourcePool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFResourcePool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    public static ElemInfoTable[] getLinkInfoTable() {
        ElemInfoTable[] elemInfoTableLink = new ElemInfoTable[elemInfoTable.length];
        for (int i = 0; i < elemInfoTableLink.length; ++i) {
            elemInfoTableLink[i] = new ElemInfoTable(elemInfoTable[i].getElementName() + "Link", elemInfoTable[i].getValidityStatus());
        }
        return elemInfoTableLink;
    }

    @Override
    public String toString() {
        return "JDFResourcePool[ --> " + super.toString() + " ]";
    }

    public VString getResIds() {
        VString setID = new VString();
        VElement nl = this.getPoolChildren(null, null, null);
        int l = nl.size();
        for (int i = 0; i < l; ++i) {
            String s = ((JDFResource)nl.elementAt(i)).getAttribute("ID");
            if (s.equals("")) continue;
            setID.add(s);
        }
        return setID;
    }

    public JDFResource getResource(String strName, int i, String nameSpaceURI) {
        JDFResource poolChild = this.getPoolChild(i, strName, null, nameSpaceURI);
        if (poolChild != null) {
            return poolChild;
        }
        return null;
    }

    public JDFResource appendResource(JDFResource res) {
        return (JDFResource)this.moveElement(res, null);
    }

    public JDFResource appendResource(String strName, JDFResource.EnumResourceClass resClass, String nameSpaceURI) {
        KElement appElement = this.appendElement(strName, nameSpaceURI);
        if (appElement instanceof JDFResource) {
            JDFResource r = (JDFResource)appElement;
            if (!r.hasAttribute("Class") && resClass != null) {
                r.setResourceClass(resClass);
            }
            return r;
        }
        return null;
    }

    @Deprecated
    public VString copyResource(JDFResource r, JDFResource.EnumSpawnStatus copyStatus, VJDFAttributeMap vParts, String spawnID) {
        int i;
        VString ss = this.getResIds();
        VString v = new VString();
        if (!ss.contains(r.getID())) {
            KElement rNew = null;
            if (copyStatus == JDFResource.EnumSpawnStatus.SpawnedRO) {
                r.appendSpawnIDs(spawnID);
                rNew = (JDFResource)this.copyElement(r, null);
                ((JDFResource)rNew).setLocked(true);
                r.setSpawnStatus(copyStatus);
            } else if (copyStatus == JDFResource.EnumSpawnStatus.SpawnedRW) {
                if (vParts.size() == 0) {
                    r.appendSpawnIDs(spawnID);
                    rNew = (JDFResource)this.copyElement(r, null);
                    r.setSpawnStatus(copyStatus);
                } else {
                    rNew = (JDFResource)this.copyElement(r, null);
                    ((JDFResource)rNew).reducePartitions(vParts);
                    for (i = 0; i < vParts.size(); ++i) {
                        JDFResource pLeaf = r.getPartition(vParts.elementAt(i), null);
                        JDFResource pNewLeaf = ((JDFResource)rNew).getPartition(vParts.elementAt(i), null);
                        if (pLeaf != null) {
                            pLeaf.setSpawnStatus(copyStatus);
                            pLeaf.appendSpawnIDs(spawnID);
                        }
                        if (pNewLeaf == null) continue;
                        pNewLeaf.appendSpawnIDs(spawnID);
                    }
                }
            }
            if (rNew != null) {
                v.addElement(rNew.getID());
            }
        }
        VString vs = r.getHRefs(null, false, true);
        for (i = 0; i < vs.size(); ++i) {
            JDFResource next;
            String id = vs.elementAt(i);
            if (ss.contains(id) || v.contains(id) || (next = (JDFResource)this.getDocRoot().getTarget(id, "ID")) != null) continue;
            next = (JDFResource)r.getDocRoot().getTarget(id, "ID");
            VString vv = this.copyResource(next, copyStatus, vParts, spawnID);
            v.addAll(vv);
        }
        return v;
    }

    public VElement getPoolChildren(String strName, JDFAttributeMap mAttrib, String nameSpaceURI) {
        return this.getPoolChildren_JDFResourcePool(strName, mAttrib, nameSpaceURI);
    }

    private VElement getPoolChildren_JDFResourcePool(String strName, JDFAttributeMap mAttrib, String nameSpaceURI) {
        VElement v = this.getPoolChildrenGeneric(strName, mAttrib, nameSpaceURI);
        for (int i = v.size() - 1; i >= 0; --i) {
            if (v.elementAt(i) instanceof JDFResource) continue;
            v.removeElementAt(i);
        }
        return v;
    }

    public JDFResource getPoolChild(int i, String strName, JDFAttributeMap mAttrib, String nameSpaceURI) {
        return this.getPoolChild_JDFResourcePool(i, strName, mAttrib, nameSpaceURI);
    }

    private JDFResource getPoolChild_JDFResourcePool(int i, String strName, JDFAttributeMap mAttrib, String nameSpaceURI) {
        int iLocal = i;
        VElement v = this.getPoolChildren(strName, mAttrib, nameSpaceURI);
        if (iLocal < 0 && (iLocal = v.size() + iLocal) < 0) {
            return null;
        }
        if (v.size() <= iLocal) {
            return null;
        }
        JDFResource jdfResource = (JDFResource)v.elementAt(iLocal);
        return jdfResource;
    }

    @Override
    public VString getUnknownElements(boolean bIgnorePrivate, int nMax) {
        return this.getUnknownPoolElements(JDFElement.EnumPoolType.ResourcePool, nMax);
    }

    public JDFResource getResourceByID(String id) {
        KElement e;
        XMLDocUserData userData = this.getXMLDocUserData();
        if (userData != null) {
            KElement kRet = userData.getTarget(id);
            if (kRet != null && kRet.getParentNode_KElement() != this) {
                kRet = null;
            }
            if (kRet != null && kRet instanceof JDFResource) {
                return (JDFResource)kRet;
            }
        }
        for (e = this.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            Attr attr = e.getAttributeNode("ID");
            if (attr == null) continue;
            if (userData != null) {
                userData.setTarget(e, attr.getValue());
            }
            if (id.equals(attr.getValue())) break;
        }
        return e instanceof JDFResource ? (JDFResource)e : null;
    }

    @Override
    public HashSet<JDFElement> getAllRefs(HashSet<JDFElement> vDoneRefs, boolean bRecurse) {
        VElement vResources = this.getPoolChildren(null, null, null);
        int size = vResources.size();
        for (int i = 0; i < size; ++i) {
            JDFResource r = (JDFResource)vResources.elementAt(i);
            vDoneRefs = r.getResourceRoot().getAllRefs(vDoneRefs, bRecurse);
        }
        return vDoneRefs;
    }

    public VElement getUnlinkedResources() {
        VElement v = this.getPoolChildren(null, null, null);
        if (v == null || v.size() == 0) {
            return null;
        }
        for (int i = v.size() - 1; i >= 0; --i) {
            JDFResource r = (JDFResource)v.elementAt(i);
            VElement v2 = r.getLinksAndRefs(true, true);
            if (v2 == null) continue;
            v.removeElementAt(i);
        }
        return v.size() == 0 ? null : v;
    }

    static {
        int i = 0;
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("EmbossingIntent", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("PublishingIntent", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("SizeIntent", 0x44444443L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("AdhesiveBindingParams", 0x44444443L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("Assembly", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("AssetListCreationParams", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("BarcodeCompParams", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("BarcodeReproParams", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("BendingParams", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("BinderySignature", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("BlockPreparationParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("BoxFoldingParams", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("BoxPackingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("BufferParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("Bundle", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("BundlingParams", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("CaseMakingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("CasingInParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("ColorMeasurementConditions", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("ContactCopyParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("CoverApplicationParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("CreasingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("CustomerInfo", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("CuttingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("CylinderLayout", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("CylinderLayoutPreparationParams", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("DevelopingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("DeviceMark", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("DieLayout", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("DigitalDeliveryParams", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("DigitalMedia", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("DividingParams", 0x44444443L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("ElementColorParams", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("EmbossingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("ExternalImpositionTemplate", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("FeedingParams", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("FitPolicy", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("Fold", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("FormatConversionParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("GluingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("HeadBandApplicationParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("HoleLine", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("HoleList", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("IDPrintingParams", 0x44444443L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("JobField", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("LabelingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("LayoutElementProductionParams", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("LayoutPreparationParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("LongitudinalRibbonOperationParams", 0x44444443L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("ManualLaborParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("MediaSource", 0x44444443L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("MiscConsumable", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("NodeInfo", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("PackingParams", 0x44444443L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("PageList", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("Pallet", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("PalletizingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("PDLCreationParams", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("PerforatingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("PreflightParams", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("PreflightProfile", 0x44444433L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("PreflightReport", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("PreflightReportRulePool", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("Preview", 0x33333333L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("PrintCondition", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("PrintRollingParams", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("ProductionPath", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("ProofingParams", 0x44444433L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("QualityControlParams", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("RasterReadingParams", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("RegisterRibbon", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("RollStand", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("SaddleStitchingParams", 0x44444443L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("ScavengerArea", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("ShapeCuttingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("Sheet", 0x44444333L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("ShrinkingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("SideSewingParams", 0x44444443L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("SpinePreparationParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("SpineTapingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("StackingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("Strap", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("StrappingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("StripBindingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("StrippingParams", 0x33333311L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("Surface", 0x44444333L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("ThreadSealingParams", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("Tool", 0x33333331L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("UsageCounter", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("WebInlineFinishingParams", 0x33333111L);
        JDFResourcePool.elemInfoTable[i++] = new ElemInfoTable("WrappingParams", 0x33333331L);
    }
}

