/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.List;
import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoColorantControl;
import org.cip4.jdflib.core.JDFSeparationList;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFColorPool;
import org.cip4.jdflib.resource.process.JDFColorantAlias;
import org.cip4.jdflib.resource.process.JDFDeviceNSpace;
import org.w3c.dom.DOMException;

public class JDFColorantControl
extends JDFAutoColorantControl {
    private static final long serialVersionUID = 1L;

    public JDFColorantControl(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFColorantControl(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFColorantControl(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFColorantControl[  --> " + super.toString() + " ]";
    }

    @Override
    public Vector<JDFResource.EnumPartIDKey> getImplicitPartitions() {
        Vector<JDFResource.EnumPartIDKey> v = super.getImplicitPartitions();
        if (v == null) {
            v = new Vector();
        }
        v.add(JDFResource.EnumPartIDKey.Separation);
        return v;
    }

    public VString getDeviceColorantOrderSeparations() {
        StringArray tmp = this.getSeparations("DeviceColorantOrder");
        return tmp == null ? this.getColorantOrderSeparations() : new VString(tmp);
    }

    StringArray getSeparations(String listName) {
        if (this.hasChildElement(listName, null)) {
            JDFSeparationList sl = (JDFSeparationList)this.getElement(listName);
            return sl.getSeparationList();
        }
        if (this.hasNonEmpty(listName)) {
            return new StringArray(this.getNonEmpty(listName));
        }
        return null;
    }

    public VString getColorantOrderSeparations() {
        StringArray tmp = this.getSeparations("ColorantOrder");
        return tmp == null ? this.getSeparations() : new VString(tmp);
    }

    public VString getAllSeparations() {
        List<JDFResource> e = this.getLeafArray(false);
        if (e == null) {
            return null;
        }
        VString allCols = new VString();
        for (int i = 0; i < e.size(); ++i) {
            allCols.addAll(((JDFColorantControl)e.get(i)).getSeparations());
        }
        allCols.unify();
        return allCols;
    }

    public VString getSeparations() {
        if (this.hasAttribute("ColorantParams") && !this.hasChildElement("ColorantParams", null)) {
            return new VString(this.getSeparations("ColorantParams"));
        }
        VString vName = this.getProcessSeparations();
        vName.appendUnique(this.getSeparations("ColorantParams"));
        return vName;
    }

    public VString getProcessSeparations() {
        JDFDeviceNSpace deviceNSpace;
        VString vName = new VString();
        String model = this.getProcessColorModel();
        if ("DeviceCMY".equals(model)) {
            vName.add("Cyan");
            vName.add("Magenta");
            vName.add("Yellow");
        } else if ("DeviceCMYK".equals(model)) {
            vName.add("Cyan");
            vName.add("Magenta");
            vName.add("Yellow");
            vName.add("Black");
        } else if ("DeviceGray".equals(model)) {
            vName.add("Black");
        } else if ("DeviceRGB".equals(model)) {
            vName.add("Red");
            vName.add("Green");
            vName.add("Blue");
        } else if ("DeviceN".equals(model) && (deviceNSpace = this.getDeviceNSpace(0)) != null) {
            vName = deviceNSpace.getSeparations();
        }
        return vName;
    }

    @Override
    public JDFColorPool getCreateColorPool() {
        JDFColorPool cp = this.getColorPool();
        return cp == null ? super.getCreateColorPool() : cp;
    }

    public JDFColorantAlias getColorantAlias(String sourceColor) {
        List<JDFColorantAlias> vcc = this.getChildArrayByClass(JDFColorantAlias.class, false, 0);
        for (JDFColorantAlias ca : vcc) {
            VString seps = ca.getSeparations();
            if (!seps.contains(sourceColor)) continue;
            return ca;
        }
        return null;
    }

    public JDFColorantAlias getColorantAliasForReplacement(String replacementColor) {
        return this.getChildWithAttribute(JDFColorantAlias.class, "ReplacementColorantName", replacementColor);
    }

    public JDFColorantAlias getCreateColorantAliasForReplacement(String replacementColor) {
        JDFColorantAlias c = this.getColorantAliasForReplacement(replacementColor);
        if (c == null) {
            c = this.appendColorantAlias();
            c.setReplacementColorantName(replacementColor);
        }
        return c;
    }

    public JDFAttributeMap getColorantAliasMap() {
        JDFAttributeMap map = new JDFAttributeMap();
        List<JDFColorantAlias> vcc = this.getChildArrayByClass(JDFColorantAlias.class, false, 0);
        for (JDFColorantAlias ca : vcc) {
            VString seps = ca.getSeparations();
            String target = ca.getReplacementColorantName();
            for (String sep : seps) {
                map.put(sep, target);
            }
        }
        return map;
    }

    public void removeProcessColors() {
        JDFSeparationList params;
        VString processSeps = this.getProcessSeparations();
        if (!processSeps.isEmpty() && (params = this.getColorantParams()) != null) {
            VString oldList = params.getSeparations();
            oldList.removeAll(processSeps);
            if (oldList.isEmpty()) {
                params.deleteNode();
            } else {
                params.setSeparations(oldList);
            }
        }
    }

    public JDFColorantAlias appendColorantAlias(String source, String replacement) {
        JDFColorantAlias ca = this.getCreateColorantAliasForReplacement(replacement);
        ca.setReplacementColorantName(replacement);
        ca.appendSeparationSpec().setName(source);
        return ca;
    }
}

