/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPageData;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.resource.JDFPageList;
import org.cip4.jdflib.resource.process.JDFContentData;
import org.cip4.jdflib.resource.process.JDFPageElement;
import org.w3c.dom.DOMException;

public class JDFPageData
extends JDFAutoPageData {
    private static final long serialVersionUID = 1L;

    public JDFPageData(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPageData(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPageData(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFPageData[  --> " + super.toString() + " ]";
    }

    public void refContentData(JDFContentData letter) {
        JDFPageElement pe = this.appendPageElement();
        if (letter != null) {
            pe.setContentListIndex(letter.getIndex());
        }
    }

    @Override
    public JDFIntegerRangeList getPageIndex() {
        JDFIntegerRangeList pi = super.getPageIndex();
        if (pi != null && pi.size() > 0) {
            return pi;
        }
        int n = 0;
        for (KElement prev = this.getPreviousSiblingElement("PageData", null); prev != null; prev = prev.getPreviousSiblingElement("PageData", null)) {
            ++n;
        }
        JDFIntegerRangeList integerRangeList = new JDFIntegerRangeList();
        integerRangeList.append(n);
        return integerRangeList;
    }

    @Override
    public String getAssemblyID() {
        if (this.hasAttribute("AssemblyID")) {
            return super.getAssemblyID();
        }
        JDFPageList parent = this.getPageList();
        if (parent != null) {
            return parent.getAssemblyID();
        }
        return super.getAssemblyID();
    }

    public JDFPageList getPageList() {
        KElement parent = this.getParentNode_KElement();
        return parent instanceof JDFPageList ? (JDFPageList)parent : null;
    }

    public void setPageIndex(int value) {
        this.setAttribute("PageIndex", value, (String)null);
    }
}

