/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.List;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.resource.JDFResource;

public class JDFSourceResource
extends JDFElement {
    private static final long serialVersionUID = 1L;

    public JDFSourceResource(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFSourceResource(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFSourceResource(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    public JDFRefElement getRefElement() {
        KElement e = this.getFirstChildElement();
        while (!(e instanceof JDFRefElement)) {
            if (e == null) {
                return null;
            }
            e = e.getNextSiblingElement();
        }
        return (JDFRefElement)e;
    }

    public JDFResource getLinkRoot() {
        JDFRefElement refElement = this.getRefElement();
        JDFResource r = null;
        if (refElement != null) {
            r = refElement.getLinkRoot(null);
        }
        return r;
    }

    @Override
    public JDFResource getTarget() {
        JDFRefElement refElement = this.getRefElement();
        JDFResource r = null;
        if (refElement != null) {
            r = refElement.getTarget();
        }
        return r;
    }

    @Override
    public VString getUnknownElements(boolean bIgnorePrivate, int nMax) {
        return this.getUnknownPoolElements(JDFElement.EnumPoolType.RefElement, nMax);
    }

    @Override
    public VString getInvalidElements(JDFElement.EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        VString v = super.getInvalidElements(level, bIgnorePrivate, nMax);
        if (v.size() >= nMax) {
            return v;
        }
        List<KElement> v2 = this.getChildArray_KElement(null, null, null, true, 0);
        int n = 0;
        for (KElement e : v2) {
            if (!(e instanceof JDFRefElement)) continue;
            ++n;
        }
        if (n > 1) {
            for (KElement e : v2) {
                if (!(e instanceof JDFRefElement)) continue;
                v.appendUnique(e.getLocalName());
            }
        }
        return v;
    }

    public String getSourceLocalName() {
        JDFRefElement refElement = this.getRefElement();
        if (refElement != null) {
            return refElement.getRefLocalName();
        }
        return null;
    }

    public String getSourceID() {
        JDFRefElement refElement = this.getRefElement();
        if (refElement != null) {
            return refElement.getrRef();
        }
        return null;
    }

    public String getSourcefNodeName() {
        JDFRefElement refElement = this.getRefElement();
        if (refElement != null) {
            return refElement.getRefNodeName();
        }
        return null;
    }

    public JDFElement deleteRef(boolean bCheckRefCount) {
        JDFRefElement refElement = this.getRefElement();
        if (refElement != null) {
            return refElement.deleteRef(bCheckRefCount);
        }
        return null;
    }

    @Override
    public VString getMissingElements(int nMax) {
        VString vs = this.getElementInfo().requiredElements();
        vs = this.getMissingElementVector(vs, nMax);
        VElement v2 = this.getChildElementVector_KElement(null, null, null, true, 0);
        int n = 0;
        for (int i = 0; i < v2.size(); ++i) {
            if (!(v2.elementAt(i) instanceof JDFRefElement)) continue;
            ++n;
        }
        if (n == 0) {
            vs.add("RefElement");
        }
        return vs;
    }
}

