/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Vector;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.mime.BodyPartHelper;
import org.cip4.jdflib.util.mime.MimeHelper;
import org.cip4.jdflib.util.mime.MimeReader;
import org.cip4.jdflib.util.mime.MimeWriter;
import org.cip4.jdflib.util.net.HTTPDetails;

public class MimeUtil
extends UrlUtil {
    public static final String CID = "cid:";
    public static final String MULTIPART_RELATED = "multipart/related";
    public static final String MULTIPART_FORMDATA = "multipart/form-data";

    public static void setContentID(BodyPart bp, String cid) {
        new BodyPartHelper(bp).setContentID(cid);
    }

    public static void setFileName(BodyPart bp, String path) {
        new BodyPartHelper(bp).setFileName(path);
    }

    public static String getFileName(BodyPart bp) {
        return new BodyPartHelper(bp).getFileName();
    }

    public static String getContentID(BodyPart bp) {
        return new BodyPartHelper(bp).getContentID();
    }

    public static BodyPart[] extractMultipartMime(InputStream mimeStream) {
        MimeReader mr = new MimeReader(mimeStream);
        return mr.getBodyParts();
    }

    public static BodyPart[] getBodyParts(Multipart mp) {
        return new MimeHelper(mp).getBodyParts();
    }

    public static BodyPart getPartByCID(Multipart mp, String cid) {
        return new MimeHelper(mp).getPartByCID(cid);
    }

    public static BodyPartHelper getPartByFileName(Multipart mp, String name) {
        return new MimeHelper(mp).getPartHelperByLocalName(name);
    }

    public static BodyPart getCreatePartByCID(Multipart mp, String cid) {
        return new MimeWriter(mp).getCreatePartByCID(cid);
    }

    public static JDFDoc getJDFDoc(InputStream stream, int index) {
        MimeReader mr = new MimeReader();
        return mr.getJDFDoc(stream, index);
    }

    public static JDFDoc getJDFDoc(BodyPart bp) {
        return new BodyPartHelper(bp).getJDFDoc();
    }

    public static boolean matchesCID(BodyPart bp, String cid) {
        String s;
        if (cid == null) {
            return true;
        }
        if (cid.startsWith("<")) {
            cid = cid.substring(1);
        }
        if (cid.toLowerCase().startsWith(CID)) {
            cid = cid.substring(4);
        }
        if (cid.endsWith(">")) {
            cid = cid.substring(0, cid.length() - 1);
        }
        if ((s = MimeUtil.getContentID(bp)) == null) {
            return false;
        }
        return cid.equalsIgnoreCase(s);
    }

    public static Multipart getMultiPart(String fileName) {
        MimeReader r = new MimeReader(fileName);
        return r.getMultiPart();
    }

    public static Multipart getMultiPart(InputStream mimeStream) {
        return new MimeReader(mimeStream).getMultiPart();
    }

    @Deprecated
    public static String getMimeTypeFromExt(String fileName) {
        return UrlUtil.getMimeTypeFromURL(fileName);
    }

    public static boolean isJDFMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return "application/vnd.cip4-jdf+xml".equalsIgnoreCase(mimeType = StringUtil.token(mimeType, 0, ";")) || "application/vnd.cip4-xjdf+xml".equalsIgnoreCase(mimeType) || "application/vnd.cip4-jmf+xml".equalsIgnoreCase(mimeType) || "application/vnd.cip4-xjmf+xml".equalsIgnoreCase(mimeType) || "text/xml".equalsIgnoreCase(mimeType) || "application/xml".equalsIgnoreCase(mimeType);
    }

    public static boolean isPPFMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        mimeType = StringUtil.token(mimeType, 0, ";");
        return "application/vnd.cip4-ppf".equalsIgnoreCase(mimeType);
    }

    public static boolean isMimeType(String toCheck, String mimeType) {
        if (toCheck == null) {
            return false;
        }
        toCheck = StringUtil.token(toCheck, 0, ";").trim();
        return mimeType.equalsIgnoreCase(toCheck);
    }

    @Deprecated
    public static Multipart buildMimePackage(JDFDoc docJMF, JDFDoc docJDF) {
        return MimeUtil.buildMimePackage(docJMF, docJDF, true);
    }

    public static Multipart buildMimePackage(JDFDoc docJMF, XMLDoc docJDF, boolean extendReferenced) {
        MimeWriter mimeWriter = new MimeWriter();
        mimeWriter.buildMimePackage(docJMF, docJDF, extendReferenced);
        return mimeWriter.getMultiPart();
    }

    public static String urlToCid(String urlString) {
        return MimeUtil.urlToCid(urlString, false);
    }

    public static String urlToCid(String urlString, boolean raw) {
        String normalized = urlString;
        if (normalized == null) {
            return null;
        }
        if (normalized.startsWith("<")) {
            normalized = normalized.substring(1);
        }
        if (normalized.toLowerCase().startsWith(CID)) {
            normalized = normalized.substring(4);
        }
        if (normalized.endsWith(">")) {
            normalized = normalized.substring(0, normalized.length() - 1);
        }
        if (!raw) {
            normalized = StringUtil.normalizeASCII(urlString);
        }
        return CID + normalized;
    }

    public static Multipart buildMimePackage(Vector<? extends XMLDoc> vXMLDocs) {
        MimeWriter mimeWriter = new MimeWriter();
        mimeWriter.buildMimePackage(vXMLDocs);
        return mimeWriter.getMultiPart();
    }

    public static BodyPart updateXMLMultipart(Multipart multipart, XMLDoc xmlDoc, String cid) {
        return new MimeWriter(multipart).updateXMLMultipart(xmlDoc, cid);
    }

    public static void setContent(BodyPart messageBodyPart, XMLDoc xmlDoc) throws MessagingException, IOException {
        new BodyPartHelper(messageBodyPart).setContent(xmlDoc);
    }

    public static HttpURLConnection writeToURL(Multipart mp, String strUrl) throws IOException, MessagingException {
        return MimeUtil.writeToURL(mp, strUrl, null);
    }

    public static HttpURLConnection writeToURL(Multipart mp, String strUrl, MIMEDetails mimeDetails) throws IOException, MessagingException {
        MimeWriter mimeWriter = new MimeWriter(mp);
        mimeWriter.setMIMEDetails(mimeDetails);
        UrlPart part = mimeWriter.writeToURL(strUrl);
        return part != null && part.getConnection() instanceof HttpURLConnection ? (HttpURLConnection)part.getConnection() : null;
    }

    public static JDFDoc writeToQueue(JDFDoc docJMF, JDFDoc docJDF, String strUrl, MIMEDetails urlDet) throws IOException, MessagingException {
        MimeWriter mw = new MimeWriter();
        mw.setMIMEDetails(urlDet);
        return mw.writeToQueue(docJMF, docJDF, strUrl, false);
    }

    @Deprecated
    public static File writeToFile(Multipart m, String fileName) {
        return MimeUtil.writeToFile(m, fileName, null);
    }

    public static File writeToFile(Multipart m, String fileName, MIMEDetails md) {
        MimeWriter mw = new MimeWriter(m);
        mw.setMIMEDetails(md);
        return mw.writeToFile(fileName);
    }

    @Deprecated
    public static void writeToStream(Multipart m, OutputStream outStream) throws IOException, MessagingException {
        MimeUtil.writeToStream(m, outStream, null);
    }

    public static void writeToStream(Multipart m, OutputStream outStream, MIMEDetails md) throws IOException, MessagingException {
        MimeWriter mimeWriter = new MimeWriter(m);
        mimeWriter.setMIMEDetails(md);
        mimeWriter.writeToStream(outStream);
    }

    public static void writeToDir(Multipart mp, File directory) throws MessagingException, IOException {
        new MimeWriter(mp).writeToDir(directory);
    }

    public static void writeBodyPartToFile(BodyPart bp, File directory) throws IOException, MessagingException {
        new BodyPartHelper(bp).writeToDir(directory);
    }

    public static JDFDoc[] getJMFSubmission(Multipart mp) {
        JDFJMF jmfRoot;
        BodyPart[] bp = MimeUtil.getBodyParts(mp);
        if (bp == null || bp.length < 1) {
            return null;
        }
        JDFDoc jmf = MimeUtil.getJDFDoc(bp[0]);
        JDFJMF jDFJMF = jmfRoot = jmf == null ? null : jmf.getJMFRoot();
        if (jmfRoot == null) {
            return null;
        }
        String subURL = jmfRoot.getSubmissionURL();
        if (subURL == null) {
            return new JDFDoc[]{jmf};
        }
        BodyPart bpJDF = MimeUtil.getPartByCID(mp, subURL);
        JDFDoc[] docs = new JDFDoc[]{jmf, MimeUtil.getJDFDoc(bpJDF)};
        if (docs[1] == null) {
            return new JDFDoc[]{jmf};
        }
        return docs;
    }

    public static boolean isMimeMultiPart(String contentType) {
        return MimeUtil.isMimeType(contentType, MULTIPART_RELATED);
    }

    public static class ByteArrayDataSource
    implements DataSource {
        String contentType;
        ByteArrayIOStream ioStream;
        String name;

        void setName(String name) {
            this.name = name;
        }

        public ByteArrayDataSource(ByteArrayIOStream _ioStream, String _contentType) {
            this.contentType = _contentType;
            this.ioStream = _ioStream;
            this.name = null;
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() {
            return this.ioStream.getInputStream();
        }

        public String getName() {
            return this.name;
        }

        public OutputStream getOutputStream() {
            return this.ioStream;
        }
    }

    public static class MIMEDetails {
        public static String defaultTransferEncoding = "binary";
        public HTTPDetails httpDetails = new HTTPDetails();
        public String transferEncoding = defaultTransferEncoding;
        public boolean modifyBoundarySemicolon = false;

        public String toString() {
            return "MIMEDetails [httpDetails=" + this.httpDetails + ", transferEncoding=" + this.transferEncoding + ", modifyBoundarySemicolon=" + this.modifyBoundarySemicolon + "]";
        }
    }
}

