/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class StringArray
extends ArrayList<String> {
    private static final long serialVersionUID = 1L;

    public static boolean isEmpty(Collection<String> v) {
        return StringUtil.isEmpty(v);
    }

    public StringArray() {
    }

    public StringArray(Collection<String> m) {
        if (m != null) {
            this.addAll(m);
        }
    }

    public StringArray(String strIn) {
        this(strIn, null);
    }

    public static StringArray getVString(String strIn, String strSep) {
        return StringUtil.getNonEmpty(strIn) == null ? null : new StringArray(strIn, strSep);
    }

    public StringArray(String strIn, String strSep) {
        StringUtil.tokenize(this, strIn, strSep);
    }

    public StringArray(String[] a) {
        super(a == null ? 0 : a.length);
        int l = a == null ? 0 : a.length;
        for (int i = 0; i < l; ++i) {
            this.add(a[i]);
        }
    }

    @Override
    public String get(int index) {
        int i = ContainerUtil.index(this, index);
        return i >= 0 ? (String)super.get(i) : null;
    }

    public void appendUnique(String string) {
        ContainerUtil.appendUnique(this, string);
    }

    public void appendUnique(Collection<String> v) {
        ContainerUtil.appendUnique(this, v);
    }

    public String getString(String sep, String front, String back) {
        return StringUtil.setvString(this, sep, front, back);
    }

    public String getString() {
        return StringUtil.setvString(this, " ", null, null);
    }

    public void unify() {
        ContainerUtil.unify(this);
    }

    public Set<String> getSet() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            set.add((String)it.next());
        }
        return set;
    }

    public void addAll(String[] strings) {
        this.ensureCapacity(this.size() + strings.length);
        ContainerUtil.addAll(this, strings);
    }

    public boolean containsAny(Collection<String> others) {
        return ContainerUtil.containsAny(this, others);
    }

    public StringArray getOverlapping(Collection<String> others) {
        if (others == null) {
            return null;
        }
        StringArray ret = new StringArray();
        for (String s : this) {
            if (!others.contains(s)) continue;
            ret.add(s);
        }
        return ret.size() > 0 ? ret : null;
    }

    @Override
    public String remove(int index) {
        int i = ContainerUtil.index(this, index);
        return i < 0 ? null : (String)super.remove(i);
    }

    public void addNonEmpty(String text) {
        String t2 = StringUtil.getNonEmpty(text);
        if (t2 != null) {
            this.add(t2);
        }
    }
}

