/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.util.HashUtil;

public class JDFShape
extends JDFNumList {
    private static final long serialVersionUID = 1L;

    public static JDFShape createShape(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            return new JDFShape(s);
        }
        catch (DataFormatException x) {
            return null;
        }
    }

    public JDFShape() {
        super(3);
    }

    @Deprecated
    public JDFShape(Vector v) throws DataFormatException {
        super(v);
    }

    public JDFShape(String s) throws DataFormatException {
        super(s);
    }

    public JDFShape(JDFNumList nl) throws DataFormatException {
        super(nl);
    }

    public JDFShape(JDFShape nl) {
        this.addAll(nl);
    }

    public void swapXY() {
        double tmp = this.getX();
        this.setX(this.getY());
        this.setY(tmp);
    }

    public JDFShape(double x, double y, double z) {
        super(3);
        this.setY(y);
        this.setX(x);
        this.setZ(z);
    }

    public JDFShape(double x, double y) {
        super(3);
        this.setY(y);
        this.setX(x);
        this.setZ(0.0);
    }

    @Override
    public boolean isValid() throws DataFormatException {
        if (this.size() > 3 || this.size() < 1) {
            throw new DataFormatException("Data format exception! size=" + this.size());
        }
        for (Object o : this) {
            if (o instanceof Double) continue;
            throw new DataFormatException("Data format exception!");
        }
        if (this.size() == 1) {
            this.addElement(0.0);
        }
        if (this.size() == 2) {
            this.addElement(0.0);
        }
        return true;
    }

    @Override
    public synchronized boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        JDFShape shape = (JDFShape)other;
        return Math.abs(this.getY() - shape.getY()) <= 1.0E-6 && Math.abs(this.getX() - shape.getX()) <= 1.0E-6 && Math.abs(this.getZ() - shape.getZ()) <= 1.0E-6;
    }

    @Override
    public synchronized int hashCode() {
        return HashUtil.hashCode(super.hashCode(), this.toString());
    }

    public boolean isGreaterOrEqual(JDFShape x) {
        return this.equals(x) || this.getY() >= x.getY() && this.getX() >= x.getX() && this.getZ() >= x.getZ();
    }

    public boolean isLessOrEqual(JDFShape x) {
        return this.equals(x) || this.getY() <= x.getY() && this.getX() <= x.getX() && this.getZ() <= x.getZ();
    }

    public boolean isGreater(JDFShape x) {
        return !this.equals(x) && this.getY() >= x.getY() && this.getX() >= x.getX() && this.getZ() >= x.getZ();
    }

    public boolean isLess(JDFShape x) {
        return !this.equals(x) && this.getY() <= x.getY() && this.getX() <= x.getX() && this.getZ() <= x.getZ();
    }

    @Deprecated
    public double getHeight() {
        return this.getY();
    }

    public double getY() {
        return this.doubleAt(1);
    }

    @Deprecated
    public void setHeight(double height) {
        this.setY(height);
    }

    public void setY(double y) {
        this.set(1, y);
    }

    @Deprecated
    public double getWidth() {
        return this.getX();
    }

    public double getX() {
        return this.doubleAt(0);
    }

    public void setX(double x) {
        this.set(0, x);
    }

    @Deprecated
    public void setWidth(double width) {
        this.setX(width);
    }

    @Deprecated
    public double getLength() {
        return this.getZ();
    }

    public double getZ() {
        return this.doubleAt(2);
    }

    @Deprecated
    public void setLength(double length) {
        this.setZ(length);
    }

    public void setZ(double z) {
        this.set(2, z);
    }
}

