/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.zip.DataFormatException;
import org.apache.commons.lang.time.FastDateFormat;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.JDFDuration;
import org.cip4.jdflib.util.NumberFormatter;
import org.cip4.jdflib.util.StringUtil;

public class JDFDate
implements Comparable<Object>,
Cloneable,
Comparator<JDFDate> {
    private long lTimeInMillis;
    private int m_TimeZoneOffsetInMillis;
    private static int defaultHour = 12;
    private static boolean wantISOMilliseconds = false;
    private static FastCalendar fastCalendar = new FastCalendar();
    public static final String DATEISO = "yyyy'-'MM'-'dd'";
    static final String TIMEISO = "HH:mm:ss";
    static final String TIMEISO_MILLI = "HH:mm:ss.SSS";
    public static final String DATETIMEISO = "yyyy'-'MM'-'dd'T'HH:mm:ssZZ";
    public static final String DATETIMEISO_MILLI = "yyyy'-'MM'-'dd'T'HH:mm:ss.SSSZZ";
    public static final String DATETIMEISO_0 = "yyyy'-'MM'-'dd'T'HH:mm:'00'ZZ";
    public static final String DATETIMEISO_00 = "yyyy'-'MM'-'dd'T'HH:'00':'00'ZZ";
    public static final String DATETIMEISO_000 = "yyyy'-'MM'-'dd'T00':'00':'00'ZZ";
    public static final String DATETIMEREADABLE = "dd MMM yyyy HH:mm";
    public static final String DATENUMERIC_DDMM = "dd/MM/yyyy";
    public static final String DATENUMERIC_MMDD = "MM/dd/yyyy";
    public static final String DATETIMENUMERIC_DDMM = "dd/MM/yyyy HH:mm";
    public static final String DATETIMENUMERIC_MMDD = "MM/dd/yyyy HH:mm";

    public static boolean isWantISOMilliseconds() {
        return wantISOMilliseconds;
    }

    public static void setWantISOMilliseconds(boolean wantISOMilliseconds) {
        JDFDate.wantISOMilliseconds = wantISOMilliseconds;
    }

    public static void setDefaultHour(int defaultHour) {
        if (defaultHour >= 0 && defaultHour <= 23) {
            JDFDate.defaultHour = defaultHour;
        }
    }

    public static int getDefaultHour() {
        return defaultHour;
    }

    public JDFDate() {
        this(System.currentTimeMillis());
    }

    public JDFDate(long iTime) {
        try {
            new StringHandler(iTime).handle();
        }
        catch (DataFormatException e) {
            this.lTimeInMillis = iTime;
            this.m_TimeZoneOffsetInMillis = TimeZone.getDefault().getOffset(iTime);
        }
    }

    public JDFDate(JDFDate other) {
        this();
        if (other != null) {
            this.lTimeInMillis = other.lTimeInMillis;
            this.m_TimeZoneOffsetInMillis = other.m_TimeZoneOffsetInMillis;
        }
    }

    public JDFDate(String strDateTime) throws DataFormatException {
        this.lTimeInMillis = 0L;
        this.m_TimeZoneOffsetInMillis = 0;
        this.init(strDateTime, -1, -1);
    }

    public JDFDate(String strDateTime, int defaultHour, int defaultMinute) throws DataFormatException {
        this.lTimeInMillis = 0L;
        this.m_TimeZoneOffsetInMillis = 0;
        this.init(strDateTime, defaultHour, defaultMinute);
    }

    public static JDFDate createDate(String date) {
        if ((date = StringUtil.normalize(date, false, null)) == null) {
            return null;
        }
        try {
            return new JDFDate(date);
        }
        catch (DataFormatException e) {
            return null;
        }
    }

    public String toString() {
        return "JDFDate[ " + this.getDateTimeISO() + "]";
    }

    private void init(String strDateTime, int h, int m) throws DataFormatException {
        if (StringUtil.isEmpty(strDateTime)) {
            this.lTimeInMillis = System.currentTimeMillis();
            this.m_TimeZoneOffsetInMillis = TimeZone.getDefault().getOffset(this.lTimeInMillis);
            return;
        }
        try {
            StringHandler stringHandler = new StringHandler(strDateTime, h, m);
            stringHandler.handle();
        }
        catch (IndexOutOfBoundsException ie) {
            throw new DataFormatException("JDFDate.init: invalid date String " + strDateTime);
        }
        catch (NumberFormatException ne) {
            throw new DataFormatException("JDFDate.init: invalid date String " + strDateTime);
        }
    }

    public String getFormattedDateTime(String format) {
        return this.getDateFormat(format).format((Calendar)this.getCalendar());
    }

    public String getDateTime() {
        return this.getFormattedDateTime("yyyyMMddHHmmss");
    }

    @Deprecated
    public void setOffset(int iOffset) {
        this.addOffset(iOffset, 0, 0, 0);
    }

    public JDFDate addOffset(int seconds, int minutes, int hours, int days) {
        this.lTimeInMillis += 1000L * ((long)seconds + 60L * (long)minutes + 3600L * (long)hours + 86400L * (long)days);
        return this;
    }

    public JDFDate createDateFromDuration(JDFDuration duration, int hour, int minute) {
        JDFDate d = new JDFDate(this);
        if (duration != null) {
            d.setTimeInMillis(d.getTimeInMillis() + duration.getDurationMillis());
        }
        if (hour >= 0 && minute >= 0) {
            d.setTime(hour, minute, 0);
        }
        return d;
    }

    public String getDateTimeISO() {
        return this.getFormattedDateTime(wantISOMilliseconds ? DATETIMEISO_MILLI : DATETIMEISO);
    }

    @Deprecated
    public String getDateTimeISOBD() {
        String timePatternBD = DATEISO;
        return this.getDateFormat(DATEISO).format(this.lTimeInMillis);
    }

    private FastDateFormat getDateFormat(String timePattern) {
        return FastDateFormat.getInstance((String)timePattern, (TimeZone)new SimpleTimeZone(this.getTimeZoneOffsetInMillis(), ""));
    }

    public String getDateISO() {
        return this.getFormattedDateTime(DATEISO);
    }

    public String getTimeISO() {
        return this.getFormattedDateTime(wantISOMilliseconds ? TIMEISO_MILLI : TIMEISO);
    }

    public String getTimeZoneISO() {
        String timePattern = "ZZ";
        long t = this.lTimeInMillis;
        if (t < 5000L) {
            t = System.currentTimeMillis();
        }
        return this.getDateFormat("ZZ").format(t);
    }

    public boolean isLater(JDFDate x) {
        long timeInMillis = x == null ? 0L : x.getTimeInMillis();
        return this.lTimeInMillis > timeInMillis;
    }

    public boolean isEarlier(JDFDate x) {
        long timeInMillis = x == null ? 0L : x.getTimeInMillis();
        return this.lTimeInMillis < timeInMillis;
    }

    public long getTimeInMillis() {
        return this.lTimeInMillis;
    }

    public JDFDate setTimeInMillis(long l) {
        this.lTimeInMillis = l;
        return this;
    }

    public GregorianCalendar getCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(new SimpleTimeZone(this.getTimeZoneOffsetInMillis(), ""));
        gregorianCalendar.setTimeInMillis(this.getTimeInMillis());
        return gregorianCalendar;
    }

    public JDFDate setTime(int h, int m, int s) {
        this.lTimeInMillis = (this.lTimeInMillis + 500L) / 1000L * 1000L;
        String st = this.getFormattedDateTime(DATETIMEISO_000);
        try {
            this.init(st, -1, -1);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        this.addOffset(s, m, h, 0);
        return this;
    }

    @Deprecated
    public boolean before(JDFDate other) {
        return this.isEarlier(other);
    }

    public boolean before(long other) {
        return this.lTimeInMillis < other;
    }

    @Deprecated
    public boolean after(JDFDate other) {
        return this.isLater(other);
    }

    public boolean after(long other) {
        return this.lTimeInMillis > other;
    }

    @Deprecated
    public Date getTime() {
        return new Date(this.lTimeInMillis);
    }

    public int getMonth() {
        return 1 + this.getCalendar().get(2);
    }

    public int getYear() {
        return this.getCalendar().get(1);
    }

    public int getDay() {
        return this.getCalendar().get(5);
    }

    @Deprecated
    public void setTime(Date date) {
        this.lTimeInMillis = date.getTime();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return this.getTimeInMillis() / 1000L == ((JDFDate)other).getTimeInMillis() / 1000L;
    }

    public int hashCode() {
        return (int)(this.getTimeInMillis() / 1000L);
    }

    @Override
    public int compareTo(Object arg0) {
        if (arg0 instanceof String) {
            String s = (String)arg0;
            try {
                return this.compareTo(new JDFDate(s));
            }
            catch (DataFormatException x) {
                return 1;
            }
        }
        if (!(arg0 instanceof JDFDate)) {
            return 1;
        }
        return (int)(this.getTimeInMillis() / 100L) - (int)(((JDFDate)arg0).getTimeInMillis() / 100L);
    }

    public JDFDate setTimeZoneOffsetInMillis(int timeZoneOffsetInMillis) {
        this.m_TimeZoneOffsetInMillis = timeZoneOffsetInMillis;
        return this;
    }

    public int getTimeZoneOffsetInMillis() {
        return this.m_TimeZoneOffsetInMillis;
    }

    public JDFDate clone() {
        return new JDFDate(this);
    }

    @Override
    public int compare(JDFDate d0, JDFDate d1) {
        return ContainerUtil.compare(d0, d1);
    }

    public int getHour() {
        return this.getCalendar().get(11);
    }

    public int getMinute() {
        return this.getCalendar().get(12);
    }

    public int getSecond() {
        return this.getCalendar().get(13);
    }

    public void setYear(int newYear) {
        String s = this.getDateTimeISO();
        JDFDate snew = JDFDate.createDate(s = StringUtil.replaceToken(s, 0, "-", StringUtil.rightStr("0000" + Integer.valueOf(newYear), 4)));
        if (snew != null) {
            this.setTimeInMillis(snew.getTimeInMillis());
        }
    }

    private class StringHandler {
        private String strDateTime;
        private long l;
        private boolean timezoneSet;
        private int defaultH;
        private int defaultM;

        StringHandler(String strDateTime, int h, int m) {
            this.strDateTime = strDateTime;
            this.timezoneSet = true;
            this.defaultH = h >= 0 ? h : defaultHour;
            this.defaultM = m >= 0 ? m : 0;
            this.l = strDateTime.indexOf(45) >= 0 ? -1L : StringUtil.parseLong(strDateTime, -1L);
        }

        StringHandler(long millis) {
            this.strDateTime = "";
            this.l = millis;
        }

        private void handle() throws DataFormatException {
            if (this.l > 5000L) {
                this.handleLongValue();
            } else {
                this.handleISOValue();
            }
        }

        private String handleZulu(String strDateTime) throws DataFormatException {
            int iCmp;
            boolean bZulu;
            int length = ((String)strDateTime).length();
            char lastChar = ((String)strDateTime).charAt(length - 1);
            if (lastChar >= 'a' && lastChar <= 'z') {
                lastChar = (char)(lastChar - 32);
            }
            boolean bl = bZulu = (iCmp = lastChar - 65) >= 0 && iCmp <= 25;
            if (bZulu) {
                String strBuffer = ((String)strDateTime).substring(0, length - 1);
                Object bias = null;
                if (iCmp >= 0 && iCmp <= 8) {
                    bias = "+0" + String.valueOf(iCmp + 1);
                } else {
                    if (iCmp == 9) {
                        throw new DataFormatException("JDFDate.init: invalid date String " + (String)strDateTime);
                    }
                    if (iCmp >= 10 && iCmp <= 12) {
                        bias = "+" + String.valueOf(iCmp);
                    } else if (iCmp >= 13 && iCmp <= 21) {
                        bias = "-0" + String.valueOf(iCmp - 12);
                    } else if (iCmp >= 22 && iCmp <= 24) {
                        bias = "-1" + String.valueOf(iCmp - 22);
                    } else if (iCmp == 25) {
                        bias = "+00";
                    }
                }
                bias = (String)bias + ":00";
                strDateTime = strBuffer + (String)bias;
            } else if (((String)strDateTime).charAt(length - 6) != '+' && ((String)strDateTime).charAt(length - 6) != '-') {
                if (lastChar == ':') {
                    strDateTime = (String)strDateTime + "00";
                    length += 2;
                }
                int posColon = ((String)strDateTime).lastIndexOf(58);
                int posPlus = ((String)strDateTime).lastIndexOf(43);
                int posMinus = ((String)strDateTime).lastIndexOf(45);
                int posPM = Math.max(posMinus, posPlus);
                if (posPM == length - 5 && posColon > posPM) {
                    strDateTime = StringUtil.leftStr((String)strDateTime, -4) + "0" + StringUtil.rightStr((String)strDateTime, 4);
                }
                if (posColon < posPM && length - posPM < 3) {
                    strDateTime = (String)strDateTime + ":00";
                    if (posPM == length - 2) {
                        strDateTime = StringUtil.leftStr((String)strDateTime, -4) + "0" + StringUtil.rightStr((String)strDateTime, 4);
                    }
                }
            }
            return strDateTime;
        }

        private void handleISOValue() throws DataFormatException {
            this.addMissingTime();
            this.strDateTime = this.handleZulu(this.strDateTime);
            int decimalLength = this.handleDecimal();
            this.handleTimeZone(decimalLength);
            byte[] b = this.strDateTime.getBytes();
            int n = 0;
            for (int i = 0; i < 16 && (b[i] >= 48 && b[i] <= 57 || n++ <= 4); ++i) {
            }
            if (n > 4 || b[4] != 45 || b[7] != 45 || b[10] != 84 || b[13] != 58 || b[16] != 58 || this.strDateTime.length() - decimalLength != 25) {
                this.cleanDateTime();
                b = this.strDateTime.getBytes();
            }
            JDFDate.this.lTimeInMillis = fastCalendar.getTimeInMillis(b, decimalLength, JDFDate.this.getTimeZoneOffsetInMillis());
            if (!this.timezoneSet) {
                JDFDate.this.m_TimeZoneOffsetInMillis = TimeZone.getDefault().getOffset(JDFDate.this.lTimeInMillis);
                JDFDate.this.lTimeInMillis = fastCalendar.getTimeInMillis(b, decimalLength, JDFDate.this.getTimeZoneOffsetInMillis());
            }
        }

        private void cleanDateTime() throws DataFormatException {
            this.cleanDate();
            this.cleanTime();
        }

        private void cleanDate() throws DataFormatException {
            int day;
            int month;
            int year;
            String date = StringUtil.token(this.strDateTime, 0, "T");
            VString dates = StringUtil.tokenize(date, "-", false);
            if (dates != null && dates.size() >= 3) {
                year = StringUtil.parseInt(dates.get(0), 0);
                if (year <= 0 || year > 9999) {
                    throw new DataFormatException("JDFDate.init: invalid date Year " + dates.get(0));
                }
                month = StringUtil.parseInt(dates.get(1), 0);
                if (month <= 0 || month > 12) {
                    throw new DataFormatException("JDFDate.init: invalid date Month " + dates.get(1));
                }
                day = StringUtil.parseInt(dates.get(2), 0);
                if (day <= 0 || day > 31) {
                    throw new DataFormatException("JDFDate.init: invalid date Day " + dates.get(2));
                }
            } else {
                throw new DataFormatException("JDFDate.init: invalid date String " + this.strDateTime);
            }
            NumberFormatter nf = new NumberFormatter();
            String newDate = nf.formatInt(year, 4) + "-" + nf.formatInt(month, 2) + "-" + nf.formatInt(day, 2);
            this.strDateTime = StringUtil.replaceToken(this.strDateTime, 0, "T", newDate);
        }

        private void cleanTime() throws DataFormatException {
            int seconds;
            int minutes;
            int hours;
            String time = StringUtil.token(this.strDateTime, 1, "T");
            String[] pms = new String[]{"+", "-"};
            Object timeZone = null;
            for (String pm : pms) {
                timeZone = StringUtil.token(time, 1, pm);
                if (timeZone == null) continue;
                time = StringUtil.token(time, 0, pm);
                timeZone = pm + (String)timeZone;
                break;
            }
            if (timeZone == null) {
                throw new DataFormatException("bad time zone ");
            }
            StringArray times = StringArray.getVString(time, ":");
            if (times != null) {
                hours = StringUtil.parseInt(times.get(0), -1);
                if (hours < 0 || hours > 23) {
                    hours = defaultHour;
                }
                if ((minutes = StringUtil.parseInt(times.get(1), -1)) < 0 || minutes >= 60) {
                    minutes = 0;
                }
                if ((seconds = StringUtil.parseInt(times.get(2), 0)) < 0 || seconds >= 60) {
                    seconds = 0;
                }
            } else {
                throw new DataFormatException("JDFDate.init: invalid time String " + this.strDateTime);
            }
            NumberFormatter nf = new NumberFormatter();
            String newTime = nf.formatInt(hours, 2) + ":" + nf.formatInt(minutes, 2) + ":" + nf.formatInt(seconds, 2) + (String)timeZone;
            this.strDateTime = StringUtil.replaceToken(this.strDateTime, 1, "T", newTime);
        }

        private void handleTimeZone(int decimalLength) throws DataFormatException {
            int posPlus = this.strDateTime.indexOf(43, 15);
            int posMinus = this.strDateTime.indexOf(45, 15);
            if (posPlus == -1 && posMinus == -1) {
                JDFDate.this.setTimeZoneOffsetInMillis(TimeZone.getDefault().getOffset(JDFDate.this.lTimeInMillis));
                this.strDateTime = this.strDateTime + JDFDate.this.getTimeZoneISO();
                this.timezoneSet = false;
            } else {
                String tzValue;
                if (posPlus >= 0 && posMinus >= 0) {
                    throw new DataFormatException("bad date time string: " + this.strDateTime);
                }
                int minfac = 60000;
                if (posMinus > posPlus) {
                    posPlus = posMinus;
                    minfac = -minfac;
                }
                if (!StringUtil.isInteger(tzValue = this.strDateTime.substring(posPlus, posPlus + 3))) {
                    throw new DataFormatException("bad date time string: " + this.strDateTime);
                }
                int parseInt = StringUtil.parseInt(tzValue, 0);
                int parseMin = 0;
                if (this.strDateTime.length() >= posPlus + 6) {
                    String tzMinutes = this.strDateTime.substring(posPlus + 4, posPlus + 6);
                    parseMin = StringUtil.parseInt(tzMinutes, 0);
                }
                JDFDate.this.setTimeZoneOffsetInMillis(3600000 * parseInt + minfac * parseMin);
            }
        }

        private int handleDecimal() {
            int decimalLength;
            block1: {
                int indexOfDecimal = this.strDateTime.indexOf(46);
                decimalLength = 0;
                if (indexOfDecimal == -1 || indexOfDecimal != 19) break block1;
                ++decimalLength;
                while ("0123456789".indexOf(this.strDateTime.charAt(indexOfDecimal + decimalLength)) != -1 && indexOfDecimal + ++decimalLength != this.strDateTime.length()) {
                }
            }
            return decimalLength;
        }

        private void addMissingTime() {
            if (this.strDateTime.indexOf("T") == -1) {
                this.timezoneSet = false;
                if (this.l > 1000L && this.l < 5000L) {
                    this.strDateTime = this.strDateTime + "-01-01";
                }
                if (this.strDateTime.length() == 7) {
                    this.strDateTime = this.strDateTime + "-01";
                }
                this.strDateTime = this.strDateTime + this.getDefaultTime() + JDFDate.this.getTimeZoneISO();
            } else if (this.strDateTime.length() < 16) {
                this.timezoneSet = false;
                Object buffer = this.getDefaultTime() + JDFDate.this.getTimeZoneISO();
                buffer = ((String)buffer).substring(16 - this.strDateTime.length());
                this.strDateTime = this.strDateTime + (String)buffer;
            }
        }

        private String getDefaultTime() {
            NumberFormatter numberFormatter = new NumberFormatter();
            return "T" + numberFormatter.formatInt(this.defaultH, 2) + ":" + numberFormatter.formatInt(this.defaultM, 2) + ":00";
        }

        private void handleLongValue() {
            long l0 = System.currentTimeMillis();
            if (l0 / this.l >= 900L) {
                this.l *= 1000L;
            }
            JDFDate.this.lTimeInMillis = this.l;
            JDFDate.this.m_TimeZoneOffsetInMillis = TimeZone.getDefault().getOffset(JDFDate.this.lTimeInMillis);
        }

        public String toString() {
            return "StringHandler [strDateTime=" + this.strDateTime + ", l=" + this.l + "]";
        }
    }

    private static class FastCalendar {
        private final GregorianCalendar gregcal = new GregorianCalendar();

        FastCalendar() {
        }

        synchronized long getTimeInMillis(byte[] b, int decimalLength, int tzInMillis) {
            int iYear = this.getIntFromPos(b, 0, 4);
            int iMonth = this.getIntFromPos(b, 5, 7) - 1;
            int iDay = this.getIntFromPos(b, 8, 10);
            int iHour = this.getIntFromPos(b, 11, 13);
            int iMinute = this.getIntFromPos(b, 14, 16);
            int iSecond = this.getIntFromPos(b, 17, 19);
            this.gregcal.setTimeZone(new SimpleTimeZone(tzInMillis, ""));
            this.gregcal.clear();
            this.gregcal.set(iYear, iMonth, iDay, iHour, iMinute, iSecond);
            long lTimeInMillis = this.gregcal.getTimeInMillis();
            if (decimalLength > 1) {
                lTimeInMillis = decimalLength == 2 ? (lTimeInMillis += (long)(this.getIntFromPos(b, 20, 21) * 100)) : (decimalLength == 3 ? (lTimeInMillis += (long)(this.getIntFromPos(b, 20, 22) * 10)) : (lTimeInMillis += (long)this.getIntFromPos(b, 20, 23)));
            }
            return lTimeInMillis;
        }

        private int getIntFromPos(byte[] strDateTime, int pos1, int pos2) {
            int ret = 0;
            int f = 1;
            for (int i = pos2 - 1; i >= pos1; --i) {
                ret += f * (strDateTime[i] - 48);
                f *= 10;
            }
            return ret;
        }
    }
}

