/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.HashSet;
import java.util.Set;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class XJDFSchemaPrune {
    final Set<KElement> keep = new HashSet<KElement>();
    private final KElement schema;
    private boolean checkAttributes;

    public XJDFSchemaPrune(XMLDoc rootSchema) {
        this.schema = rootSchema.getRoot();
    }

    public KElement prune(KElement ... examples) {
        for (KElement e : examples) {
            this.addPrune(e);
        }
        return this.getPrunedSchema(this.schema);
    }

    KElement getPrunedSchema(KElement schemaElem) {
        for (KElement e : schemaElem.getChildrenByTagName(null)) {
            if (this.keep.contains(e)) {
                this.getPrunedSchema(e);
                continue;
            }
            e.deleteNode();
        }
        return schemaElem;
    }

    void addPrune(KElement example) {
        VElement v = this.getElementsByRef(example);
        for (KElement xsElement : v) {
            this.addSchemaElement(xsElement);
            this.addComplexContent(xsElement);
            this.addAttributes(xsElement, example);
        }
        VElement kids = example.getChildElementVector(null, null);
        for (KElement kid : kids) {
            this.addPrune(kid);
        }
    }

    void addComplexContent(KElement xsElement) {
        KElement cc = this.getExtension(xsElement);
        this.addSchemaElement(cc);
    }

    KElement getExtension(KElement xsElement) {
        KElement cc = xsElement == null ? null : xsElement.getElement("xs:complexContent");
        cc = cc == null ? null : cc.getElement("xs:extension");
        return cc;
    }

    VElement getElementsByRef(KElement example) {
        VElement v = new VElement();
        String nodeName = example.getNodeName();
        KElement xsElement = this.getElementByName(nodeName);
        ContainerUtil.add(v, xsElement);
        KElement ct = xsElement.getElement("xs:complexType");
        if (ct == null) {
            ct = this.schema.getChildWithAttribute("xs:complexType", "name", null, nodeName, 0, false);
        }
        ContainerUtil.add(v, ct);
        KElement parent = example.getParentNode_KElement();
        if (parent != null) {
            KElement schemaParent = this.getElementByName(parent.getNodeName());
            while (schemaParent != null) {
                KElement ref = schemaParent.getChildWithAttribute("xs:element", "ref", null, nodeName, 0, false);
                ContainerUtil.add(v, ref);
                this.checkSchemaParent(v, nodeName, schemaParent);
                this.checkSubstitution(v, xsElement, schemaParent);
                this.checkExtension(v, ct);
                String parentSubst = schemaParent.getNonEmpty("substitutionGroup");
                schemaParent = parentSubst == null ? null : this.getElementByName(parentSubst);
            }
        }
        return v;
    }

    void checkSchemaParent(VElement v, String nodeName, KElement schemaParent) {
        KElement schemaParentCT;
        String parenttyp = schemaParent.getNonEmpty("type");
        KElement kElement = schemaParentCT = parenttyp == null ? schemaParent.getElement("xs:complexType") : this.schema.getChildWithAttribute("xs:complexType", "name", null, parenttyp, 0, false);
        while (schemaParentCT != null) {
            ContainerUtil.add(v, schemaParentCT);
            KElement ref = schemaParentCT.getChildWithAttribute("xs:element", "ref", null, nodeName, 0, false);
            ContainerUtil.add(v, ref);
            KElement ext = this.getExtension(schemaParentCT);
            String base = ext == null ? null : ext.getNonEmpty("base");
            schemaParentCT = base == null ? null : this.schema.getChildWithAttribute("xs:complexType", "name", null, base, 0, false);
        }
    }

    void checkExtension(VElement v, KElement ct) {
        KElement extension = this.getExtension(ct);
        while (extension != null) {
            String base = extension.getNonEmpty("base");
            KElement ctBase = this.schema.getChildWithAttribute("xs:complexType", "name", null, base, 0, false);
            ContainerUtil.add(v, ctBase);
            extension = this.getExtension(ctBase);
        }
    }

    void checkSubstitution(VElement v, KElement xsElement, KElement schemaParent) {
        String subst = xsElement.getAttribute("substitutionGroup");
        while (!StringUtil.isEmpty(subst)) {
            KElement next = this.getElementByName(subst);
            ContainerUtil.add(v, next);
            KElement xsSubst = schemaParent.getChildWithAttribute("xs:element", "ref", null, subst, 0, false);
            if (xsSubst == null) {
                xsSubst = this.schema.getChildWithAttribute("xs:element", "name", null, subst, 0, false);
            }
            ContainerUtil.add(v, xsSubst);
            KElement ctSubst = this.schema.getChildWithAttribute("xs:complexType", "name", null, subst, 0, false);
            ContainerUtil.add(v, ctSubst);
            subst = next == null ? null : next.getAttribute("substitutionGroup");
        }
    }

    void addAttributes(KElement root, KElement example) {
        VElement atts = root.getChildrenByTagName("xs:attribute");
        for (KElement e : atts) {
            if (this.checkAttributes && !example.hasAttribute(e.getAttribute("name"))) continue;
            this.addAttribute(e);
        }
    }

    void addAttribute(KElement e) {
        this.addTree(e);
        String type = e.getNonEmpty("type");
        if (type != null) {
            this.addSimpleType(type);
        } else {
            KElement stypeLocal = e.getElement("xs:simpleType");
            this.addSimpleType(stypeLocal);
        }
    }

    void addSimpleType(String type) {
        if (!"xs:".equals(StringUtil.leftStr(type, 3))) {
            KElement stType = this.schema.getChildWithAttribute("xs:simpleType", "name", null, type, 0, false);
            this.addSimpleType(stType);
        }
    }

    void addSimpleType(KElement stType) {
        if (stType != null) {
            KElement base;
            this.addTree(stType);
            KElement list = stType.getElement("xs:list");
            if (list != null) {
                this.addSimpleType(list.getAttribute("itemType"));
            }
            if ((base = stType.getElement("xs:restriction")) != null) {
                this.addSimpleType(base.getAttribute("base"));
            }
        }
    }

    void addTree(KElement e) {
        for (KElement c : e.getChildrenByTagName(null)) {
            this.keep.add(c);
        }
        this.addSchemaElement(e);
    }

    void addSchemaElement(KElement e) {
        for (KElement e2 = e; e2 != null; e2 = e2.getParentNode_KElement()) {
            this.keep.add(e2);
        }
    }

    KElement getElementByName(String nodeName) {
        return this.schema.getChildWithAttribute("xs:element", "name", null, nodeName, 0, false);
    }

    public boolean isCheckAttributes() {
        return this.checkAttributes;
    }

    public void setCheckAttributes(boolean checkAttributes) {
        this.checkAttributes = checkAttributes;
    }

    public String toString() {
        return "XJDFSchemaPrune [checkAttributes=" + this.checkAttributes + "]";
    }
}

