/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.MyLong;
import org.cip4.jdflib.util.MyPair;
import org.cip4.jdflib.util.thread.RegularJanitor;
import org.cip4.jdflib.util.thread.TimeSweeper;

public class XJMFTypeMap
implements Runnable {
    private static final XJMFTypeMap theMap = new XJMFTypeMap();
    private final Map<String, TimePair> map = new HashMap<String, TimePair>();

    private XJMFTypeMap() {
        RegularJanitor.getJanitor().addSweeper(new TimeSweeper(4242, this), true);
        RegularJanitor.getJanitor().startSweep(42);
    }

    public static XJMFTypeMap getMap() {
        return theMap;
    }

    public String put(String key, String value) {
        TimePair put = this.map.put(key, new TimePair(value));
        return put == null ? null : (String)put.a;
    }

    public String remove(String key) {
        TimePair put = this.map.remove(key);
        return put == null ? null : (String)put.a;
    }

    public String get(String key) {
        TimePair put = this.map.get(key);
        if (put != null) {
            put.touch();
            return (String)put.a;
        }
        return null;
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public void run() {
        Collection<String> keys = ContainerUtil.getKeyArray(this.map);
        if (keys == null) {
            return;
        }
        for (String key : keys) {
            TimePair val = this.map.get(key);
            if (val == null || val.age() <= 4242L) continue;
            this.map.remove(key);
        }
    }

    public static void shutDown() {
        theMap.clear();
        RegularJanitor.feierabend();
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return "XJMFTypeMap [size=" + this.map.size() + "]";
    }

    private class TimePair
    extends MyPair<String, MyLong> {
        TimePair(String val) {
            super(val, new MyLong(System.currentTimeMillis()));
        }

        long age() {
            return (System.currentTimeMillis() - ((MyLong)this.b).i) / 1000L;
        }

        void touch() {
            ((MyLong)this.b).i = System.currentTimeMillis();
        }
    }
}

