/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoResourceQuParams;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.ifaces.INodeIdentifiable;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.NodeIdentifier;
import org.cip4.jdflib.resource.JDFResource;

public class JDFResourceQuParams
extends JDFAutoResourceQuParams
implements INodeIdentifiable {
    private static final long serialVersionUID = 1L;

    public JDFResourceQuParams(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFResourceQuParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFResourceQuParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFResourceQuParams[  --> " + super.toString() + " ]";
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        return super.getPartMapVector();
    }

    @Override
    public void setPartMapVector(VJDFAttributeMap vParts) {
        super.setPartMapVector(vParts);
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        super.setPartMap(mPart);
    }

    @Override
    public void removePartMap(JDFAttributeMap mPart) {
        super.removePartMap(mPart);
    }

    @Override
    public boolean hasPartMap(JDFAttributeMap mPart) {
        return super.hasPartMap(mPart);
    }

    public void setLink(JDFResourceLink resourceLink) {
        if (resourceLink == null) {
            return;
        }
        JDFResource r = resourceLink.getTarget();
        JDFNode parentJDF = resourceLink.getParentJDF();
        this.setJDF(parentJDF);
        this.setProcessUsage(resourceLink.getEnumProcessUsage());
        if (r.hasAttribute("ProductID")) {
            this.setProductID(r.getProductID());
        }
        this.setResourceID(r.getID());
        this.setResourceName(new VString(r.getLocalName(), null));
        this.setUsage(resourceLink.getUsage());
        this.setPartMapVector(resourceLink.getPartMapVector());
    }

    public void setJDF(JDFNode parentJDF) {
        if (parentJDF == null) {
            return;
        }
        this.setJobID(parentJDF.getJobID(true));
        this.setJobPartID(parentJDF.getJobPartID(true));
    }

    public void setProcessUsage(JDFNode.EnumProcessUsage processUsage) {
        this.setAttribute("ProcessUsage", processUsage == null ? null : processUsage.getName(), null);
    }

    @Override
    public NodeIdentifier getIdentifier() {
        return new NodeIdentifier(this.getJobID(), this.getJobPartID(), this.getPartMapVector());
    }

    @Override
    public void setIdentifier(NodeIdentifier ni) {
        if (ni == null) {
            ni = new NodeIdentifier();
        }
        this.setJobID(ni.getJobID());
        this.setJobPartID(ni.getJobPartID());
        this.setPartMapVector(ni.getPartMapVector());
    }

    public void setResourceName(String value) {
        this.setAttribute("ResourceName", value, null);
    }

    public void appendResourceName(String value) {
        this.appendAttribute("ResourceName", value, null, " ", true);
    }
}

