/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.cip4.jdflib.auto.JDFAutoDeviceInfo;
import org.cip4.jdflib.auto.JDFAutoMISDetails;
import org.cip4.jdflib.auto.JDFAutoNotification;
import org.cip4.jdflib.auto.JDFAutoResourceAudit;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFJobPhase;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.jmf.JDFResourceQuParams;
import org.cip4.jdflib.jmf.JDFResponse;
import org.cip4.jdflib.jmf.JDFSignal;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.NodeIdentifier;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.resource.JDFNotification;
import org.cip4.jdflib.resource.JDFPhaseTime;
import org.cip4.jdflib.resource.JDFProcessRun;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFResourceAudit;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.resource.process.JDFExposedMedia;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.resource.process.JDFUsageCounter;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class StatusCounter {
    private double percentComplete = 0.0;
    protected JDFNode m_Node;
    private boolean bCompleted = false;
    private JDFDoc docJMFPhaseTime;
    private JDFDoc docJMFResource;
    private JDFDoc docJMFNotification;
    protected VJDFAttributeMap m_vPartMap;
    protected VString m_ignoreParts = null;
    private String m_deviceID = null;
    private VString m_moduleID = null;
    private VString m_moduleType = null;
    private LinkAmount[] vLinkAmount = null;
    private String firstRefID = null;
    private String queueEntryID;
    private JDFAutoMISDetails.EnumDeviceOperationMode operationMode = JDFAutoMISDetails.EnumDeviceOperationMode.Productive;
    private JDFAutoMISDetails.EnumWorkType workType = null;
    protected HashSet<String> setTrackWaste = new HashSet();
    protected HashSet<String> setCopyResInfo = new HashSet();
    private JDFAutoDeviceInfo.EnumDeviceStatus status = null;
    private String statusDetails = null;
    private JDFDate startDate;
    private NodeIdentifier nodeID = null;
    private final Vector<JDFEmployee> vEmployees = new Vector();
    private double totalCounter = -1.0;
    private VString icsVersions = null;
    private boolean addPhaseTimeAmounts = true;
    private double currentCounter = -1.0;

    public double getTotalCounter() {
        return this.totalCounter;
    }

    public void setTotalCounter(double _totalCounter) {
        this.totalCounter = _totalCounter;
    }

    public double getCurrentCounter() {
        return this.currentCounter;
    }

    public void setCurrentCounter(double _currentCounter) {
        this.currentCounter = _currentCounter;
    }

    public int addEmployee(JDFEmployee employee) {
        JDFEmployee eOld;
        if (employee != null && (eOld = (JDFEmployee)ContainerUtil.getMatch(this.vEmployees, employee, 0)) == null) {
            this.vEmployees.add(employee);
            this.resetPhase();
        }
        return this.vEmployees.size();
    }

    public boolean removeEmployee(JDFEmployee employee) {
        JDFEmployee eOld = (JDFEmployee)ContainerUtil.getMatch(this.vEmployees, employee, 0);
        if (eOld != null) {
            boolean b = this.vEmployees.remove(employee);
            if (b) {
                this.resetPhase();
            }
            return b;
        }
        return false;
    }

    public Vector<JDFEmployee> getEmpoyees() {
        return this.vEmployees;
    }

    public boolean clearEmployees() {
        boolean b = this.vEmployees.size() > 0;
        this.vEmployees.clear();
        if (b) {
            this.resetPhase();
        }
        return b;
    }

    public String toString() {
        return "[StatusCounter - counter: " + this.m_deviceID + "Start date: " + this.startDate + " " + Arrays.toString(this.vLinkAmount) + "]";
    }

    public void writeAll() {
        if (this.m_Node != null) {
            this.getVResLink(2);
        }
    }

    public StatusCounter(JDFNode node, VJDFAttributeMap vPartMap, VElement vResLinks) {
        this.setActiveNode(node, vPartMap, vResLinks);
    }

    public void setPhaseTimeAmounts(boolean bAddAmount) {
        this.addPhaseTimeAmounts = bAddAmount;
    }

    public void setActiveNode(JDFNode node, VJDFAttributeMap vPartMap, VElement vResLinks) {
        VElement vResLinksLocal = vResLinks;
        if (node == null) {
            this.setTrackWaste.clear();
        }
        this.bCompleted = false;
        this.m_Node = node;
        this.m_vPartMap = vPartMap;
        this.vLinkAmount = null;
        this.firstRefID = null;
        this.docJMFResource = null;
        this.docJMFPhaseTime = null;
        this.startDate = new JDFDate();
        this.nodeID = null;
        this.percentComplete = 0.0;
        if (node == null) {
            this.setPhase(null, null, JDFAutoDeviceInfo.EnumDeviceStatus.Idle, JDFAutoDeviceInfo.EnumDeviceStatus.Idle.getName());
        }
        if (this.m_vPartMap == null && this.m_Node != null) {
            this.m_vPartMap = this.m_Node.getNodeInfoPartMapVector();
        }
        NodeIdentifier nodeIdentifier = this.nodeID = node != null ? node.getIdentifier() : null;
        if (this.m_vPartMap != null && this.nodeID != null && node != null) {
            this.nodeID.setTo(node.getJobID(true), node.getJobPartID(false), this.m_vPartMap);
        }
        if (vResLinksLocal == null && this.m_Node != null && (vResLinksLocal = this.m_Node.getResourceLinks(null)) != null) {
            int siz = vResLinksLocal.size();
            for (int i = siz - 1; i >= 0; --i) {
                JDFResourceLink rl = (JDFResourceLink)vResLinksLocal.elementAt(i);
                if (rl.isPhysical()) continue;
                vResLinksLocal.remove(i);
            }
        }
        this.setUpResLinks(vResLinksLocal);
    }

    protected LinkAmount getLinkAmount(String refID) {
        String refIDLocal = refID;
        if (this.vLinkAmount == null || this.vLinkAmount.length == 0) {
            return null;
        }
        if (refIDLocal == null) {
            refIDLocal = this.getFirstRefID();
        }
        for (LinkAmount element : this.vLinkAmount) {
            if (!element.linkFitsKey(refIDLocal)) continue;
            return element;
        }
        return null;
    }

    public String getLinkID(String refID) {
        String refIDLocal = refID;
        if (this.vLinkAmount == null || this.vLinkAmount.length == 0) {
            return null;
        }
        if (refIDLocal == null) {
            refIDLocal = this.getFirstRefID();
        }
        for (LinkAmount element : this.vLinkAmount) {
            if (!element.linkFitsKey(refIDLocal)) continue;
            return element.rl.getrRef();
        }
        return null;
    }

    protected LinkAmount getLinkAmount(int n) {
        if (this.vLinkAmount == null || this.vLinkAmount.length <= n) {
            return null;
        }
        return this.vLinkAmount[n];
    }

    public String getFirstRefID() {
        if (this.firstRefID != null) {
            return this.firstRefID;
        }
        if (this.vLinkAmount == null || this.vLinkAmount.length == 0) {
            return null;
        }
        return this.vLinkAmount[0].rl.getrRef();
    }

    public void setFirstRefID(String resID) {
        this.firstRefID = resID;
    }

    public void addIgnorePart(JDFResource.EnumPartIDKey key) {
        if (this.m_ignoreParts == null && key != null) {
            this.m_ignoreParts = new VString();
        }
        if (key == null) {
            this.m_ignoreParts = null;
        } else {
            this.m_ignoreParts.add(key.getName());
        }
    }

    private void setUpResLinks(VElement resLinks) {
        if (resLinks == null || resLinks.size() == 0) {
            return;
        }
        this.vLinkAmount = new LinkAmount[resLinks.size()];
        for (int i = 0; i < this.vLinkAmount.length; ++i) {
            this.vLinkAmount[i] = new LinkAmount((JDFResourceLink)resLinks.elementAt(i));
        }
    }

    public void clearAmounts(String refID) {
        LinkAmount la = this.getLinkAmount(refID);
        if (la == null) {
            return;
        }
        la.lastBag.reset();
    }

    public synchronized void setPhase(String refID, double amount, double waste) {
        LinkAmount la = this.getLinkAmount(refID);
        if (la == null) {
            return;
        }
        la.addPhase(amount, waste, true, false);
        if (amount >= 0.0) {
            this.updatePercentComplete(la);
        }
    }

    public synchronized void addPhase(String refID, double amount, double waste, boolean sumTotal) {
        LinkAmount la = this.getLinkAmount(refID);
        if (la == null) {
            return;
        }
        la.addPhase(amount, waste, false, sumTotal);
        if (sumTotal) {
            la.updateSpeed();
        }
        if (amount >= 0.0) {
            this.updatePercentComplete(la);
        }
    }

    private void updatePercentComplete(LinkAmount la) {
        if (la == null || la.startAmount <= 0.0 || !la.rl.getrRef().equals(this.getFirstRefID())) {
            return;
        }
        this.percentComplete = la.lastBag.totalAmount / la.startAmount * 100.0;
    }

    public synchronized void setTotal(String refID, double amount, boolean bWaste) {
        LinkAmount la = this.getLinkAmount(refID);
        if (la == null) {
            return;
        }
        if (bWaste) {
            la.lastBag.totalWaste = amount;
        } else {
            la.lastBag.totalAmount = amount;
            this.updatePercentComplete(la);
        }
        la.updateSpeed();
    }

    public double getTotalAmount(String refID) {
        LinkAmount la = this.getLinkAmount(refID);
        return la == null ? 0.0 : la.getAmount(la.lastBag.totalAmount);
    }

    public double[] getTotalAmounts() {
        if (this.vLinkAmount == null || this.vLinkAmount.length == 0) {
            return null;
        }
        double[] d = new double[this.vLinkAmount.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.vLinkAmount[i].getAmount(this.vLinkAmount[i].lastBag.totalAmount);
        }
        return d;
    }

    public JDFResourceLink[] getAmountLinks() {
        if (this.vLinkAmount == null || this.vLinkAmount.length == 0) {
            return null;
        }
        JDFResourceLink[] d = new JDFResourceLink[this.vLinkAmount.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.vLinkAmount[i].rl;
        }
        return d;
    }

    public double[] getPhaseAmounts() {
        if (this.vLinkAmount == null || this.vLinkAmount.length == 0) {
            return null;
        }
        double[] d = new double[this.vLinkAmount.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.vLinkAmount[i].getAmount(this.vLinkAmount[i].lastBag.phaseAmount);
        }
        return d;
    }

    public double getPercentComplete() {
        return this.percentComplete;
    }

    public double getPhaseAmount(String refID) {
        LinkAmount la = this.getLinkAmount(refID);
        return la == null ? 0.0 : la.getAmount(la.lastBag.phaseAmount);
    }

    public double getTotalWaste(String refID) {
        LinkAmount la = this.getLinkAmount(refID);
        return la == null ? 0.0 : la.getAmount(la.lastBag.totalWaste);
    }

    public double[] getTotalWastes() {
        if (this.vLinkAmount == null || this.vLinkAmount.length == 0) {
            return null;
        }
        double[] d = new double[this.vLinkAmount.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.vLinkAmount[i].getAmount(this.vLinkAmount[i].lastBag.totalWaste);
        }
        return d;
    }

    public double[] getPhaseWastes() {
        if (this.vLinkAmount == null || this.vLinkAmount.length == 0) {
            return null;
        }
        double[] d = new double[this.vLinkAmount.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.vLinkAmount[i].getAmount(this.vLinkAmount[i].lastBag.phaseWaste);
        }
        return d;
    }

    public double getPhaseWaste(String refID) {
        LinkAmount la = this.getLinkAmount(refID);
        return la == null ? 0.0 : la.getAmount(la.lastBag.phaseWaste);
    }

    private boolean resetPhase() {
        if (this.m_Node == null) {
            return this.setIdlePhase(this.status, this.statusDetails);
        }
        JDFAuditPool ap = this.m_Node.getCreateAuditPool();
        JDFPhaseTime lastPhase = ap.getLastPhase(this.m_vPartMap, this.m_moduleID == null ? null : this.m_moduleID.get(0));
        JDFElement.EnumNodeStatus ns = lastPhase != null ? lastPhase.getStatus() : JDFElement.EnumNodeStatus.Waiting;
        String nodeStatusDetails = lastPhase != null ? lastPhase.getStatusDetails() : this.statusDetails;
        return this.setPhase(ns, nodeStatusDetails, this.status, this.statusDetails);
    }

    public synchronized JDFNotification setEvent(String eventID, String eventValue, String comment) {
        JDFNotification notif = this.createBaseNotification();
        JDFJMF jmf = this.createNotificationJMF();
        JDFSignal s = jmf.appendSignal(JDFMessage.EnumType.Notification);
        s.copyAttribute("ICSVersions", jmf);
        notif.setEvent(eventID, eventValue, comment);
        s.copyElement(notif, null);
        return notif;
    }

    private JDFNotification createBaseNotification() {
        JDFNotification notif;
        if (this.m_Node != null) {
            JDFAuditPool ap = this.m_Node.getCreateAuditPool();
            notif = ap.addNotification(JDFAutoNotification.EnumClass.Event, null, this.m_vPartMap);
        } else {
            notif = (JDFNotification)new JDFDoc("Notification").getRoot();
        }
        for (int i = 0; i < this.vEmployees.size(); ++i) {
            notif.copyElement(this.vEmployees.get(i), null);
        }
        notif.setNode(this.m_Node);
        return notif;
    }

    private synchronized JDFJMF createNotificationJMF() {
        if (this.docJMFNotification == null) {
            this.docJMFNotification = this.createJMFDoc();
        }
        return this.docJMFNotification.getJMFRoot();
    }

    public synchronized boolean setPhase(JDFElement.EnumNodeStatus nodeStatus, String nodeStatusDetails, JDFAutoDeviceInfo.EnumDeviceStatus deviceStatus, String deviceStatusDetails) {
        JDFPhaseTime lastPhase;
        if (this.m_Node == null) {
            return this.setIdlePhase(deviceStatus, deviceStatusDetails);
        }
        if (deviceStatus != null) {
            this.status = deviceStatus;
        }
        if (!StringUtil.isEmpty(deviceStatusDetails)) {
            this.statusDetails = deviceStatusDetails;
        }
        JDFJMF jmfStatus = this.createPhaseTimeJMF();
        JDFJMF jmfRes = this.createResourceJMF();
        LinkAmount mainLinkAmount = this.getLinkAmount(this.getFirstRefID());
        if (this.m_Node == null) {
            return this.setIdlePhase(deviceStatus, deviceStatusDetails);
        }
        JDFAuditPool auditPool = this.m_Node.getCreateAuditPool();
        JDFPhaseTime nextPhase = lastPhase = auditPool.getLastPhase(this.m_vPartMap, this.m_moduleID == null ? null : this.m_moduleID.get(0));
        boolean bEnd = JDFElement.EnumNodeStatus.Completed.equals((Object)nodeStatus) || JDFElement.EnumNodeStatus.Aborted.equals((Object)nodeStatus);
        boolean bChanged = bEnd || lastPhase == null;
        nextPhase = auditPool.setPhase(nodeStatus, nodeStatusDetails, this.m_vPartMap, new VElement(this.vEmployees));
        if (bEnd && !this.bCompleted) {
            this.writeAll();
            this.appendResourceAudits();
            this.appendProcessRun(nodeStatus, auditPool);
            this.bCompleted = true;
        }
        if (!bEnd) {
            this.bCompleted = false;
        }
        if (nextPhase != null) {
            this.generateResourceResponse(jmfRes);
        }
        if (lastPhase != null && nextPhase != lastPhase) {
            bChanged = true;
            this.closeJobPhase(jmfStatus, mainLinkAmount, lastPhase);
            this.startDate = new JDFDate();
        }
        if (nextPhase != null) {
            if (this.workType != null) {
                nextPhase.getCreateMISDetails().setWorkType(this.workType);
            }
            if (this.m_deviceID != null) {
                nextPhase.getCreateDevice(0).setDeviceID(this.m_deviceID);
            }
            nextPhase.setModules(this.m_moduleID, this.m_moduleType);
            this.updateCurrentJobPhase(nodeStatus, nodeStatusDetails, deviceStatus, deviceStatusDetails, jmfStatus, mainLinkAmount, nextPhase, bEnd);
        }
        jmfStatus.eraseEmptyAttributes(true);
        jmfRes.eraseEmptyAttributes(true);
        return bChanged;
    }

    private void appendResourceAudits() {
        if (this.vLinkAmount != null) {
            for (LinkAmount element : this.vLinkAmount) {
                this.setResourceAudit(element.refID, JDFAutoResourceAudit.EnumReason.ProcessResult);
                element.updateNodeResource();
            }
        }
    }

    private synchronized JDFJMF createResourceJMF() {
        this.docJMFResource = this.createJMFDoc();
        return this.docJMFResource.getJMFRoot();
    }

    private synchronized JDFJMF createPhaseTimeJMF() {
        this.docJMFPhaseTime = this.createJMFDoc();
        return this.docJMFPhaseTime.getJMFRoot();
    }

    private JDFDoc createJMFDoc() {
        JDFDoc d = new JDFDoc("JMF");
        JDFJMF jmf = d.getJMFRoot();
        jmf.setSenderID(this.m_deviceID);
        if (this.icsVersions != null) {
            jmf.setICSVersions(this.icsVersions);
        }
        return d;
    }

    private synchronized boolean setIdlePhase(JDFAutoDeviceInfo.EnumDeviceStatus deviceStatus, String deviceStatusDetails) {
        boolean bChanged = this.docJMFPhaseTime == null;
        JDFResponse r = bChanged ? null : this.docJMFPhaseTime.getJMFRoot().getResponse(0);
        JDFDeviceInfo lastDevInfo = r == null ? null : r.getDeviceInfo(-1);
        this.status = deviceStatus;
        this.statusDetails = deviceStatusDetails;
        bChanged = bChanged || !ContainerUtil.equals(deviceStatusDetails, lastDevInfo == null ? null : lastDevInfo.getAttribute("StatusDetails", null, null));
        this.startDate = lastDevInfo == null || lastDevInfo.getIdleStartTime() == null || bChanged ? new JDFDate() : lastDevInfo.getIdleStartTime();
        JDFJMF jmf = this.createPhaseTimeJMF();
        JDFResponse newResponse = jmf.appendResponse(JDFMessage.EnumType.Status);
        newResponse.copyAttribute("ICSVersions", jmf);
        JDFDeviceInfo newDevInfo = newResponse.getCreateDeviceInfo(0);
        this.fillDeviceInfo(deviceStatus, deviceStatusDetails, newDevInfo, null);
        newDevInfo.setIdleStartTime(this.startDate);
        return bChanged;
    }

    private void fillDeviceInfo(JDFAutoDeviceInfo.EnumDeviceStatus deviceStatus, String deviceStatusDetails, JDFDeviceInfo newDevInfo, LinkAmount la) {
        newDevInfo.setDeviceStatus(deviceStatus);
        newDevInfo.setStatusDetails(deviceStatusDetails);
        newDevInfo.setDeviceOperationMode(this.operationMode);
        newDevInfo.setDeviceID(this.m_deviceID);
        if (this.currentCounter >= 0.0) {
            newDevInfo.setProductionCounter(this.currentCounter);
        }
        if (this.totalCounter >= 0.0) {
            newDevInfo.setTotalProductionCounter(this.totalCounter);
        }
        if (la != null) {
            newDevInfo.setSpeed(la.getAmount(la.lastBag.speed));
        }
        for (int i = 0; i < this.vEmployees.size(); ++i) {
            newDevInfo.copyElement(this.vEmployees.get(i), null);
        }
    }

    private void updateCurrentJobPhase(JDFElement.EnumNodeStatus nodeStatus, String nodeStatusDetails, JDFAutoDeviceInfo.EnumDeviceStatus deviceStatus, String deviceStatusDetails, JDFJMF jmf, LinkAmount la, JDFPhaseTime pt2, boolean bEnd) {
        JDFResponse respStatus = (JDFResponse)jmf.appendMessageElement(JDFMessage.EnumFamily.Response, JDFMessage.EnumType.Status);
        JDFDeviceInfo deviceInfo = respStatus.getCreateDeviceInfo(0);
        JDFJobPhase jp = deviceInfo.createJobPhaseFromPhaseTime(pt2);
        this.setJobPhaseAmounts(la, jp);
        jp.setQueueEntryID(this.queueEntryID);
        this.fillDeviceInfo(deviceStatus, deviceStatusDetails, deviceInfo, la);
        if (this.m_Node != null && nodeStatus != null) {
            this.m_Node.setPartStatus(this.m_vPartMap, nodeStatus, nodeStatusDetails);
            this.getVResLink(2);
            if (bEnd) {
                pt2.deleteNode();
            } else {
                if (this.addPhaseTimeAmounts) {
                    pt2.setLinks(this.getVResLink(1));
                }
                pt2.eraseEmptyAttributes(true);
            }
        }
    }

    private JDFResponse closeJobPhase(JDFJMF jmf, LinkAmount la, JDFPhaseTime pt1) {
        JDFResponse respStatus = (JDFResponse)jmf.appendMessageElement(JDFMessage.EnumFamily.Response, JDFMessage.EnumType.Status);
        JDFDeviceInfo deviceInfo = respStatus.appendDeviceInfo();
        this.fillDeviceInfo(this.status, this.statusDetails, deviceInfo, la);
        JDFJobPhase jp = deviceInfo.createJobPhaseFromPhaseTime(pt1);
        jp.setJobID(this.m_Node.getJobID(true));
        jp.setJobPartID(this.m_Node.getJobPartID(false));
        jp.setQueueEntryID(this.queueEntryID);
        this.setJobPhaseAmounts(la, jp);
        if (this.addPhaseTimeAmounts) {
            pt1.setLinks(this.getVResLink(1));
        }
        if (this.vLinkAmount != null) {
            for (LinkAmount element : this.vLinkAmount) {
                element.addPhase(0.0, 0.0, true, true);
            }
        }
        return respStatus;
    }

    private void appendProcessRun(JDFElement.EnumNodeStatus nodeStatus, JDFAuditPool ap) {
        JDFProcessRun pr = (JDFProcessRun)ap.addAudit(JDFAudit.EnumAuditType.ProcessRun, null);
        pr.setPartMapVector(this.m_vPartMap);
        VElement audits = ap.getAudits(JDFAudit.EnumAuditType.PhaseTime, null, this.m_vPartMap);
        for (int i = 0; i < audits.size(); ++i) {
            pr.addPhase((JDFPhaseTime)audits.elementAt(i));
        }
        pr.setEndStatus(nodeStatus);
    }

    private void generateResourceResponse(JDFJMF jmfRes) {
        VElement vResResourceInfo = this.getVResLink(3);
        JDFSignal sig = jmfRes.appendSignal(JDFMessage.EnumType.Resource);
        sig.copyAttribute("ICSVersions", jmfRes);
        JDFResourceQuParams rqp = sig.appendResourceQuParams();
        rqp.setJDF(this.m_Node);
        rqp.setExact(false);
        rqp.setQueueEntryID(this.queueEntryID);
        boolean bAllExact = true;
        if (vResResourceInfo != null) {
            Iterator vResResourceInfoIterator = vResResourceInfo.iterator();
            while (vResResourceInfoIterator.hasNext()) {
                JDFResourceLink rl;
                LinkAmount la;
                JDFResourceInfo ri = sig.appendResourceInfo();
                if (this.workType != null) {
                    ri.appendMISDetails().setWorkType(this.workType);
                }
                boolean bExact = (la = this.getLinkAmount((rl = (JDFResourceLink)vResResourceInfoIterator.next()).getrRef())) != null && la.isCopyResInfo();
                bAllExact = bAllExact && bExact;
                rqp.setExact(bExact);
                ri.setLink(rl, rqp);
            }
        }
        rqp.setExact(bAllExact);
    }

    private void setJobPhaseAmounts(LinkAmount la, JDFJobPhase jp) {
        if (jp == null || !this.addPhaseTimeAmounts) {
            return;
        }
        jp.setPercentCompleted(this.percentComplete);
        if (la == null) {
            return;
        }
        if (la.isTrackWaste()) {
            if (la.getAmount(la.lastBag.totalAmount) != 0.0) {
                jp.setPhaseAmount(la.getAmount(la.lastBag.phaseAmount));
                jp.setAmount(la.getAmount(la.lastBag.totalAmount));
            }
            if (la.getAmount(la.lastBag.totalWaste) != 0.0) {
                jp.setPhaseWaste(la.getAmount(la.lastBag.phaseWaste));
                jp.setWaste(la.getAmount(la.lastBag.totalWaste));
            }
        } else if (la.getAmount(la.lastBag.totalAmount) + la.getAmount(la.lastBag.totalWaste) != 0.0) {
            jp.setPhaseAmount(la.getAmount(la.lastBag.phaseAmount) + la.getAmount(la.lastBag.phaseWaste));
            jp.setAmount(la.getAmount(la.lastBag.totalAmount) + la.getAmount(la.lastBag.totalWaste));
        }
        double total = 0.0;
        total = la.startAmount;
        if (total != 0.0) {
            jp.setTotalAmount(total);
        }
    }

    private VElement getVResLink(int n) {
        if (this.vLinkAmount == null || this.m_Node == null) {
            return null;
        }
        VElement vRet = new VElement();
        for (LinkAmount la : this.vLinkAmount) {
            JDFResourceLink phaseTimeLink;
            if (n == 1 && (phaseTimeLink = la.getPhaseTimeLink()) != null) {
                vRet.add(phaseTimeLink);
            }
            if (n == 2) {
                vRet.add(la.updateNodeLink());
            }
            if (n == 3) {
                vRet.add(la.getResourceInfoLink());
            }
            if (n != 4) continue;
            vRet.add(la.getResourceAuditLink());
        }
        return vRet;
    }

    public synchronized JDFDoc getDocJMFPhaseTime() {
        if (this.m_Node == null) {
            this.setIdlePhase(this.status, this.statusDetails);
        }
        return this.docJMFPhaseTime == null ? null : this.docJMFPhaseTime.clone();
    }

    public synchronized JDFDoc getDocJMFResource() {
        if (this.docJMFResource == null) {
            return null;
        }
        return this.docJMFResource.clone();
    }

    public synchronized JDFDoc getDocJMFNotification(boolean bClean) {
        JDFDoc ret = null;
        if (this.docJMFNotification != null) {
            if (bClean) {
                ret = this.docJMFNotification;
                this.docJMFNotification = null;
            } else {
                ret = this.docJMFNotification.clone();
            }
        }
        return ret;
    }

    public String getDeviceID() {
        return this.m_deviceID;
    }

    public VString getModuleeID() {
        return this.m_moduleID;
    }

    public void setDeviceID(String deviceid) {
        this.m_deviceID = deviceid;
    }

    public void addModule(String moduleID, String moduleType) {
        if (this.m_moduleID == null) {
            this.m_moduleID = new VString();
        }
        if (this.m_moduleType == null) {
            this.m_moduleType = new VString();
        }
        this.m_moduleID.add(moduleID);
        this.m_moduleType.add(moduleType);
    }

    public void setTrackWaste(String resID, boolean b) {
        if (b) {
            this.setTrackWaste.add(resID);
        } else {
            this.setTrackWaste.remove(resID);
        }
    }

    public void setCopyResInResInfo(String _refID, boolean b) {
        if (b) {
            this.setCopyResInfo.add(_refID);
        } else {
            this.setCopyResInfo.remove(_refID);
        }
    }

    public synchronized JDFResourceAudit setResourceAudit(String resID, JDFAutoResourceAudit.EnumReason reason) {
        LinkAmount la = this.getLinkAmount(resID);
        if (la == null) {
            return null;
        }
        JDFAuditPool ap = this.m_Node.getCreateAuditPool();
        JDFResourceAudit resourceAudit = ap.addResourceAudit(null);
        resourceAudit.setContentsModified(false);
        resourceAudit.setReason(reason);
        resourceAudit.copyElement(la.getResourceAuditLink(), null);
        resourceAudit.setPartMapVector(this.m_vPartMap);
        return resourceAudit;
    }

    public JDFProcessRun setProcessResult(JDFElement.EnumNodeStatus endStatus) {
        this.setPhase(JDFElement.EnumNodeStatus.Completed, null, JDFAutoDeviceInfo.EnumDeviceStatus.Idle, null);
        JDFAuditPool ap = this.m_Node.getCreateAuditPool();
        JDFProcessRun pr = (JDFProcessRun)ap.getAudit(-1, JDFAudit.EnumAuditType.ProcessRun, null, this.m_vPartMap);
        return pr;
    }

    public void setQueueEntryID(String _queueEntryID) {
        this.queueEntryID = _queueEntryID;
    }

    public String getQueueEntryID() {
        return this.queueEntryID;
    }

    public void setWorkType(JDFAutoMISDetails.EnumWorkType _workType) {
        if (ContainerUtil.equals((Object)_workType, (Object)this.workType)) {
            return;
        }
        this.workType = _workType;
    }

    public JDFAutoDeviceInfo.EnumDeviceStatus getStatus() {
        return this.status;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public JDFDate getStartDate() {
        return this.startDate;
    }

    public void setOperationMode(JDFAutoMISDetails.EnumDeviceOperationMode _operationMode) {
        this.operationMode = _operationMode;
    }

    public double getPlannedAmount(String refID) {
        LinkAmount la = this.getLinkAmount(refID);
        return la == null ? 0.0 : la.getAmount(la.startAmount);
    }

    public double getPlannedWaste(String refID) {
        LinkAmount la = this.getLinkAmount(refID);
        return la == null ? 0.0 : la.getAmount(la.startWaste);
    }

    public NodeIdentifier getNodeIDentifier() {
        return this.nodeID;
    }

    public void setPercentComplete(double percent) {
        this.percentComplete = percent;
    }

    public void updatePercentComplete(double percent) {
        this.percentComplete += percent;
    }

    public void setIcsVersions(VString icsVersions) {
        if (icsVersions != null && icsVersions.size() == 0) {
            icsVersions = null;
        }
        this.icsVersions = icsVersions;
    }

    public VString getIcsVersions() {
        return this.icsVersions;
    }

    public void replaceEmployees(Vector<JDFEmployee> employees) {
        if (employees == null || employees.size() == 0) {
            if (this.vEmployees.size() > 0) {
                this.clearEmployees();
                this.resetPhase();
            }
        } else if (!new VElement(employees).isEqual(new VElement(this.vEmployees))) {
            this.vEmployees.clear();
            this.vEmployees.addAll(employees);
            this.resetPhase();
        }
    }

    public String shortString() {
        return this.getClass().getSimpleName() + " JobID=" + this.getJobID() + " DeviceID=" + this.getDeviceID();
    }

    public String getJobID() {
        return this.m_Node == null ? "null" : this.m_Node.getJobID(true);
    }

    private class LinkAmount {
        protected double startAmount = 0.0;
        protected double startWaste = 0.0;
        protected JDFResourceLink rl;
        protected String refID;
        protected final AmountBag lastBag;
        protected VJDFAttributeMap vResPartMap;
        private boolean bInteger = false;

        protected LinkAmount(JDFResourceLink _rl) {
            JDFNode dump = new JDFDoc("JDF").getJDFRoot();
            dump.appendResourceLinkPool().copyElement(_rl, null);
            JDFResource target = _rl.getTarget();
            this.bInteger = this.isInteger(target);
            dump.appendResourcePool().copyElement(target, null);
            this.rl = (JDFResourceLink)dump.getResourceLinkPool().getElement(_rl.getNodeName(), null, 0);
            this.lastBag = new AmountBag();
            this.refID = this.rl.getrRef();
            this.vResPartMap = StatusCounter.this.m_vPartMap == null ? this.rl.getPartMapVector() : new VJDFAttributeMap(StatusCounter.this.m_vPartMap);
            if (this.vResPartMap != null) {
                if (StatusCounter.this.m_ignoreParts != null) {
                    this.vResPartMap.removeKeys(StatusCounter.this.m_ignoreParts.getSet());
                }
                if (this.vResPartMap.size() == 0) {
                    this.vResPartMap = null;
                }
            }
            if (this.isTrackWaste()) {
                VJDFAttributeMap vMap = new VJDFAttributeMap(this.vResPartMap);
                vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Good");
                this.startAmount = this.rl.getAmountPoolSumDouble("Amount", vMap);
                this.lastBag.totalAmount += this.rl.getAmountPoolSumDouble("ActualAmount", vMap);
                vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Waste");
                this.startWaste = this.rl.getAmountPoolSumDouble("MaxAmount", vMap);
                if (this.startWaste <= 0.0) {
                    this.startWaste = this.rl.getAmountPoolSumDouble("Amount", vMap);
                }
                this.lastBag.totalAmount += this.rl.getAmountPoolSumDouble("ActualAmount", vMap);
            } else {
                this.startAmount = this.rl.getAmountPoolSumDouble("Amount", this.vResPartMap);
                this.lastBag.totalAmount += this.rl.getAmountPoolSumDouble("ActualAmount", this.vResPartMap);
            }
        }

        private boolean isInteger(JDFResource target) {
            return target instanceof JDFUsageCounter || target instanceof JDFMedia || target instanceof JDFExposedMedia || target instanceof JDFComponent;
        }

        protected JDFResourceLink updateNodeLink() {
            JDFResourceLink nodeLink = StatusCounter.this.m_Node.getLink(0, null, new JDFAttributeMap("rRef", this.rl.getrRef()), null);
            VJDFAttributeMap vMap = new VJDFAttributeMap(this.vResPartMap);
            if (vMap.size() == 0) {
                vMap.add(new JDFAttributeMap());
            }
            if (nodeLink != null) {
                if (this.isTrackWaste()) {
                    vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Good");
                    nodeLink.setAmountPoolAttribute("ActualAmount", this.formatAmount(this.lastBag.totalAmount), null, vMap);
                    vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Waste");
                    nodeLink.setAmountPoolAttribute("ActualAmount", this.formatAmount(this.lastBag.totalWaste), null, vMap);
                } else {
                    nodeLink.setAmountPoolAttribute("ActualAmount", this.formatAmount(this.lastBag.totalAmount + this.lastBag.totalWaste), null, vMap);
                }
                if (this.lastBag.totalAmount > 0.0) {
                    JDFResource r = nodeLink.getLinkRoot();
                    if (this.vResPartMap != null) {
                        for (int i = 0; i < this.vResPartMap.size(); ++i) {
                            JDFAttributeMap m = this.vResPartMap.elementAt(i);
                            JDFResource rp = r.getPartition(m, null);
                            if (rp == null) continue;
                            rp.setResStatus(JDFResource.EnumResStatus.Available, false);
                        }
                    } else {
                        r.setResStatus(JDFResource.EnumResStatus.Available, false);
                    }
                }
            }
            return nodeLink;
        }

        void updateNodeResource() {
            VElement vRes;
            JDFResourceLink nodeLink = StatusCounter.this.m_Node.getLink(0, null, new JDFAttributeMap("rRef", this.rl.getrRef()), null);
            if (nodeLink != null && JDFResourceLink.EnumUsage.Output.equals((Object)nodeLink.getUsage()) && (vRes = nodeLink.getTargetVector(-1)) != null) {
                VElement leaves;
                JDFResource r;
                int i;
                int size = vRes.size();
                for (i = 0; i < size; ++i) {
                    r = (JDFResource)vRes.get(i);
                    leaves = r.getLeafArray(false);
                    for (JDFResource rr : leaves) {
                        VJDFAttributeMap vMap = rr.getPartMapVector(false);
                        if (StatusCounter.this.m_vPartMap == null || !StatusCounter.this.m_vPartMap.overlapsMap(vMap)) continue;
                        rr.setResStatus(JDFResource.EnumResStatus.Available, true);
                    }
                }
                for (i = 0; i < size; ++i) {
                    r = (JDFResource)vRes.get(i);
                    leaves = r.getLeaves(true);
                    for (int j = 0; j < leaves.size(); ++j) {
                        JDFResource rr;
                        rr = (JDFResource)leaves.get(j);
                        if (rr.isLeaf() || !JDFResource.EnumResStatus.Available.equals((Object)rr.getStatusFromLeaves(false))) continue;
                        rr.setResStatus(JDFResource.EnumResStatus.Available, false);
                    }
                }
            }
        }

        void updateSpeed() {
            long t = System.currentTimeMillis();
            if (this.lastBag.lastCall == 0L) {
                this.lastBag.speed = 0.0;
                this.lastBag.lastCall = t;
                this.lastBag.amountLast = 0.0;
            } else {
                double dt = t - this.lastBag.lastCall;
                if (dt > 30000.0) {
                    this.lastBag.speed = (this.lastBag.totalAmount + this.lastBag.totalWaste - this.lastBag.amountLast) / (dt /= 3600000.0);
                    this.lastBag.amountLast = this.lastBag.totalAmount + this.lastBag.totalWaste;
                    this.lastBag.lastCall = t;
                }
            }
        }

        protected JDFResourceLink getPhaseTimeLink() {
            this.cleanAmounts();
            return this.setPhaseAmounts();
        }

        protected JDFResourceLink getResourceAuditLink() {
            this.cleanAmounts();
            this.setTotalAmounts();
            return this.rl;
        }

        protected JDFResourceLink getResourceInfoLink() {
            this.cleanAmounts();
            return this.setTotalAmounts();
        }

        private JDFResourceLink setPhaseAmounts() {
            VJDFAttributeMap vMap = new VJDFAttributeMap(this.vResPartMap);
            if (vMap.size() == 0) {
                vMap.add(new JDFAttributeMap());
            }
            boolean bEmpty = true;
            if (this.isTrackWaste()) {
                vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Good");
                if (this.lastBag.totalAmount != 0.0 || this.startAmount > 0.0) {
                    this.rl.setAmountPoolAttribute("ActualAmount", this.formatAmount(this.lastBag.phaseAmount), null, vMap);
                    bEmpty = false;
                }
                if (this.startAmount != 0.0) {
                    this.rl.setAmountPoolAttribute("Amount", this.formatAmount(this.startAmount), null, vMap);
                    bEmpty = false;
                }
                vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Waste");
                if (this.lastBag.totalWaste != 0.0 || this.startWaste > 0.0) {
                    this.rl.setAmountPoolAttribute("ActualAmount", this.formatAmount(this.lastBag.phaseWaste), null, vMap);
                    bEmpty = false;
                }
                if (this.startWaste != 0.0) {
                    this.rl.setAmountPoolAttribute("Amount", this.formatAmount(this.startWaste), null, vMap);
                    bEmpty = false;
                }
            } else {
                if (this.lastBag.totalAmount + this.lastBag.totalWaste != 0.0 || this.startAmount + this.startWaste > 0.0) {
                    this.rl.setAmountPoolAttribute("ActualAmount", this.formatAmount(this.lastBag.phaseAmount + this.lastBag.phaseWaste), null, vMap);
                    bEmpty = false;
                }
                if (this.startAmount + this.startWaste != 0.0) {
                    this.rl.setAmountPoolAttribute("Amount", this.formatAmount(this.startAmount + this.startWaste), null, vMap);
                    bEmpty = false;
                }
            }
            return bEmpty ? null : this.rl;
        }

        private JDFResourceLink setTotalAmounts() {
            VJDFAttributeMap vMap = new VJDFAttributeMap(this.vResPartMap);
            if (vMap.size() == 0) {
                vMap.add(new JDFAttributeMap());
            }
            if (this.isTrackWaste()) {
                vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Good");
                if (this.lastBag.totalAmount != 0.0) {
                    this.rl.setAmountPoolAttribute("ActualAmount", this.formatAmount(this.lastBag.totalAmount), null, vMap);
                }
                if (this.startAmount != 0.0) {
                    this.rl.setAmountPoolAttribute("Amount", this.formatAmount(this.startAmount), null, vMap);
                }
                vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Waste");
                if (this.lastBag.totalWaste != 0.0) {
                    this.rl.setAmountPoolAttribute("ActualAmount", this.formatAmount(this.lastBag.totalWaste), null, vMap);
                }
                if (this.startWaste != 0.0) {
                    this.rl.setAmountPoolAttribute("Amount", this.formatAmount(this.startWaste), null, vMap);
                }
            } else {
                if (this.lastBag.totalAmount + this.lastBag.totalWaste != 0.0) {
                    this.rl.setAmountPoolAttribute("ActualAmount", this.formatAmount(this.lastBag.totalAmount + this.lastBag.totalWaste), null, vMap);
                }
                if (this.startAmount + this.startWaste != 0.0) {
                    this.rl.setAmountPoolAttribute("Amount", this.formatAmount(this.startAmount + this.startWaste), null, vMap);
                }
            }
            return this.rl;
        }

        protected double getAmount(double amount) {
            return this.bInteger ? (double)((int)amount) : amount;
        }

        protected String formatAmount(double amount) {
            return this.bInteger ? StringUtil.formatInteger((int)amount) : StringUtil.formatDouble(amount);
        }

        private void cleanAmounts() {
            this.rl.removeAttribute("Amount");
            this.rl.removeAttribute("ActualAmount");
            this.rl.removeChild("AmountPool", null, 0);
        }

        protected void addPhase(double amount, double waste, boolean bNewPhase, boolean sumTotal) {
            this.lastBag.addPhase(amount, waste, bNewPhase, sumTotal);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("LinkAmount: refID=");
            sb.append(this.refID);
            sb.append("\n");
            sb.append(this.vResPartMap);
            sb.append("\nstartAmount: ");
            sb.append(this.startAmount);
            sb.append("\nstartWaste: ");
            sb.append(this.startWaste);
            sb.append(this.lastBag);
            return sb.toString();
        }

        protected boolean linkFitsKey(String key) {
            if (key == null) {
                return true;
            }
            return this.rl.matchesString(key);
        }

        protected boolean linkFitsKey(Set<String> keys) {
            if (keys == null) {
                return false;
            }
            return keys.contains("*") || keys.contains(this.rl.getNamedProcessUsage()) || keys.contains(this.rl.getLinkedResourceName()) || keys.contains(this.refID) || keys.contains(this.rl.getAttribute("Usage"));
        }

        public boolean isCopyResInfo() {
            return this.linkFitsKey(StatusCounter.this.setCopyResInfo);
        }

        public boolean isTrackWaste() {
            return this.linkFitsKey(StatusCounter.this.setTrackWaste);
        }

        private class AmountBag {
            protected double totalAmount;
            protected double phaseAmount;
            protected double totalWaste;
            protected double phaseWaste;
            protected long lastCall = 0L;
            protected double speed = 0.0;
            protected double amountLast = 0.0;

            public String toString() {
                return "[AmountBag totalAmount=" + this.totalAmount + " phaseAmount=" + this.phaseAmount + " totalWaste=" + this.totalWaste + " phaseWaste=" + this.phaseWaste + " ]";
            }

            protected AmountBag() {
                this.reset();
            }

            protected void reset() {
                this.totalAmount = 0.0;
                this.phaseAmount = 0.0;
                this.totalWaste = 0.0;
                this.phaseWaste = 0.0;
            }

            protected void addPhase(double amount, double waste, boolean bNewPhase, boolean sumTotal) {
                if (sumTotal) {
                    this.totalAmount += amount;
                    this.totalWaste += waste;
                }
                if (bNewPhase) {
                    this.phaseAmount = amount;
                    this.phaseWaste = waste;
                } else {
                    this.phaseAmount += amount;
                    this.phaseWaste += waste;
                }
                long t = System.currentTimeMillis();
                if (this.totalAmount + this.totalWaste == 0.0) {
                    if (this.lastCall == 0L) {
                        this.lastCall = t;
                        this.amountLast = 0.0;
                    } else if (t - this.lastCall < 30000L && !bNewPhase) {
                        this.amountLast += amount + waste;
                    } else {
                        this.amountLast += amount + waste;
                        double deltaT = t - this.lastCall;
                        this.speed = (deltaT /= 3600000.0) == 0.0 ? 0.0 : this.amountLast / deltaT;
                        this.amountLast = 0.0;
                        this.lastCall = t;
                    }
                }
            }
        }
    }
}

