/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.resource.process.JDFFileSpec;

public abstract class JDFAutoDefect
extends JDFElement {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[7];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoDefect(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoDefect(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoDefect(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    public void setBox(JDFRectangle value) {
        this.setAttribute("Box", (JDFNumList)value, (String)null);
    }

    public JDFRectangle getBox() {
        String strAttrName = this.getAttribute("Box", null, null);
        JDFRectangle nPlaceHolder = JDFRectangle.createRectangle(strAttrName);
        return nPlaceHolder;
    }

    public void setDefectReason(String value) {
        this.setAttribute("DefectReason", value, null);
    }

    public String getDefectReason() {
        return this.getAttribute("DefectReason", null, "");
    }

    public void setDefectType(EnumDefectType enumVar) {
        this.setAttribute("DefectType", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumDefectType getDefectType() {
        return EnumDefectType.getEnum(this.getAttribute("DefectType", null, null));
    }

    public void setDefectTypeDetails(String value) {
        this.setAttribute("DefectTypeDetails", value, null);
    }

    public String getDefectTypeDetails() {
        return this.getAttribute("DefectTypeDetails", null, "");
    }

    public void setFace(EnumFace enumVar) {
        this.setAttribute("Face", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumFace getFace() {
        return EnumFace.getEnum(this.getAttribute("Face", null, null));
    }

    public void setSeverity(int value) {
        this.setAttribute("Severity", value, (String)null);
    }

    public int getSeverity() {
        return this.getIntAttribute("Severity", null, 0);
    }

    public void setSize(double value) {
        this.setAttribute("Size", value, null);
    }

    public double getSize() {
        return this.getRealAttribute("Size", null, 0.0);
    }

    public JDFFileSpec getFileSpec() {
        return (JDFFileSpec)this.getElement("FileSpec", null, 0);
    }

    public JDFFileSpec getCreateFileSpec() {
        return (JDFFileSpec)this.getCreateElement_JDFElement("FileSpec", null, 0);
    }

    public JDFFileSpec appendFileSpec() {
        return (JDFFileSpec)this.appendElementN("FileSpec", 1, null);
    }

    static {
        JDFAutoDefect.atrInfoTable[0] = new AtrInfoTable("Box", 0x3331111111L, AttributeInfo.EnumAttributeType.rectangle, null, null);
        JDFAutoDefect.atrInfoTable[1] = new AtrInfoTable("DefectReason", 0x3333333311L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoDefect.atrInfoTable[2] = new AtrInfoTable("DefectType", 0x3333333311L, AttributeInfo.EnumAttributeType.enumeration, EnumDefectType.getEnum(0), null);
        JDFAutoDefect.atrInfoTable[3] = new AtrInfoTable("DefectTypeDetails", 0x3333333311L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoDefect.atrInfoTable[4] = new AtrInfoTable("Face", 0x3333333311L, AttributeInfo.EnumAttributeType.enumeration, EnumFace.getEnum(0), null);
        JDFAutoDefect.atrInfoTable[5] = new AtrInfoTable("Severity", 0x3331111111L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoDefect.atrInfoTable[6] = new AtrInfoTable("Size", 0x3333333311L, AttributeInfo.EnumAttributeType.double_, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFAutoDefect.elemInfoTable[0] = new ElemInfoTable("FileSpec", 0x6666666611L);
    }

    public static class EnumDefectType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumDefectType FinishingDefect = new EnumDefectType("FinishingDefect");
        public static final EnumDefectType ImageDefect = new EnumDefectType("ImageDefect");
        public static final EnumDefectType ImageFinishingDefect = new EnumDefectType("ImageFinishingDefect");
        public static final EnumDefectType Other = new EnumDefectType("Other");
        public static final EnumDefectType SheetDefect = new EnumDefectType("SheetDefect");
        public static final EnumDefectType SubstrateDefect = new EnumDefectType("SubstrateDefect");

        protected EnumDefectType(String name) {
            super(name, m_startValue++);
        }

        public static EnumDefectType getEnum(String enumName) {
            return (EnumDefectType)EnumDefectType.getEnum(EnumDefectType.class, (String)enumName);
        }

        public static EnumDefectType getEnum(int enumValue) {
            return (EnumDefectType)EnumDefectType.getEnum(EnumDefectType.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumDefectType.getEnumMap(EnumDefectType.class);
        }

        public static List getEnumList() {
            return EnumDefectType.getEnumList(EnumDefectType.class);
        }

        public static Iterator iterator() {
            return EnumDefectType.iterator(EnumDefectType.class);
        }
    }

    public static class EnumFace
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumFace Top = new EnumFace("Top");
        public static final EnumFace Bottom = new EnumFace("Bottom");
        public static final EnumFace Left = new EnumFace("Left");
        public static final EnumFace Right = new EnumFace("Right");
        public static final EnumFace Front = new EnumFace("Front");
        public static final EnumFace Back = new EnumFace("Back");

        protected EnumFace(String name) {
            super(name, m_startValue++);
        }

        public static EnumFace getEnum(String enumName) {
            return (EnumFace)EnumFace.getEnum(EnumFace.class, (String)enumName);
        }

        public static EnumFace getEnum(int enumValue) {
            return (EnumFace)EnumFace.getEnum(EnumFace.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumFace.getEnumMap(EnumFace.class);
        }

        public static List getEnumList() {
            return EnumFace.getEnumList(EnumFace.class);
        }

        public static Iterator iterator() {
            return EnumFace.iterator(EnumFace.class);
        }
    }
}

