/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.util.Collection;
import java.util.List;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoSeparationList;
import org.cip4.jdflib.core.JDFConstants;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.resource.process.JDFSeparationSpec;

public class JDFSeparationList
extends JDFAutoSeparationList {
    public static final VString SEPARATIONS_CMYK = JDFConstants.SEPARATIONS_CMYK;
    private static final long serialVersionUID = 1L;

    public JDFSeparationList(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFSeparationList(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFSeparationList(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFSeparationList[ -->" + super.toString() + "]";
    }

    public VString getSeparations() {
        VString vName = new VString();
        Collection<JDFSeparationSpec> v = this.getAllSeparationSpec();
        for (JDFSeparationSpec sep : v) {
            String sepName = sep.getName();
            vName.add(sepName);
        }
        return vName;
    }

    public StringArray getSeparationList() {
        StringArray vName = new StringArray();
        Collection<JDFSeparationSpec> v = this.getAllSeparationSpec();
        for (JDFSeparationSpec sep : v) {
            vName.add(sep.getName());
        }
        return vName;
    }

    public void setSeparations(List<String> vSeps) {
        this.removeChildren("SeparationSpec", null, null);
        this.appendSeparations(vSeps);
    }

    public void setSeparations(VString vSeps) {
        this.setSeparations((List<String>)vSeps);
    }

    public void appendSeparations(VString vSeps) {
        this.appendSeparations((List<String>)vSeps);
    }

    public void appendSeparations(List<String> vSeps) {
        if (vSeps != null) {
            for (String sep : vSeps) {
                this.appendSeparation(sep);
            }
        }
    }

    public void ensureSeparations(VString vSeps) {
        this.ensureSeparations((List<String>)vSeps);
    }

    public void ensureSeparations(List<String> vSeps) {
        if (vSeps != null) {
            for (String sep : vSeps) {
                this.getCreateSeparation(sep);
            }
        }
    }

    public void setCMYK() {
        this.setSeparations(SEPARATIONS_CMYK);
    }

    public JDFSeparationSpec getCreateSeparation(String sep) {
        JDFSeparationSpec separationSpec = this.getSeparationSpec(sep);
        if (separationSpec == null) {
            return this.appendSeparation(sep);
        }
        return separationSpec;
    }

    public JDFSeparationSpec appendSeparation(String sep) {
        JDFSeparationSpec separationSpec = this.appendSeparationSpec();
        separationSpec.setName(sep);
        return separationSpec;
    }

    public JDFSeparationSpec getSeparationSpec(String sep) {
        return (JDFSeparationSpec)this.getChildWithAttribute("SeparationSpec", "Name", null, sep, 0, true);
    }

    public int removeSeparation(String sep) {
        VString vs = this.getSeparations();
        int index = vs.index(sep);
        if (index >= 0) {
            this.getSeparationSpec(index).deleteNode();
        }
        return index;
    }

    public String getSeparation(int iSkip) {
        JDFSeparationSpec ss = this.getSeparationSpec(iSkip);
        if (ss == null) {
            return null;
        }
        return ss.getName();
    }

    public VString unify() {
        VString v = this.getSeparations();
        int l = v.size();
        v.unify();
        if (v.size() != l) {
            this.setSeparations(v);
        }
        return v;
    }

    public void removeSeparations(List<String> seps) {
        if (seps != null) {
            for (String sep : seps) {
                this.removeSeparation(sep);
            }
        }
    }
}

