/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.extensions.AbstractXJDFSplit;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class ProcessXJDFSplit
extends AbstractXJDFSplit {
    private final Vector<VString> groups = new Vector();

    protected Vector<VString> getGroups() {
        return this.groups;
    }

    @Override
    public Collection<XJDFHelper> splitXJDF(XJDFHelper root) {
        this.prepareRoot(root);
        Vector<VString> newTypes = this.splitTypes(root);
        Vector<XJDFHelper> ret = new Vector<XJDFHelper>();
        if (newTypes != null && newTypes.size() > 0) {
            VString allTypes = root.getTypes();
            for (VString types : newTypes) {
                XJDFHelper h = root.clone();
                this.processSingle(h, types, allTypes);
                ret.add(h);
            }
            this.consolidateExchangeResources(ret);
        } else {
            ret.add(root);
        }
        return ret;
    }

    protected void prepareRoot(XJDFHelper root) {
        Vector<SetHelper> sets;
        Vector<SetHelper> vector = sets = root == null ? null : root.getSets();
        if (sets != null) {
            for (SetHelper set : sets) {
                set.ensureID();
            }
        }
    }

    protected void processSingle(XJDFHelper h, VString types, VString allTypes) {
        this.fixCategory(h, types, allTypes);
        h.setJobPartID(this.getJobPartID(h, types));
        h.setTypes(types);
        h.setID(null);
        this.fixInOutLinks(h, allTypes);
    }

    protected void fixCategory(XJDFHelper h, VString types, VString allTypes) {
        if (!"Product".equals(types.get(0)) || ContainerUtil.equals(types, allTypes)) {
            h.removeAttribute("Category", null);
        }
    }

    protected String getJobPartID(XJDFHelper xjdf, VString types) {
        String jobPartID = xjdf.getJobPartID();
        if (jobPartID == null) {
            jobPartID = "Part_";
        }
        return jobPartID + StringUtil.setvString(types, "_", ".", null);
    }

    protected Vector<VString> splitTypes(XJDFHelper root) {
        Vector<VString> ret = new Vector<VString>();
        VString types = this.calcTypes(root);
        if (types == null || types.size() <= 1) {
            return null;
        }
        boolean hasProduct = false;
        int pos = 0;
        while (types.size() > 0) {
            VString overlap = this.extractTypes(root, types, pos);
            if (overlap.contains("Product")) {
                ret.insertElementAt(overlap, 0);
                hasProduct = true;
            } else {
                ret.add(overlap);
            }
            pos += overlap.size();
        }
        if (!hasProduct && ret.size() > 1) {
            ret.insertElementAt(new VString("Product", null), 0);
        }
        return ret.size() == 0 ? null : ret;
    }

    protected VString extractTypes(XJDFHelper root, VString types, int pos) {
        block0: for (String resType : new String[]{"Device", "NodeInfo"}) {
            SetHelper resSet = root.getSet(resType, JDFResourceLink.EnumUsage.Input, null, pos);
            if (resSet == null) continue;
            JDFIntegerList cpi = resSet.getCombinedProcessIndex();
            VString found = new VString();
            int[] il = cpi.getIntArray();
            Arrays.sort(il);
            int currentPos = pos;
            for (int ipos : il) {
                if (ipos != currentPos++) continue block0;
                found.add(types.get(ipos - pos));
            }
            for (int i = 0; i < il.length; ++i) {
                types.remove(0);
            }
            return found;
        }
        return this.extractTypes(types);
    }

    protected VString extractTypes(VString types) {
        String first = types.get(0);
        VString overlap = null;
        for (VString group : this.groups) {
            VString newOverlap;
            if (!group.contains(first) || (newOverlap = types.getOverlapping(group)) == null || overlap != null && overlap.size() >= newOverlap.size()) continue;
            overlap = newOverlap;
        }
        if (overlap == null) {
            overlap = new VString();
            overlap.add(first);
        }
        types.removeAll(overlap);
        return overlap;
    }

    protected VString calcTypes(XJDFHelper root) {
        VString types;
        boolean hasType = root.indexOfType("Product", 0) >= 0;
        Vector<ProductHelper> productHelpers = root.getProductHelpers();
        if (!hasType && productHelpers != null) {
            root.addType("Product", 0);
        }
        if ((types = root.getTypes()) == null) {
            types = new VString("Product", null);
        }
        return types;
    }

    public void addGroup(VString group) {
        if (group != null && !group.isEmpty()) {
            this.groups.add(group);
            ContainerUtil.unify(this.groups);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [groups=" + String.valueOf(this.groups) + "]";
    }
}

