/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.FixVersion;
import org.cip4.jdflib.elementwalker.IWalker;
import org.cip4.jdflib.elementwalker.PackageElementWalker;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.XJMFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.RemoveEmptyXJDF;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.AuditMover;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.MultiJDFToXJDF;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.MultiXJDFCombiner;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.PostXJDFWalker;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkElement;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkResource;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.MyPair;
import org.cip4.jdflib.util.StringUtil;

public class JDFToXJDF
extends PackageElementWalker {
    private static JDFElement.EnumVersion defaultVersion = BaseXJDFHelper.getDefaultVersion();
    private static final Log log = LogFactory.getLog(JDFToXJDF.class);
    public static final String rootName = "XJDF";
    public static final String rootJMF = "JMF";
    private boolean trackAudits = true;
    protected KElement newRoot = null;
    protected JDFNode oldRoot = null;
    protected Set<String> first = new HashSet<String>();
    private boolean bExplicitWaste = true;
    private boolean bRetainAll = false;
    private boolean bCleanup = true;
    private boolean bPreprocess = true;
    private boolean bMergeLayout = true;
    private boolean bMergeLayoutPrep = true;
    private boolean bMergeRunList = true;
    private boolean bRetainSpawnInfo = false;
    private boolean bSingleNode = false;
    private boolean bUpdateVersion = true;
    private boolean bTypeSafeMessage = true;
    private boolean bAbstractMessage = false;
    private boolean bSpanAsAttribute = true;
    private boolean bIntentPartition = false;
    private boolean bParameterSet = false;
    boolean wantProduct = true;
    private final HashMap<MyPair<String, JDFAttributeMap>, String> componentProductMap;
    final Set<String> resourceAlias;
    final HashMap<JDFAttributeMap, String> completedRefs;
    private boolean bHTMLColor = false;
    private boolean bConvertTilde = true;
    String rootID = null;
    private boolean removeSignatureName = true;
    private EnumProcessPartition processPartition = EnumProcessPartition.processTypes;
    private boolean wantDependent;
    private JDFElement.EnumVersion newVersion;
    boolean wantImplicit;

    public static void setDefaultVersion(JDFElement.EnumVersion v) {
        if (!EnumUtil.aLessThanB(v, JDFElement.EnumVersion.Version_2_0)) {
            defaultVersion = v;
        }
    }

    public static JDFElement.EnumVersion getDefaultVersion() {
        return defaultVersion;
    }

    public JDFToXJDF() {
        super(new BaseWalkerFactory());
        KElement.uniqueID(-1000);
        this.componentProductMap = new HashMap();
        this.resourceAlias = new HashSet<String>();
        this.completedRefs = new HashMap();
        this.wantDependent = true;
        this.newVersion = JDFToXJDF.getDefaultVersion();
        this.wantImplicit = true;
    }

    protected Set<String> getResourceAlias() {
        return this.resourceAlias;
    }

    @Override
    protected BaseWalker constructWalker(String name) {
        WalkElement constructWalker = (WalkElement)super.constructWalker(name);
        if (constructWalker != null) {
            constructWalker.setParent(this);
        }
        return constructWalker;
    }

    protected String getClassName(JDFResource r) {
        WalkResource w = this.getWalker(r);
        return w == null ? null : w.getClassName(r);
    }

    protected WalkResource getWalker(JDFResource r) {
        if (r == null) {
            return null;
        }
        IWalker walker = this.theFactory.getWalker(r);
        return walker instanceof WalkResource ? (WalkResource)walker : null;
    }

    public void setTrackAudits(boolean trackAudits) {
        this.trackAudits = trackAudits;
    }

    public static String getSchemaURL() {
        return JDFElement.getSchemaURL(2, 0);
    }

    String getSchemaURL(JDFElement.EnumVersion version) {
        return JDFElement.getSchemaURL(version == null ? this.getNewVersion() : version);
    }

    public boolean isExplicitWaste() {
        return this.bExplicitWaste;
    }

    public void setExplicitWaste(boolean bExplicitWaste) {
        this.bExplicitWaste = bExplicitWaste;
    }

    public boolean isPreprocess() {
        return this.bPreprocess;
    }

    public void setPreprocess(boolean bPreprocess) {
        this.bPreprocess = bPreprocess;
    }

    public boolean isParameterSet() {
        return this.bParameterSet;
    }

    public void setParameterSet(boolean bParameterSet) {
        this.bParameterSet = bParameterSet;
    }

    public boolean isWantProduct() {
        return this.wantProduct;
    }

    public void setWantProduct(boolean wantProduct) {
        this.wantProduct = wantProduct;
    }

    public JDFElement.EnumVersion getNewVersion() {
        return this.newVersion == null ? JDFToXJDF.getDefaultVersion() : this.newVersion;
    }

    public void setNewVersion(JDFElement.EnumVersion newVersion) {
        this.newVersion = newVersion == null ? JDFToXJDF.getDefaultVersion() : newVersion;
    }

    public void setProcessPart(EnumProcessPartition process) {
        this.processPartition = process;
    }

    public boolean isRemoveSignatureName() {
        return this.removeSignatureName;
    }

    public void setRemoveSignatureName(boolean removeSignatureName) {
        this.removeSignatureName = removeSignatureName;
    }

    public XJDFHelper convertToXJDF(KElement root) {
        return XJDFHelper.getHelper(this.convert(root));
    }

    public XJMFHelper convertToXJMF(KElement root) {
        return XJMFHelper.getHelper(this.convert(root));
    }

    public KElement convert(KElement root) {
        if (root instanceof JDFJMF) {
            return this.makeNewJMF((JDFJMF)root);
        }
        if (root instanceof JDFNode) {
            return this.makeNewJDF((JDFNode)root, null);
        }
        return null;
    }

    public KElement makeNewJMF(JDFJMF jmf) {
        this.prepareNewDoc(true);
        if (jmf != null) {
            JDFJMF root = (JDFJMF)jmf.cloneNewDoc();
            this.preFixVersion(root);
            this.walkTree(root, this.newRoot);
            this.postWalk(true);
        } else {
            this.newRoot = null;
        }
        return this.newRoot;
    }

    public KElement makeNewJDF(JDFNode node, VJDFAttributeMap vMap) {
        this.prepareNewDoc(false);
        if (node != null) {
            this.rootID = node.appendAnchor(null);
            JDFNode root = (JDFNode)node.getJDFRoot().cloneNewDoc();
            this.preFixVersion(root);
            String id = StringUtil.getNonEmpty(node.getID());
            JDFNode jDFNode = this.oldRoot = id == null ? root : (JDFNode)root.getChildWithAttribute(null, "ID", null, id, 0, false);
            if (this.oldRoot == null) {
                this.oldRoot = root;
            }
            if (this.oldRoot == root && root.getElement("JDF") == null && root.getAncestorPool() == null) {
                this.setSingleNode(true);
            }
            this.prepareRoot(root);
            this.loopNodes(root);
            this.postWalk(false);
            this.newRoot.getOwnerDocument_KElement().copyMeta(node.getOwnerDocument_KElement());
        } else {
            this.newRoot = null;
        }
        return this.newRoot;
    }

    void preFixVersion(JDFElement root) {
        if (this.isPreprocess()) {
            FixVersion vers = new FixVersion(this.getNewVersion());
            vers.setLayoutPrepToStripping(this.bMergeLayoutPrep);
            vers.setZappDeprecated(true);
            vers.addIgnore("Activity", "Roles");
            vers.walkTree(root, null);
        }
    }

    void postWalk(boolean bJMF) {
        PostXJDFWalker pw = this.getPostWalker();
        if (bJMF) {
            this.postWalkJMF(pw);
        } else {
            this.postWalkJDF(pw);
        }
        RemoveEmptyXJDF removeEmpty = new RemoveEmptyXJDF();
        removeEmpty.removEmptyElement(this.newRoot);
    }

    void postWalkJDF(PostXJDFWalker pw) {
        new AuditMover(this.newRoot).copySetsToAudits();
        pw.walkTreeKidsFirst(this.newRoot);
        if (this.trackAudits) {
            boolean hasCreated;
            JDFAuditPool auditPool = (JDFAuditPool)this.newRoot.getCreateElement("AuditPool");
            boolean bl = hasCreated = auditPool.hasChildElement("Created", null) || auditPool.hasChildElement("AuditCreated", null);
            if (!hasCreated) {
                KElement c = auditPool.appendElement("AuditCreated");
                KElement header = c.appendElement("Header");
                header.setAttribute("AgentName", "JDF To XJDF Converter");
                header.setAttribute("AgentVersion", JDFAudit.getStaticAgentVersion());
                header.setAttribute("Time", new JDFDate().getDateTimeISO());
            }
        }
        if (this.isCleanup()) {
            new XJDFHelper(this.newRoot).cleanUp();
        }
    }

    void postWalkJMF(PostXJDFWalker pw) {
        pw.walkTreeKidsFirst(this.newRoot);
        if (this.newRoot.numChildElements(null, null) == this.newRoot.numChildElements("Header", null)) {
            log.info((Object)"erased empty jmf");
            this.newRoot = null;
        } else if (!this.isRetainAll() && this.isCleanup()) {
            new XJMFHelper(this.newRoot).cleanUp();
        }
    }

    PostXJDFWalker getPostWalker() {
        PostXJDFWalker pw = new PostXJDFWalker((JDFElement)this.newRoot);
        pw.setMergeLayout(this.bMergeLayout);
        pw.setIntentPartition(this.bIntentPartition);
        pw.setRemoveSignatureName(this.removeSignatureName);
        pw.setRetainAll(this.bRetainAll);
        pw.setNewVersion(this.getNewVersion());
        pw.combineSameSets();
        return pw;
    }

    private void prepareRoot(JDFNode node) {
        if (node != null) {
            node.ensureLink(node.getInheritedCustomerInfo(null), JDFResourceLink.EnumUsage.Input, null);
            node.ensureLink(node.getInheritedNodeInfo(null), JDFResourceLink.EnumUsage.Input, null);
        }
    }

    private void loopNodes(JDFNode node) {
        this.walkTree(node, this.newRoot);
    }

    private void prepareNewDoc(boolean bJMF) {
        JDFDoc newDoc = new JDFDoc(bJMF ? (this.bTypeSafeMessage ? "XJMF" : rootJMF) : rootName, this.getNewVersion());
        newDoc.setInitOnCreate(false);
        this.newRoot = newDoc.getRoot();
        this.newRoot.setNamespaceURI(this.getSchemaURL(this.newVersion));
        if (EnumUtil.aLessThanB(JDFElement.EnumVersion.Version_2_0, this.newVersion)) {
            this.newRoot.setAttribute("Version", this.newVersion.getName());
        }
        this.newRoot.setNamespaceURI(this.getSchemaURL(this.newVersion));
        this.first = new HashSet<String>();
    }

    protected void putComponentProduct(String compID, JDFAttributeMap partMap, String productID) {
        this.componentProductMap.put(new MyPair<String, JDFAttributeMap>(compID, partMap), productID);
    }

    protected String getProduct(String compID, JDFAttributeMap partMap) {
        return this.componentProductMap.get(new MyPair<String, JDFAttributeMap>(compID, partMap));
    }

    public static String getExtension() {
        return rootName.toLowerCase();
    }

    public void saveZip(String fileName, JDFNode rootNode, boolean replace) {
        new MultiJDFToXJDF(this).saveZip(fileName, rootNode, replace);
    }

    public void writeStream(OutputStream os, JDFNode rootNode, JDFJMF jmf) {
        try {
            new MultiJDFToXJDF(this).getZipWriter(rootNode).writeStream(os);
        }
        catch (IOException e) {
            log.error((Object)"oops", (Throwable)e);
        }
    }

    @Deprecated
    public Vector<XJDFHelper> getXJDFs(JDFNode root) {
        Vector<XJDFHelper> v = new Vector<XJDFHelper>();
        List<XJDFHelper> l = this.getXJDFs(root, true);
        if (l != null) {
            v.addAll(l);
        }
        return v;
    }

    public List<XJDFHelper> getXJDFs(JDFNode root, boolean ordered) {
        return new MultiJDFToXJDF(this).getXJDFs(root, ordered);
    }

    protected static VJDFAttributeMap getPartMapVector(KElement res) {
        VJDFAttributeMap omaMaps = null;
        VElement parts = res.getChildElementVector("Part", null, null, true, 0, false);
        if (parts != null && parts.size() > 0) {
            omaMaps = new VJDFAttributeMap();
            for (int i = 0; i < parts.size(); ++i) {
                omaMaps.add(((JDFPart)parts.get(i)).getPartMap());
            }
        }
        return omaMaps;
    }

    @Deprecated
    public void retainAll() {
        this.setRetainAll(true);
    }

    public void setUpdateVersion(boolean bUpdateVersion) {
        this.bUpdateVersion = bUpdateVersion;
    }

    public boolean isMergeLayout() {
        return this.bMergeLayout;
    }

    public void setMergeLayout(boolean bMergeLayout) {
        this.bMergeLayout = bMergeLayout;
    }

    public boolean isMergeLayoutPrep() {
        return this.bMergeLayoutPrep;
    }

    public void setMergeLayoutPrep(boolean bMergeLayoutPrep) {
        this.bMergeLayoutPrep = bMergeLayoutPrep;
    }

    public boolean isMergeRunList() {
        return this.bMergeRunList;
    }

    public void setMergeRunList(boolean bMergeRunList) {
        this.bMergeRunList = bMergeRunList;
    }

    public boolean isRetainSpawnInfo() {
        return this.bRetainSpawnInfo;
    }

    public void setRetainSpawnInfo(boolean bRetainSpawnInfo) {
        this.bRetainSpawnInfo = bRetainSpawnInfo;
    }

    public boolean isSingleNode() {
        return this.bSingleNode;
    }

    public void setSingleNode(boolean bSingleNode) {
        this.bSingleNode = bSingleNode;
    }

    public boolean isUpdateVersion() {
        return this.bUpdateVersion;
    }

    public boolean isTypeSafeMessage() {
        return this.bTypeSafeMessage;
    }

    public void setTypeSafeMessage(boolean bTypeSafeMessage) {
        this.bTypeSafeMessage = bTypeSafeMessage;
    }

    public boolean isAbstractMessage() {
        return this.bAbstractMessage;
    }

    public void setAbstractMessage(boolean bAbstractMessage) {
        this.bAbstractMessage = bAbstractMessage;
    }

    public boolean isSpanAsAttribute() {
        return this.bSpanAsAttribute;
    }

    public void setSpanAsAttribute(boolean bSpanAsAttribute) {
        this.bSpanAsAttribute = bSpanAsAttribute;
    }

    public boolean isIntentPartition() {
        return this.bIntentPartition;
    }

    public void setIntentPartition(boolean bIntentPartition) {
        this.bIntentPartition = bIntentPartition;
    }

    public boolean isHTMLColor() {
        return this.bHTMLColor;
    }

    public void setHTMLColor(boolean bHTMLColor) {
        this.bHTMLColor = bHTMLColor;
    }

    public boolean isConvertTilde() {
        return this.bConvertTilde;
    }

    public void setConvertTilde(boolean bConvertTilde) {
        this.bConvertTilde = bConvertTilde;
    }

    protected String getSetName(JDFResource r) {
        WalkResource w = this.getWalker(r);
        return w == null ? null : w.getXJDFName(r);
    }

    protected boolean isProductResource(JDFResource linkTarget) {
        WalkResource w = this.getWalker(linkTarget);
        return w == null ? false : w.isProductResource(linkTarget);
    }

    public boolean isRetainAll() {
        return this.bRetainAll;
    }

    public void setRetainAll(boolean bRetainAll) {
        this.bRetainAll = bRetainAll;
        if (bRetainAll) {
            this.setAbstractMessage(false);
            this.setConvertTilde(false);
            this.setExplicitWaste(false);
            this.setHTMLColor(false);
            this.setMergeLayout(false);
            this.setMergeLayoutPrep(false);
            this.setMergeRunList(false);
            this.setRemoveSignatureName(false);
            this.setRetainSpawnInfo(true);
            this.setTypeSafeMessage(false);
            this.setUpdateVersion(false);
            this.setCleanup(false);
        }
    }

    public EnumProcessPartition getProcessPart() {
        return this.processPartition;
    }

    public boolean isWantProcessList() {
        return EnumProcessPartition.processList.equals((Object)this.processPartition);
    }

    public boolean isCleanup() {
        return this.bCleanup;
    }

    public void setCleanup(boolean bCleanup) {
        this.bCleanup = bCleanup;
    }

    public XJDFHelper getCombined(JDFNode node) {
        boolean oldCleanup = this.isCleanup();
        this.setCleanup(false);
        this.setWantDependent(false);
        List<XJDFHelper> v = this.getXJDFs(node, true);
        XJDFHelper combinedHelper = new MultiXJDFCombiner(v).getCombinedHelper();
        this.setCleanup(oldCleanup);
        if (this.isCleanup() && combinedHelper != null) {
            combinedHelper.cleanUp();
        }
        return combinedHelper;
    }

    public boolean wantDependent() {
        return this.wantDependent;
    }

    public void setWantDependent(boolean wantDependent) {
        this.wantDependent = wantDependent;
    }

    @Override
    public String toString() {
        return "JDFToXJDF [trackAudits=" + this.trackAudits + ", newRoot=" + String.valueOf(this.newRoot) + ", oldRoot=" + String.valueOf(this.oldRoot) + ", first=" + String.valueOf(this.first) + ", bExplicitWaste=" + this.bExplicitWaste + ", bRetainAll=" + this.bRetainAll + ", bCleanup=" + this.bCleanup + ", bMergeLayout=" + this.bMergeLayout + ", bMergeLayoutPrep=" + this.bMergeLayoutPrep + ", bMergeRunList=" + this.bMergeRunList + ", bRetainSpawnInfo=" + this.bRetainSpawnInfo + ", bSingleNode=" + this.bSingleNode + ", bUpdateVersion=" + this.bUpdateVersion + ", bTypeSafeMessage=" + this.bTypeSafeMessage + ", bAbstractMessage=" + this.bAbstractMessage + ", bSpanAsAttribute=" + this.bSpanAsAttribute + ", bIntentPartition=" + this.bIntentPartition + ", bParameterSet=" + this.bParameterSet + ", wantProduct=" + this.wantProduct + ", componentProductMap=" + String.valueOf(this.componentProductMap) + ", resourceAlias=" + String.valueOf(this.resourceAlias) + ", bHTMLColor=" + this.bHTMLColor + ", bConvertTilde=" + this.bConvertTilde + ", rootID=" + this.rootID + ", removeSignatureName=" + this.removeSignatureName + ", processPartition=" + String.valueOf((Object)this.processPartition) + ", wantDependent=" + this.wantDependent + ", newVersion=" + String.valueOf((Object)this.newVersion) + "]";
    }

    public boolean wantImplicit() {
        return this.wantImplicit;
    }

    public void setwantImplicit(boolean wantImplicit) {
        this.wantImplicit = wantImplicit;
    }

    public static enum EnumProcessPartition {
        zip,
        processList,
        processTypes,
        jobPartID,
        processUsageJobPartID;

    }
}

