/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.resource.JDFModuleStatus;
import org.cip4.jdflib.util.StringUtil;

public class WalkDeviceInfo
extends WalkXElement {
    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFDeviceInfo;
    }

    @Override
    public VString getElementNames() {
        return new VString("DeviceInfo", null);
    }

    @Override
    protected void updateAttributes(KElement elem) {
        JDFDeviceInfo di = (JDFDeviceInfo)elem;
        di.renameAttribute("Status", "DeviceStatus");
        String newStatus = WalkDeviceInfo.updateDeviceStatus(elem.getNonEmpty("DeviceStatus"));
        di.setAttribute("DeviceStatus", newStatus);
        di.setDeviceCondition(di.getDeviceCondition());
        this.updateModuleIDS(elem);
        super.updateAttributes(elem);
    }

    private void updateModuleIDS(KElement elem) {
        VString modules = VString.getVString(elem.getNonEmpty("ModuleIDs"), null);
        elem.removeAttribute("ModuleIDs");
        if (modules != null) {
            for (String module : modules) {
                JDFModuleStatus mp = (JDFModuleStatus)elem.appendElement("ModuleStatus");
                mp.setModuleID(module);
                mp.copyAttribute("DeviceStatus", elem);
                mp.setModuleType("Unknown");
            }
        }
    }

    static String updateDeviceStatus(String val) {
        if (StringUtil.getNonEmpty(val) != null) {
            if ("Offline".equals(val)) {
                val = "Unknown";
            } else if ("Production".equals(val)) {
                val = "Running";
            }
        }
        return val;
    }
}

