/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process.prepress;

import java.util.Collection;
import java.util.HashMap;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.util.ContainerUtil;

public class PaginationCatalog {
    HashMap<String, CatalogEntry> theMap = this.fill();
    static final PaginationCatalog theCatalog = new PaginationCatalog();

    private void putMap(String fc, int rows, int[] pages) {
        this.theMap.put(fc.toLowerCase(), new CatalogEntry(rows, pages));
    }

    private HashMap<String, CatalogEntry> fill() {
        this.theMap = new HashMap();
        this.putMap("F2-1", 1, new int[]{1});
        this.putMap("F4-1", 1, new int[]{2, 3});
        this.putMap("F4-2", 1, new int[]{4, 1});
        this.putMap("F6-1", 1, new int[]{5, 4, 1});
        this.putMap("F6-2", 1, new int[]{1, 4, 5});
        this.putMap("F6-4", 1, new int[]{3, 2, 5});
        this.putMap("F6-5", 1, new int[]{2, 5, 4});
        this.putMap("F6-8", 1, new int[]{6, 3, 2});
        this.putMap("F8-1", 1, new int[]{6, 3, 2, 7});
        this.putMap("F8-2", 1, new int[]{2, 7, 6, 3});
        this.putMap("F8-3", 1, new int[]{2, 3, 6, 7});
        this.putMap("F8-4", 1, new int[]{3, 2, 7, 6});
        this.putMap("F8-5", 1, new int[]{4, 5, 2, 7});
        this.putMap("F8-6", 1, new int[]{2, 7, 4, 5});
        this.putMap("F8-7", 2, new int[]{3, 2, 6, 7});
        this.putMap("F10-1", 1, new int[]{9, 8, 5, 4, 1});
        this.putMap("F10-2", 1, new int[]{2, 9, 4, 7, 6});
        this.putMap("F10-3", 1, new int[]{2, 9, 8, 3, 6});
        this.putMap("F12-1", 1, new int[]{2, 11, 10, 3, 6, 7});
        this.putMap("F12-2", 1, new int[]{10, 3, 2, 11, 8, 5});
        this.putMap("F12-3", 1, new int[]{10, 7, 2, 3, 6, 11});
        this.putMap("F12-4", 1, new int[]{2, 11, 6, 7, 10, 3});
        this.putMap("F12-5", 1, new int[]{7, 2, 11, 10, 3, 6});
        this.putMap("F12-6", 1, new int[]{2, 3, 6, 7, 10, 11});
        this.putMap("F12-7", 2, new int[]{2, 3, 6, 11, 10, 7});
        this.putMap("F12-8", 2, new int[]{1, 4, 5, 12, 9, 8});
        this.putMap("F12-9", 2, new int[]{4, 5, 2, 9, 8, 11});
        this.putMap("F12-10", 2, new int[]{5, 2, 3, 8, 11, 10});
        this.putMap("F12-11", 2, new int[]{7, 6, 3, 10, 11, 2});
        this.putMap("F12-12", 3, new int[]{3, 2, 10, 11, 7, 6});
        this.putMap("F12-13", 3, new int[]{6, 7, 3, 2, 10, 11});
        this.putMap("F12-14", 3, new int[]{10, 11, 7, 6, 2, 3});
        this.putMap("F14-1", 1, new int[]{13, 12, 9, 8, 5, 4, 1});
        this.putMap("F16-1", 1, new int[]{10, 7, 2, 15, 14, 3, 6, 11});
        this.putMap("F16-2", 1, new int[]{2, 15, 10, 7, 6, 11, 14, 3});
        this.putMap("F16-3", 1, new int[]{6, 11, 14, 3, 2, 15, 10, 7});
        this.putMap("F16-4", 1, new int[]{14, 3, 6, 11, 10, 7, 2, 15});
        this.putMap("F16-5", 1, new int[]{16, 13, 12, 9, 8, 5, 4, 1});
        this.putMap("F16-6", 2, new int[]{6, 11, 10, 7, 3, 14, 15, 2});
        this.putMap("F16-7", 2, new int[]{14, 3, 2, 15, 11, 6, 7, 10});
        this.putMap("F16-8", 2, new int[]{10, 7, 6, 11, 16, 2, 3, 14});
        this.putMap("F16-9", 2, new int[]{7, 2, 3, 6, 10, 15, 14, 11});
        this.putMap("F16-10", 2, new int[]{3, 6, 7, 2, 14, 11, 10, 15});
        this.putMap("F16-11", 2, new int[]{7, 6, 3, 2, 10, 11, 14, 15});
        this.putMap("F16-12", 2, new int[]{5, 4, 7, 2, 12, 13, 10, 15});
        this.putMap("F16-13", 4, new int[]{3, 2, 14, 15, 11, 10, 6, 7});
        this.putMap("F18-1", 1, new int[]{17, 16, 13, 12, 9, 8, 5, 4, 1});
        this.putMap("F18-2", 1, new int[]{2, 11, 14, 17, 8, 5, 4, 9, 16});
        this.putMap("F18-3", 1, new int[]{2, 17, 8, 9, 16, 3, 6, 13, 12});
        this.putMap("F18-4", 1, new int[]{17, 8, 5, 4, 9, 16, 13, 12, 1});
        this.putMap("F18-5", 3, new int[]{17, 16, 13, 8, 9, 12, 5, 4, 1});
        this.putMap("F18-6", 3, new int[]{2, 3, 6, 17, 16, 13, 8, 9, 12});
        this.putMap("F18-7", 3, new int[]{15, 14, 17, 10, 11, 8, 3, 2, 5});
        this.putMap("F18-8", 3, new int[]{4, 5, 2, 15, 14, 17, 10, 11, 8});
        this.putMap("F18-9", 3, new int[]{13, 16, 17, 12, 9, 8, 1, 4, 5});
        this.putMap("F20-1", 2, new int[]{9, 2, 3, 8, 5, 12, 19, 18, 13, 16});
        this.putMap("F20-2", 2, new int[]{2, 3, 6, 7, 10, 19, 18, 15, 14, 11});
        this.putMap("F24-1", 2, new int[]{14, 11, 10, 15, 18, 7, 23, 2, 3, 22, 19, 6});
        this.putMap("F24-2", 2, new int[]{16, 9, 8, 17, 14, 11, 21, 4, 5, 20, 23, 2});
        this.putMap("F24-3", 2, new int[]{11, 2, 3, 10, 7, 6, 14, 23, 22, 15, 18, 19});
        this.putMap("F24-4", 2, new int[]{5, 8, 9, 4, 1, 12, 20, 17, 16, 21, 24, 13});
        this.putMap("F24-5", 2, new int[]{3, 10, 11, 2, 5, 8, 22, 15, 14, 23, 20, 17});
        this.putMap("F24-6", 2, new int[]{11, 10, 7, 6, 3, 2, 14, 15, 18, 19, 22, 23});
        this.putMap("F24-7", 2, new int[]{6, 19, 18, 7, 10, 15, 3, 22, 23, 2, 11, 14});
        this.putMap("F24-8", 4, new int[]{2, 3, 6, 23, 22, 19, 14, 15, 18, 11, 10, 7});
        this.putMap("F24-9", 4, new int[]{1, 4, 5, 24, 21, 20, 13, 16, 17, 12, 9, 8});
        this.putMap("F24-10", 4, new int[]{4, 5, 2, 21, 20, 23, 16, 17, 14, 9, 8, 11});
        this.putMap("F24-11", 3, new int[]{10, 15, 14, 11, 3, 22, 23, 2, 6, 19, 18, 7});
        this.putMap("F28-1", 2, new int[]{2, 3, 6, 7, 10, 11, 14, 27, 26, 23, 22, 19, 18, 15});
        this.putMap("F32-1", 1, new int[]{10, 23, 26, 7, 2, 31, 18, 15, 14, 19, 30, 3, 6, 27, 22, 11});
        this.putMap("F32-2", 2, new int[]{10, 23, 18, 15, 14, 19, 22, 11, 7, 26, 31, 2, 3, 30, 27, 6});
        this.putMap("F32-3", 2, new int[]{26, 7, 2, 31, 30, 3, 6, 27, 23, 10, 15, 18, 19, 14, 11, 22});
        this.putMap("F32-4", 4, new int[]{27, 22, 23, 26, 6, 11, 10, 7, 3, 14, 15, 2, 30, 19, 18, 31});
        this.putMap("F32-5", 4, new int[]{3, 14, 15, 2, 30, 19, 18, 31, 27, 22, 23, 26, 6, 11, 10, 7});
        this.putMap("F32-6", 4, new int[]{11, 6, 7, 10, 22, 27, 26, 23, 19, 30, 31, 18, 14, 3, 2, 15});
        this.putMap("F32-7", 4, new int[]{7, 6, 3, 2, 26, 27, 30, 31, 23, 22, 19, 18, 10, 11, 14, 15});
        this.putMap("F32-8", 4, new int[]{7, 2, 3, 6, 26, 31, 30, 27, 23, 18, 19, 22, 10, 15, 14, 11});
        this.putMap("F32-9", 4, new int[]{14, 19, 18, 15, 3, 30, 31, 2, 6, 27, 26, 7, 11, 22, 23, 10});
        return this.theMap;
    }

    public static PaginationCatalog instance() {
        return theCatalog;
    }

    public String toString() {
        return "PaginationCatalog [" + (String)(this.theMap != null ? "theMap=" + String.valueOf(this.theMap) : "") + "]";
    }

    public JDFIntegerList getFrontPages(String fc) {
        CatalogEntry catalogEntry = this.getEntry(fc);
        return catalogEntry == null ? null : catalogEntry.getFrontPages();
    }

    public JDFIntegerList getBackPages(String fc) {
        CatalogEntry catalogEntry = this.getEntry(fc);
        return catalogEntry == null ? null : catalogEntry.getBackPages();
    }

    public Collection<String> getKeys() {
        return ContainerUtil.getKeyArray(this.theMap);
    }

    public JDFXYPair getNUp(String fc) {
        CatalogEntry catalogEntry = this.getEntry(fc);
        return catalogEntry == null ? null : new JDFXYPair(catalogEntry.frontPages.length, catalogEntry.frontPages[0].length);
    }

    CatalogEntry getEntry(String fc) {
        if (fc == null) {
            return null;
        }
        return this.theMap.get(fc.toLowerCase());
    }

    class CatalogEntry {
        final int[][] frontPages;

        CatalogEntry(int rows, int[] frontPages) {
            this.frontPages = new int[frontPages.length / rows][rows];
            for (int i = 0; i < frontPages.length; ++i) {
                this.frontPages[i / rows][i % rows] = frontPages[i] - 1;
            }
        }

        JDFIntegerList getFrontPages() {
            JDFIntegerList il = new JDFIntegerList();
            int[][] nArray = this.frontPages;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] row;
                for (int p : row = nArray[i]) {
                    il.add(p);
                }
            }
            return il;
        }

        JDFIntegerList getBackPages() {
            JDFIntegerList il = new JDFIntegerList();
            int[][] nArray = this.frontPages;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] row;
                for (int p : row = nArray[i]) {
                    if (p % 2 == 0) {
                        il.add(p + 1);
                        continue;
                    }
                    il.add(p - 1);
                }
            }
            return il;
        }

        public String toString() {
            return "CatalogEntry [" + String.valueOf(this.getFrontPages()) + "]";
        }
    }
}

