/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.HashUtil;
import org.cip4.jdflib.util.JDFDate;

public class CPUTimer {
    private long createT0;
    private long realT0 = -1L;
    private long cpuT0 = -1L;
    private long currentCPU = 0L;
    private long currentReal = 0L;
    private long totalReal = 0L;
    private long toatalCPU = 0L;
    private final ThreadMXBean bean = ManagementFactory.getThreadMXBean();
    private final boolean threadCpuTimeEnabled = this.bean.isThreadCpuTimeEnabled();
    private int nStartStop = 0;
    private String name = null;

    public String getName() {
        return this.name;
    }

    public void add(CPUTimer timer) {
        long currentCPUTime;
        this.totalReal += timer.totalReal;
        this.toatalCPU += timer.toatalCPU;
        this.nStartStop = (int)((long)this.nStartStop + timer.getNumStarts());
        this.createT0 = Math.min(this.createT0, timer.getCreationTime());
        long currentRealTime = timer.getCurrentRealTime();
        if (currentRealTime > 0L) {
            this.currentReal += currentRealTime;
        }
        if ((currentCPUTime = timer.getCurrentCPUTime()) > 0L) {
            this.currentCPU += currentCPUTime;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public CPUTimer(boolean bStart) {
        this.createT0 = System.currentTimeMillis();
        if (bStart) {
            this.start();
        }
    }

    public long getTotalCPUTime() {
        if (!this.threadCpuTimeEnabled) {
            return -1L;
        }
        return this.toatalCPU + this.getCurrentCPUTime();
    }

    public long getCurrentCPUTime() {
        if (!this.threadCpuTimeEnabled) {
            return -1L;
        }
        if (this.cpuT0 > 0L) {
            return this.currentCPU + this.bean.getCurrentThreadCpuTime() - this.cpuT0;
        }
        return this.currentCPU;
    }

    public long getCreationTime() {
        return this.createT0;
    }

    public long getTotalRealTime() {
        return this.totalReal + this.getCurrentRealTime();
    }

    public long getCurrentRealTime() {
        if (this.realT0 > 0L) {
            return this.currentReal + System.currentTimeMillis() - this.realT0;
        }
        return this.currentReal;
    }

    public void start() {
        if (this.realT0 > 0L) {
            return;
        }
        if (this.threadCpuTimeEnabled) {
            this.cpuT0 = this.bean.getCurrentThreadCpuTime();
        }
        this.realT0 = System.currentTimeMillis();
        ++this.nStartStop;
    }

    public void stop() {
        if (this.realT0 <= 0L) {
            return;
        }
        if (this.threadCpuTimeEnabled) {
            this.toatalCPU = this.getTotalCPUTime();
        }
        this.totalReal = this.getTotalRealTime();
        this.cpuT0 = -1L;
        this.realT0 = -1L;
    }

    public void pause() {
        if (this.realT0 <= 0L) {
            return;
        }
        this.stop();
        --this.nStartStop;
    }

    public long getNumStarts() {
        return this.nStartStop;
    }

    public long getAverageRealTime() {
        return this.nStartStop == 0 ? 0L : this.getTotalRealTime() / (long)this.nStartStop;
    }

    public long getAverageCPUTime() {
        return this.nStartStop == 0 ? 0L : this.getTotalCPUTime() / (long)this.nStartStop;
    }

    public String toString() {
        Object label = "CPUTimer: ";
        if (this.name != null) {
            label = (String)label + this.getName();
        }
        return (String)label + " totalCPU=" + (double)this.getTotalCPUTime() / 1.0E9 + " currentCPU=" + (double)this.getCurrentCPUTime() / 1.0E9 + " totalT=" + (double)this.getTotalRealTime() / 1000.0 + " currentT=" + (double)this.getCurrentRealTime() / 1000.0 + " starts=" + this.nStartStop + " active=" + (this.realT0 > 0L);
    }

    public String getSingleSummary() {
        Object label = "CPUTimer: ";
        if (this.name != null) {
            label = (String)label + this.getName();
        }
        return (String)label + " CPU=" + (double)this.getTotalCPUTime() / 1.0E9 + " RealTime=" + (double)this.getTotalRealTime() / 1000.0;
    }

    public KElement toXML() {
        KElement root = new XMLDoc("CPUTimer", null).getRoot();
        root.setAttribute("Name", this.getName(), null);
        root.setAttribute("TotalRealTime", (double)this.getTotalRealTime() / 1000.0, null);
        root.setAttribute("CurrentRealTime", (double)this.getCurrentRealTime() / 1000.0, null);
        root.setAttribute("AverageRealTime", (double)this.getAverageRealTime() / 1000.0, null);
        root.setAttribute("TotalCPUTime", (double)this.getTotalCPUTime() / 1.0E9, null);
        root.setAttribute("CurrentCPUTime", (double)this.getCurrentCPUTime() / 1.0E9, null);
        root.setAttribute("AverageCPUTime", (double)this.getAverageCPUTime() / 1.0E9, null);
        root.setAttribute("CreationTime", new JDFDate(this.getCreationTime()).getFormattedDateTime("dd MMM, HH:mm:ss.sss"), null);
        root.setAttribute("StartStop", this.getNumStarts(), (String)null);
        return root;
    }

    public static CPUTimerFactory getFactory() {
        if (CPUTimerFactory.theFactory == null) {
            CPUTimerFactory.theFactory = new CPUTimerFactory();
        }
        return CPUTimerFactory.theFactory;
    }

    public void println() {
        System.out.println(this.toString());
    }

    public static class CPUTimerFactory {
        private final Map<ThreadIdentifier, CPUTimer> globalMap = new HashMap<ThreadIdentifier, CPUTimer>();
        protected static CPUTimerFactory theFactory = null;

        public CPUTimer getCurrentTimer(String id) {
            return this.globalMap.get(new ThreadIdentifier(id));
        }

        public CPUTimer getGlobalTimer(String id) {
            CPUTimer timer = new CPUTimer(false);
            timer.setName(id);
            Vector<CPUTimer> v = this.getTimers(id);
            for (CPUTimer ti : v) {
                timer.add(ti);
            }
            return timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Vector<CPUTimer> getTimers(String id) {
            Vector<CPUTimer> v = new Vector<CPUTimer>();
            Map<ThreadIdentifier, CPUTimer> map = this.globalMap;
            synchronized (map) {
                Set<ThreadIdentifier> s = this.globalMap.keySet();
                for (ThreadIdentifier ti : s) {
                    if (id != null && !id.equals(ti.id)) continue;
                    v.add(this.globalMap.get(ti));
                }
            }
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CPUTimer getCreateCurrentTimer(String id) {
            Map<ThreadIdentifier, CPUTimer> map = this.globalMap;
            synchronized (map) {
                CPUTimer ct = this.globalMap.get(new ThreadIdentifier(id));
                if (ct == null) {
                    ct = new CPUTimer(false);
                    ct.setName(id);
                    this.globalMap.put(new ThreadIdentifier(id), ct);
                }
                return ct;
            }
        }

        public String toString() {
            return "CPUTimerFactory;\n" + String.valueOf(this.globalMap);
        }

        protected class ThreadIdentifier {
            protected Thread theThread;
            protected String id;

            public ThreadIdentifier(String id) {
                this.id = id;
                this.theThread = Thread.currentThread();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof ThreadIdentifier)) {
                    return false;
                }
                ThreadIdentifier ti = (ThreadIdentifier)obj;
                return ContainerUtil.equals(this.id, ti.id) && ContainerUtil.equals(this.theThread, ti.theThread);
            }

            public int hashCode() {
                return HashUtil.hashCode(HashUtil.hashCode(0, this.id), this.theThread);
            }

            public String toString() {
                return "ThreadIdentified Thread=" + this.theThread.getName() + "_" + this.theThread.getId() + " ID: " + this.id;
            }
        }
    }
}

