/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.ifaces.IStreamWriter;
import org.cip4.jdflib.util.ByteArrayIOFileStream;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StreamUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.net.HTTPDetails;
import org.cip4.jdflib.util.net.ProxyUtil;

public class URLWriter
implements Runnable {
    private static final Log log = LogFactory.getLog(URLWriter.class);
    private final URL url;
    private final ByteArrayIOStream stream;
    private final String method;
    private final String contentType;
    private final HTTPDetails details;
    private final IStreamWriter writer;
    private static int nLogged = 0;
    private boolean addDirect;
    private Throwable lastException;

    public String toString() {
        return "UrlWriter: " + this.method + " addDirect=" + this.addDirect + " / " + this.contentType + " --> " + String.valueOf(this.url);
    }

    public boolean isAddDirect() {
        return this.addDirect;
    }

    public void setAddDirect(boolean addDirect) {
        this.addDirect = addDirect;
    }

    public URLWriter(URL url, IStreamWriter streamWriter, String method, String contentType, HTTPDetails details) {
        this.addDirect = true;
        this.url = url;
        this.method = method;
        if (contentType == null) {
            contentType = "text/unknown";
        }
        this.contentType = StringUtil.token(contentType, 0, "\r\n");
        this.details = details;
        this.stream = this.getStream(streamWriter);
        this.writer = this.stream != null ? null : streamWriter;
        this.lastException = null;
    }

    public URLWriter(String strUrl, IStreamWriter streamWriter, String method, String contentType, HTTPDetails details) {
        this(UrlUtil.stringToURL(strUrl), streamWriter, method, contentType, details);
    }

    public URLWriter(InputStream is, String strUrl, String method, String contentType, HTTPDetails details) {
        this(is, UrlUtil.stringToURL(strUrl), method, contentType, details);
    }

    public URLWriter(InputStream is, URL url, String method, String contentType, HTTPDetails details) {
        this.url = url;
        this.method = method;
        if (contentType == null) {
            contentType = "text/unknown";
        }
        this.contentType = StringUtil.token(contentType, 0, "\r\n");
        this.details = details;
        this.stream = is == null ? null : new ByteArrayIOFileStream(is, 12345678L);
        this.writer = null;
        this.addDirect = true;
        this.lastException = null;
    }

    private ByteArrayIOStream getStream(IStreamWriter inWriter) {
        if (inWriter == null || UrlUtil.isFile(UrlUtil.urlToString(this.url))) {
            return null;
        }
        ByteArrayIOFileStream bufStream = new ByteArrayIOFileStream(12345678L);
        try {
            inWriter.writeStream(bufStream);
        }
        catch (IOException e) {
            return null;
        }
        return bufStream;
    }

    public UrlPart writeToURL() {
        UrlPart urlPart = null;
        UrlPart fallBack = null;
        if (UrlUtil.isFile(UrlUtil.urlToString(this.url))) {
            urlPart = this.writeFile();
        } else {
            URI uri = ProxyUtil.getHostURI(this.url);
            if (uri == null) {
                return null;
            }
            List<Proxy> list = this.getProxies(uri);
            for (Proxy proxy : list) {
                boolean bWantLog;
                urlPart = this.callProxy(proxy, bWantLog = list.size() == 1 || !proxy.equals(Proxy.NO_PROXY));
                if (urlPart == null) continue;
                int responseCode = urlPart.getResponseCode();
                if (UrlUtil.isReturnCodeOK(responseCode)) {
                    return urlPart;
                }
                if (UrlUtil.isRedirect(responseCode) && (this.details == null || this.details.getRedirect() < 42)) {
                    String newLocation = urlPart.getConnection().getHeaderField("Location");
                    if (StringUtil.isEmpty(newLocation) && UrlUtil.isHttp(UrlUtil.urlToString(this.url))) {
                        newLocation = StringUtil.replaceToken(newLocation, 0, ":", "https");
                    }
                    if (newLocation == null) continue;
                    fallBack = urlPart;
                    ByteArrayIOStream.ByteArrayIOInputStream newInput = this.stream == null ? null : this.stream.getInputStream();
                    urlPart = new URLWriter((InputStream)newInput, newLocation, this.method, this.contentType, HTTPDetails.getRedirect(this.details)).writeToURL();
                    if (urlPart == null) {
                        urlPart = fallBack;
                        continue;
                    }
                    if (!UrlUtil.isReturnCodeOK(urlPart.getResponseCode())) continue;
                    return urlPart;
                }
                fallBack = urlPart;
            }
        }
        return urlPart == null ? fallBack : urlPart;
    }

    protected List<Proxy> getProxies(URI uri) {
        if (this.addDirect) {
            return ProxyUtil.getProxiesWithLocal(uri);
        }
        List<Proxy> select = ProxySelector.getDefault().select(uri);
        return select.isEmpty() ? ProxyUtil.getProxiesWithLocal(uri) : select;
    }

    private UrlPart writeFile() {
        File f = UrlUtil.urlToFile(UrlUtil.urlToString(this.url));
        if (this.writer != null) {
            f = FileUtil.writeFile(this.writer, f);
        } else if (this.stream != null) {
            FileUtil.streamToFile((InputStream)this.stream.getInputStream(), f);
        }
        try {
            return new UrlPart(f);
        }
        catch (IOException x) {
            return null;
        }
    }

    protected UrlPart callProxy(Proxy proxy, boolean bWantLog) {
        try {
            return this.callProxy(proxy);
        }
        catch (Throwable x) {
            if (bWantLog && (nLogged++ < 10 || nLogged % 100 == 0)) {
                log.warn((Object)(x.getClass().getCanonicalName() + " snafu #" + nLogged + " writing to url: " + String.valueOf(this.url) + " " + x.getMessage()));
            }
            this.lastException = x;
            return null;
        }
    }

    protected UrlPart callProxy(Proxy proxy) throws IOException, ProtocolException {
        URLConnection urlConnection = this.url.openConnection(proxy);
        urlConnection.setConnectTimeout(UrlUtil.getConnectionTimeout());
        urlConnection.setRequestProperty("Connection", "keep-alive");
        urlConnection.setRequestProperty("Content-Type", this.contentType);
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpUrlConnection = this.setHttpMethod(urlConnection);
            if (this.details != null) {
                this.details.applyTo(httpUrlConnection);
            }
            this.output(httpUrlConnection);
            return new UrlPart(httpUrlConnection);
        }
        if (UrlUtil.isFtp(UrlUtil.urlToString(this.url))) {
            return new UrlPart(urlConnection, false);
        }
        return null;
    }

    HttpURLConnection setHttpMethod(URLConnection urlConnection) throws ProtocolException {
        HttpURLConnection httpUrlConnection = (HttpURLConnection)urlConnection;
        try {
            httpUrlConnection.setRequestMethod(this.method);
        }
        catch (ProtocolException ex) {
            if (UrlUtil.PATCH.equalsIgnoreCase(this.method)) {
                httpUrlConnection.setRequestMethod(UrlUtil.POST);
                httpUrlConnection.setRequestProperty("X-HTTP-Method-Override", UrlUtil.PATCH);
            }
            throw ex;
        }
        return httpUrlConnection;
    }

    private void output(HttpURLConnection httpURLconnection) throws IOException {
        boolean doOutput = this.writer != null || this.stream != null;
        httpURLconnection.setDoOutput(doOutput);
        if (doOutput) {
            OutputStream out = StreamUtil.getBufferedOutputStream(httpURLconnection.getOutputStream());
            if (this.writer != null) {
                this.writer.writeStream(out);
            } else {
                IOUtils.copy((InputStream)this.stream.getInputStream(), (OutputStream)out);
            }
            out.flush();
            out.close();
        }
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    @Override
    public void run() {
        this.writeToURL();
    }
}

