/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.file;

import java.io.File;
import org.cip4.jdflib.util.JDFDate;

public class FileTime
implements Comparable<FileTime> {
    private final File file;
    private long lastMod;

    public FileTime(File f) {
        this.file = f;
        this.lastMod = this.file.lastModified();
    }

    @Override
    public int compareTo(FileTime o) {
        long l = this.lastMod - o.lastMod;
        if (l > 0L) {
            l = -1L;
        } else if (l < 0L) {
            l = 1L;
        }
        return (int)l;
    }

    public String toString() {
        return new JDFDate(this.lastMod).getDateTimeReadable() + " : " + this.file.getPath();
    }

    public File getFile() {
        return this.file;
    }

    public long getLastMod() {
        return this.lastMod;
    }

    void setLastMod(long lastMod) {
        this.lastMod = lastMod;
    }
}

