/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.mime;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.ifaces.IStreamWriter;
import org.cip4.jdflib.ifaces.IURLSetter;
import org.cip4.jdflib.jmf.JDFCommand;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFResponse;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.JavaEnumUtil;
import org.cip4.jdflib.util.MimeUtil;
import org.cip4.jdflib.util.StreamUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.mime.BodyPartHelper;
import org.cip4.jdflib.util.mime.MimeHelper;
import org.cip4.jdflib.util.mime.MimeReader;

public class MimeWriter
extends MimeHelper
implements IStreamWriter {
    private static final String THE_JDF = "TheJDF.jdf";
    protected static final Log log = LogFactory.getLog(MimeReader.class);
    private MimeUtil.MIMEDetails md;
    private final eMimeSubType subType;

    public void setMIMEDetails(MimeUtil.MIMEDetails _md) {
        this.md = _md;
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        ByteArrayIOStream bis = new ByteArrayIOStream();
        this.writeToStream(bis);
        return bis.getInputStream();
    }

    public MimeWriter() {
        this(eMimeSubType.related);
    }

    public MimeWriter(eMimeSubType subtype) {
        this.subType = subtype;
        this.md = new MimeUtil.MIMEDetails();
        this.createMimePackage();
    }

    public MimeWriter(Multipart mp) {
        this.md = new MimeUtil.MIMEDetails();
        this.theMultipart = mp;
        this.subType = eMimeSubType.getEnum(mp.getContentType());
    }

    public void createMimePackage() {
        MimeMultipart multipart = new MimeMultipart(this.subType.getSubtype());
        MimeMessage message = new MimeMessage((Session)null);
        try {
            message.setContent((Multipart)multipart);
        }
        catch (MessagingException x) {
            log.error((Object)"cannot create mime package", (Throwable)x);
            return;
        }
        this.theMultipart = multipart;
    }

    public BodyPartHelper updateMultipart(InputStream is, String cid, String contentType) {
        if (is == null || StringUtil.getNonEmpty(cid) == null) {
            return null;
        }
        BodyPart bp = this.getCreatePartByCID(cid);
        if (bp == null) {
            return null;
        }
        try {
            ByteArrayIOStream.ByteArrayIOInputStream inputStream = ByteArrayIOStream.getBufferedInputStream(is);
            ByteArrayDataSource ds = new ByteArrayDataSource((InputStream)inputStream, contentType);
            bp.setDataHandler(new DataHandler((DataSource)ds));
        }
        catch (MessagingException e) {
            log.error((Object)"cannot update mime package", (Throwable)e);
        }
        catch (IOException x) {
            log.error((Object)"cannot update mime package", (Throwable)x);
        }
        return new BodyPartHelper(bp);
    }

    public BodyPart updateXMLMultipart(XMLDoc xmlDoc, String cid) {
        if (xmlDoc == null) {
            return null;
        }
        String originalFileName = xmlDoc.getOriginalFileName();
        if (StringUtil.isEmpty((String)cid)) {
            cid = UrlUtil.extension(originalFileName) + KElement.uniqueID(0, false);
        }
        BodyPart messageBodyPart = this.getCreatePartByCID((String)cid);
        BodyPartHelper bph = new BodyPartHelper(messageBodyPart);
        try {
            bph.setFileName(originalFileName);
            bph.setContent(xmlDoc);
            bph.setContentID((String)cid);
        }
        catch (Exception x) {
            log.error((Object)"cannot update mime package", (Throwable)x);
        }
        return messageBodyPart;
    }

    public File writeToFile(String fileName) {
        return FileUtil.writeFile(this, new File(fileName));
    }

    public void writeToDir(File directory) throws MessagingException, IOException {
        boolean exists = directory.exists();
        if (!exists) {
            exists = directory.mkdirs();
        }
        if (!exists) {
            log.error((Object)("cannot create directory: " + String.valueOf(directory)));
            throw new FileNotFoundException("cannot create directory: " + String.valueOf(directory));
        }
        if (!directory.canWrite()) {
            log.error((Object)("cannot write to directory: " + String.valueOf(directory)));
            throw new IOException("cannot write to directory: " + String.valueOf(directory));
        }
        int parts = this.getCount();
        for (int i = 0; i < parts; ++i) {
            BodyPartHelper bph = this.getBodyPartHelper(i);
            bph.writeToDir(directory);
        }
    }

    public void writeToStream(OutputStream outStream) throws IOException, MessagingException {
        BodyPart[] bp;
        if (this.theMultipart == null) {
            throw new MessagingException("Multipart must be non null");
        }
        MyMimeMessage mm = new MyMimeMessage(null);
        mm.setContent(this.theMultipart);
        if (!(outStream instanceof BufferedOutputStream) && !(outStream instanceof ByteArrayIOStream)) {
            outStream = new BufferedOutputStream(outStream);
        }
        if (this.md != null && this.md.modifyBoundarySemicolon) {
            outStream = new FixSemiColonStream(outStream);
        }
        if (this.md != null && this.md.transferEncoding != null && (bp = this.getBodyParts()) != null) {
            int siz = bp.length;
            for (int i = 0; i < siz; ++i) {
                bp[i].setHeader("Content-Transfer-Encoding", this.md.transferEncoding);
            }
        }
        mm.writeTo(outStream);
        StreamUtil.close(outStream);
    }

    public UrlPart writeToURL(String strUrl) throws IOException, MessagingException {
        return UrlUtil.writerToURL(strUrl, this, UrlUtil.POST, this.theMultipart.getContentType(), this.md == null ? null : this.md.httpDetails);
    }

    public void buildMimePackage(Vector<? extends XMLDoc> vXMLDocs) {
        int imax = vXMLDocs.size();
        for (int i = 0; i < imax; ++i) {
            XMLDoc d1 = vXMLDocs.elementAt(i);
            this.updateXMLMultipart(d1, null);
        }
    }

    public void buildMimePackage(JDFDoc docJMF, XMLDoc docJDF, boolean extendReferenced) {
        String cid = MimeUtil.urlToCid(THE_JDF);
        if (docJMF != null) {
            KElement e;
            VElement v;
            String originalFileName = docJMF.getOriginalFileName();
            if (KElement.isWildCard(originalFileName)) {
                JDFJMF jmf = docJMF.getJMFRoot();
                JDFMessage m = jmf == null ? null : jmf.getMessageElement(null, null, 0);
                originalFileName = m == null ? "TheJMF.jmf" : m.getType() + ".jmf";
                docJMF.setOriginalFileName(originalFileName);
            }
            if ((v = (e = docJMF.getRoot()).getChildrenByTagName(null, null, new JDFAttributeMap("URL", "*"), false, false, 0)) != null) {
                int siz = v.size();
                for (int i = 0; i < siz; ++i) {
                    v.item(i).setAttribute("URL", cid);
                }
            }
        }
        this.updateXMLMultipart(docJMF, null);
        if (docJDF != null && StringUtil.isEmpty(docJDF.getOriginalFileName())) {
            docJDF.setOriginalFileName(THE_JDF);
        }
        if (extendReferenced) {
            this.extendMultipart(docJDF, cid);
        } else {
            this.updateXMLMultipart(docJDF, cid);
        }
    }

    int extendMultipart(XMLDoc docJDF, String cid) {
        int n = 0;
        if (docJDF == null) {
            log.error((Object)"cannot extend null JDF document");
            return 0;
        }
        KElement e = docJDF.getRoot();
        VElement fileSpecs = e.getChildrenByTagName(null, null, new JDFAttributeMap("URL", "*"), false, false, 0);
        HashMap<File, CallSite> done = new HashMap<File, CallSite>();
        ArrayList<BodyPartHelper> bodyparts = new ArrayList<BodyPartHelper>();
        if (fileSpecs != null) {
            for (KElement fs : fileSpecs) {
                String id2;
                IURLSetter ius;
                String url;
                File f;
                if (!(fs instanceof IURLSetter) || (f = UrlUtil.urlToFile(url = (ius = (IURLSetter)((Object)fs)).getURL())) == null) continue;
                if (!f.isAbsolute() && docJDF.getOriginalFileName() != null) {
                    File jdfFile = new File(docJDF.getOriginalFileName());
                    f = new File(jdfFile.getParent(), f.getPath());
                    url = UrlUtil.fileToUrl(f, false);
                }
                if ((id2 = (String)done.get(f)) == null) {
                    String id = UrlUtil.extension(url) + KElement.uniqueID(0, false);
                    BodyPartHelper bph = new BodyPartHelper();
                    BodyPart bp = bph.createFromURL(url);
                    ius.setURL(MimeUtil.urlToCid(id));
                    if (bp != null) {
                        bph.setContentID(id);
                        bodyparts.add(bph);
                        ++n;
                    }
                    done.put(f, (CallSite)((Object)id));
                    continue;
                }
                ius.setURL(MimeUtil.urlToCid(id2));
            }
        }
        this.updateXMLMultipart(docJDF, cid);
        for (BodyPartHelper bph : bodyparts) {
            this.addBodyPart(bph);
        }
        return n;
    }

    public void addBodyPart(BodyPartHelper bph) {
        try {
            this.theMultipart.addBodyPart(bph.getBodyPart());
        }
        catch (MessagingException e) {
            log.error((Object)"cannot add bodypart", (Throwable)e);
        }
    }

    @Deprecated
    public JDFDoc writeToQueue(JDFDoc docJMF, JDFDoc docJDF, String strUrl) throws IOException, MessagingException {
        return this.writeToQueue(docJMF, docJDF, strUrl, false);
    }

    public JDFDoc writeToQueue(JDFDoc docJMF, JDFDoc docJDF, String strUrl, boolean extendRef) throws IOException, MessagingException {
        JDFDoc doc = null;
        this.buildMimePackage(docJMF, docJDF, extendRef);
        UrlPart uc = this.writeToURL(strUrl);
        if (uc == null) {
            return doc;
        }
        int rc = uc.getResponseCode();
        InputStream inputStream = uc.getResponseStream();
        if (UrlUtil.isReturnCodeOK(rc)) {
            ByteArrayIOStream.ByteArrayIOInputStream bis = ByteArrayIOStream.getBufferedInputStream(inputStream);
            MimeReader mr = new MimeReader(bis);
            BodyPartHelper bph = mr.getBodyPartHelper(0);
            JDFDoc jDFDoc = doc = bph == null ? null : bph.getJDFDoc();
            if (doc == null) {
                bis.reset();
                doc = JDFDoc.parseStream(bis);
                if (doc == null) {
                    JDFCommand c = docJMF.getJMFRoot().getCommand(0);
                    JDFJMF respJMF = c.createResponse();
                    JDFResponse r = respJMF.getResponse(0);
                    r.setErrorText("Invalid attached JDF", null);
                    r.setReturnCode(3);
                    doc = respJMF.getOwnerDocument_JDFElement();
                }
            }
        } else {
            JDFCommand c = docJMF.getJMFRoot().getCommand(0);
            JDFJMF respJMF = c.createResponse();
            JDFResponse r = respJMF.getResponse(0);
            r.setErrorText("Invalid http response - RC=" + rc, null);
            r.setReturnCode(3);
            doc = respJMF.getOwnerDocument_JDFElement();
        }
        inputStream.close();
        return doc;
    }

    @Override
    public void writeStream(OutputStream os) throws IOException {
        try {
            this.writeToStream(os);
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static enum eMimeSubType {
        related,
        formdata;

        private static final String MULTIPART = "multipart/";

        public String getSubtype() {
            return formdata.equals((Object)this) ? "form-data" : this.name();
        }

        public String getMimetype() {
            return MULTIPART + this.getSubtype();
        }

        public static eMimeSubType getEnum(String name) {
            if (name != null) {
                eMimeSubType ret = EnumUtil.getJavaEnumIgnoreCase(eMimeSubType.class, name);
                if (ret == null && name.toLowerCase().startsWith(MULTIPART)) {
                    return JavaEnumUtil.getEnumIgnoreCase(eMimeSubType.class, name, null);
                }
                return ret;
            }
            return null;
        }
    }

    private static class MyMimeMessage
    extends MimeMessage {
        MyMimeMessage(Session session) {
            super(session);
        }

        protected void updateMessageID() throws MessagingException {
            this.removeHeader("Message-ID");
        }
    }

    static class FixSemiColonStream
    extends BufferedOutputStream {
        private int pos = 0;
        private byte[] smallBuf = new byte[4000];

        public FixSemiColonStream(OutputStream _out) {
            super(_out);
        }

        @Override
        public synchronized void write(int b) throws IOException {
            if (this.smallBuf != null) {
                if (this.pos == this.smallBuf.length) {
                    this.smallBuf = null;
                } else {
                    String s;
                    this.smallBuf[this.pos++] = (byte)b;
                    int first = Math.max(0, this.pos - 50);
                    if (b == 59 && (s = new String(this.smallBuf, first, this.pos - 1)).toLowerCase().indexOf("content-type:") > 0) {
                        super.write(10);
                        super.write(b);
                        this.smallBuf = null;
                        return;
                    }
                }
            }
            super.write(b);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            if (this.smallBuf == null) {
                super.write(b, off, len);
            } else {
                for (int i = off; i < len; ++i) {
                    this.write(b[i]);
                }
            }
        }
    }
}

