/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.thread;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.thread.MyMutex;
import org.cip4.jdflib.util.thread.OrderedTaskQueue;
import org.cip4.jdflib.util.thread.Sweeper;
import org.cip4.jdflib.util.thread.TimeSweeper;

public final class RegularJanitor {
    private MyMutex theMutex;
    private final Log log = LogFactory.getLog(this.getClass());
    private int nThread = 0;
    private static RegularJanitor theJanitor = null;
    private final Vector<Sweeper> vSweepers = new Vector();
    private int interval = 15;

    public void setInterval(int interval) {
        if (interval < 1) {
            this.log.error((Object)"cannot set interval <1; setting to 1 second");
            interval = 1;
        }
        this.interval = interval;
    }

    public String toString() {
        return "RegularJanitor: interval=" + this.interval + " size=" + this.numSweepers();
    }

    public int numSweepers() {
        return this.vSweepers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSweeper(Sweeper sweeper, boolean singleClass) {
        if (sweeper == null) {
            this.log.error((Object)"cannot add null sweeper");
            return;
        }
        Vector<Sweeper> vector = this.vSweepers;
        synchronized (vector) {
            if (singleClass) {
                this.checkDuplicates(sweeper);
            }
            this.vSweepers.add(sweeper);
            this.log.info((Object)("adding sweeper " + String.valueOf(sweeper)));
        }
    }

    public boolean hasSweeper(Object sweeper) {
        return this.getOldDuplicate(sweeper) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sweeper getOldDuplicate(Object sweeper) {
        Vector<Sweeper> v = new Vector<Sweeper>();
        Vector<Sweeper> vector = this.vSweepers;
        synchronized (vector) {
            v.addAll(this.vSweepers);
        }
        Class<? extends Object> newClass = this.getRunnerClass(sweeper);
        if (newClass == null) {
            return null;
        }
        for (Sweeper oldSweeper : v) {
            Class<? extends Object> oldClass = this.getRunnerClass(oldSweeper);
            if (oldClass == null || !oldClass.equals(newClass)) continue;
            return oldSweeper;
        }
        return null;
    }

    private void checkDuplicates(Sweeper sweeper) {
        Sweeper oldSweeper = this.getOldDuplicate(sweeper);
        if (oldSweeper != null) {
            this.log.info((Object)"removing duplicate tmp sweeper");
            this.vSweepers.remove(oldSweeper);
        }
    }

    private Class<? extends Object> getRunnerClass(Object sweeper) {
        if (sweeper instanceof Sweeper) {
            Sweeper oldSweeper = (Sweeper)sweeper;
            return oldSweeper instanceof TimeSweeper ? ((TimeSweeper)oldSweeper).getRunnerClass() : oldSweeper.getClass();
        }
        if (sweeper instanceof Runnable) {
            return sweeper.getClass();
        }
        return null;
    }

    public synchronized void startSweep(int firstInterval) {
        if (this.theMutex != null) {
            this.log.warn((Object)"Janitor already running - do nothing ");
            if (theJanitor != null) {
                return;
            }
        } else {
            this.log.info((Object)("starting sweeeper in seconds: " + firstInterval));
        }
        JanitorThread janitorThread = new JanitorThread();
        janitorThread.setFirstInterval(firstInterval);
        janitorThread.start();
    }

    public static void feierabend() {
        if (theJanitor != null) {
            RegularJanitor tmp = theJanitor;
            theJanitor = null;
            tmp.shutdown();
        }
    }

    private void shutdown() {
        if (this.theMutex == null) {
            this.log.warn((Object)"cannot shutdown sleeping janitor that has already been shut down");
        }
        MyMutex m = this.theMutex;
        this.theMutex = null;
        ThreadUtil.notifyAll(m);
        this.log.info((Object)"shutting down the janitor");
    }

    public static RegularJanitor getJanitor() {
        if (theJanitor == null) {
            theJanitor = new RegularJanitor();
        }
        return theJanitor;
    }

    protected RegularJanitor() {
        this.log.info((Object)"creating new janitor");
    }

    class JanitorThread
    extends Thread {
        private int firstInterval;

        JanitorThread() {
            super("Janitor_" + RegularJanitor.this.nThread++);
            this.firstInterval = RegularJanitor.this.interval;
            RegularJanitor.this.theMutex = new MyMutex();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RegularJanitor.this.log.info((Object)"Janitor starting");
            if (this.firstInterval > 0) {
                RegularJanitor.this.log.info((Object)("Janitor starting - initial pause: " + this.firstInterval + " seconds"));
                ThreadUtil.wait(RegularJanitor.this.theMutex, 1000 * this.firstInterval);
            }
            if (RegularJanitor.this.theMutex != null) {
                RegularJanitor.this.log.info((Object)("Janitor starting - interval: " + RegularJanitor.this.interval + " seconds"));
            }
            while (RegularJanitor.this.theMutex != null) {
                Vector<Sweeper> v = new Vector<Sweeper>();
                Vector<Sweeper> vector = RegularJanitor.this.vSweepers;
                synchronized (vector) {
                    v.addAll(RegularJanitor.this.vSweepers);
                }
                for (Sweeper sweeper : v) {
                    this.sweep(sweeper);
                    if (RegularJanitor.this.theMutex != null) continue;
                    break;
                }
                if (ThreadUtil.wait(RegularJanitor.this.theMutex, 1000 * RegularJanitor.this.interval)) continue;
                break;
            }
            RegularJanitor.this.log.info((Object)"Janitor over and out");
        }

        private void sweep(Sweeper sweeper) {
            try {
                Class<? extends Object> runnerClass;
                if (sweeper.needSweep() && (runnerClass = RegularJanitor.this.getRunnerClass(sweeper)) != null) {
                    OrderedTaskQueue tq = OrderedTaskQueue.getCreateQueue(runnerClass.getSimpleName());
                    tq.queue(new SweepRunner(sweeper));
                }
            }
            catch (Throwable x) {
                RegularJanitor.this.log.error((Object)"problems sweeping", x);
            }
        }

        void setFirstInterval(int firstInterval) {
            if (firstInterval < 0) {
                firstInterval = RegularJanitor.this.interval;
            }
            this.firstInterval = firstInterval;
        }
    }

    class SweepRunner
    implements Runnable {
        private final Sweeper sweeper;

        SweepRunner(Sweeper sweeper) {
            this.sweeper = sweeper;
        }

        @Override
        public void run() {
            if (this.sweeper != null) {
                this.sweeper.sweep();
            }
        }

        public String toString() {
            return "SweepRunner [sweeper=" + String.valueOf(this.sweeper) + "]";
        }
    }
}

