/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker.fixversion;

import org.cip4.jdflib.auto.JDFAutoMedia;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.elementwalker.fixversion.WalkResource;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.util.EnumUtil;

public class WalkMedia
extends WalkResource {
    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFMedia;
    }

    @Override
    public VString getElementNames() {
        return VString.getVString("Media", null);
    }

    @Override
    boolean updateAttributes(JDFAttributeMap m) {
        boolean ret = false;
        if (EnumUtil.aLessEqualsThanB(JDFElement.EnumVersion.Version_1_6, this.fixVersion.version)) {
            m.renameKey("UserMediaType", "MediaTypeDetails");
            ret = true;
        }
        return super.updateAttributes(m) || ret;
    }

    void updateGrade(JDFMedia m) {
        JDFAutoMedia.EnumISOPaperSubstrate ips;
        int grade;
        if (m.getISOPaperSubstrate() == null) {
            grade = m.getGrade();
            ips = JDFMedia.getIsoPaperFromGrade(grade, m.getCoating());
            m.setISOPaperSubstrate(ips);
        }
        if (m.getBackISOPaperSubstrate() == null && (ips = JDFMedia.getIsoPaperFromGrade(grade = m.getBackGrade(), m.getBackCoating())) != null) {
            m.setBackISOPaperSubstrate(JDFAutoMedia.EnumBackISOPaperSubstrate.getEnum(ips.getName()));
        }
    }

    @Override
    public KElement walk(KElement e1, KElement trackElem) {
        this.updateGrade((JDFMedia)e1);
        return super.walk(e1, trackElem);
    }
}

