/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.extensions.xjdfwalker.XJDFToJDFConverter;
import org.cip4.jdflib.ifaces.IStreamWriter;
import org.cip4.jdflib.ifaces.IURLSetter;
import org.cip4.jdflib.jmf.JDFCommand;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.zip.ZipReader;

public class XJDFZipReader
implements IStreamWriter {
    private String path;
    private XJDFToJDFConverter converter;
    final ZipReader theReader;
    private JDFDoc newDoc;
    private JDFDoc newJMF;

    public XJDFZipReader(InputStream inStream) {
        this(ZipReader.getZipReader(inStream));
    }

    public XJDFZipReader(ZipReader zipReader) {
        this.theReader = zipReader;
        if (this.theReader != null) {
            this.theReader.setCaseSensitive(false);
        }
        this.newDoc = null;
        this.newJMF = null;
        this.path = null;
        this.converter = null;
    }

    public void setPath(String path) {
        this.path = UrlUtil.cleanDots(path);
    }

    public XJDFZipReader(File inFile) {
        this(FileUtil.getBufferedInputStream(inFile));
    }

    @Override
    public void writeStream(OutputStream os) throws IOException {
        if (this.newDoc == null) {
            this.convert();
        }
        if (this.newDoc != null) {
            this.newDoc.write2Stream(os, 2, false);
        }
    }

    public void convert() {
        this.convertXJMF();
        this.convertXJDF();
    }

    public XMLDoc getXJDF(int i) {
        if (this.theReader != null) {
            String pathExpression = UrlUtil.getURLWithDirectory(this.path, "*.xjdf");
            Vector<ZipEntry> vze = this.theReader.getMatchingEntries(pathExpression, true);
            if (i < 0) {
                i = vze.size() + i;
            }
            if (i >= 0 && i < vze.size()) {
                ZipEntry ze = vze.get(i);
                this.theReader.setEntry(ze);
                return this.theReader.getXMLDoc();
            }
        }
        return null;
    }

    public Vector<XMLDoc> getXJDFs() {
        Vector<XMLDoc> vRet = new Vector<XMLDoc>();
        if (this.theReader != null) {
            String pathExpression = UrlUtil.getURLWithDirectory(this.path, "*.xjdf");
            Vector<ZipEntry> vze = this.theReader.getMatchingEntries(pathExpression, true);
            for (ZipEntry ze : vze) {
                this.theReader.setEntry(ze);
                XMLDoc xmlDoc = this.theReader.getXMLDoc();
                if (xmlDoc == null) continue;
                vRet.add(xmlDoc);
            }
        }
        return vRet.isEmpty() ? null : vRet;
    }

    public void convertXJDF() {
        Vector<XMLDoc> vXJDF;
        this.newDoc = null;
        if (this.theReader != null && (vXJDF = this.getXJDFs()) != null) {
            XJDFToJDFConverter localConverter = this.getConverter();
            for (XMLDoc xdoc : vXJDF) {
                if (xdoc == null) continue;
                this.newDoc = localConverter.convert(xdoc.getRoot());
            }
        }
    }

    void convertXJMF() {
        XMLDoc xdoc;
        this.newJMF = null;
        if (this.theReader != null && (xdoc = this.getXJMF()) != null) {
            VString validParams;
            IURLSetter params;
            String url;
            JDFCommand command;
            XJDFToJDFConverter c = this.getConverter();
            this.newJMF = c.convert(xdoc.getRoot());
            JDFJMF jmf = this.newJMF == null ? null : this.newJMF.getJMFRoot();
            JDFCommand jDFCommand = command = jmf == null ? null : jmf.getCommand(0);
            if (command != null && UrlUtil.isRelativeURL(url = (params = (IURLSetter)((Object)command.getChildFromList(validParams = new VString(new String[]{"QueueSubmissionParams", "ResubmissionParams", "ReturnQueueEntryParams"}), 0, null, true))).getURL())) {
                this.setPath(url);
            }
        }
    }

    public XMLDoc getXJMF() {
        ZipEntry ze = this.theReader.getMatchingEntry("*.xjmf", 0);
        XMLDoc xdoc = ze == null ? null : this.theReader.getXMLDoc();
        return xdoc;
    }

    public String toString() {
        return "XJDFZipReader [path=" + this.path + ", newDoc=" + String.valueOf(this.newDoc) + "]";
    }

    public JDFNode getJDFRoot() {
        return this.newDoc == null ? null : this.newDoc.getJDFRoot();
    }

    public JDFJMF getJMFRoot() {
        return this.newJMF == null ? null : this.newJMF.getJMFRoot();
    }

    public XJDFToJDFConverter getConverter() {
        if (this.converter == null) {
            this.converter = new XJDFToJDFConverter(null);
        }
        this.converter.reset(null);
        return this.converter;
    }

    public void setConverter(XJDFToJDFConverter converter) {
        this.converter = converter;
    }

    protected void setNewJMF(JDFDoc newJMF) {
        this.newJMF = newJMF;
    }
}

