/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFMarkObject;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFContentObject;

public class JDFToXJDFDataCache {
    private static final JDFToXJDFDataCache theCache = new JDFToXJDFDataCache();
    private final StringArray stripMarkElements;
    private final StringArray elemAttribs;
    private final HashSet<String> inlineSet;
    private final StringArray resAttribs = new StringArray((Collection<String>)this.generateResourceAttributes());
    private final StringArray placedObjectAttribs;
    private final StringArray amountAttribs;

    public static JDFToXJDFDataCache getCache() {
        return theCache;
    }

    private JDFToXJDFDataCache() {
        this.elemAttribs = new StringArray((Collection<String>)this.generateElementAttributes());
        this.inlineSet = this.generateInlineSet();
        this.placedObjectAttribs = new StringArray((Collection<String>)this.generatePlacedObjectAttributes());
        this.stripMarkElements = new StringArray("BarcodeReproParams,FillMark,IdentificationField,JobField", ",");
        this.amountAttribs = new StringArray("Amount,ActualAmount,MinAmount,MaxAmount", ",");
    }

    private List<String> generatePlacedObjectAttributes() {
        JDFContentObject co = (JDFContentObject)new JDFDoc("ContentObject").getRoot();
        JDFMarkObject mo = (JDFMarkObject)new JDFDoc("MarkObject").getRoot();
        VString vco = co.knownAttributes();
        VString vmo = mo.knownAttributes();
        VString overlapping = vmo.getOverlapping(vco);
        overlapping.add("ID");
        return overlapping;
    }

    private List<String> generateElementAttributes() {
        JDFResourcePool dummyResPool = (JDFResourcePool)new JDFDoc("ResourcePool").getRoot();
        return dummyResPool.knownAttributes();
    }

    private HashSet<String> generateInlineSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("Address");
        set.add("BarcodeCompParams");
        set.add("BarcodeReproParams");
        set.add("ByteMap");
        set.add("CIELABMeasuringField");
        set.add("ComChannel");
        set.add("CostCenter");
        set.add("ColorantAlias");
        set.add("Company");
        set.add("Device");
        set.add("DeviceMark");
        set.add("DeviceNSpace");
        set.add("Employee");
        set.add("Fold");
        set.add("GlueLine");
        set.add("GlueApplication");
        set.add("RegisterMark");
        set.add("FitPolicy");
        set.add("CutBlock");
        set.add("ElementColorParams");
        set.add("Cut");
        set.add("PDLResourceAlias");
        set.add("HoleList");
        set.add("Hole");
        set.add("InterpretedPDLData");
        set.add("MISDetails");
        set.add("HoleLine");
        set.add("JobField");
        set.add("AutomatedOverPrintParams");
        set.add("ExternalImpositionTemplate");
        set.add("ProductionPath");
        set.add("Shape");
        set.add("ScavengerArea");
        set.add("TrapRegion");
        set.add("TransferCurve");
        set.add("ColorControlStrip");
        set.add("LayerList");
        set.add("PageCondition");
        set.add("ContentObject");
        set.add("MarkObject");
        set.add("LayerDetails");
        set.add("FileSpec");
        set.add("IdentificationField");
        set.add("LayoutElement");
        set.add("ObjectResolution");
        set.add("Person");
        return set;
    }

    private List<String> generateResourceAttributes() {
        StringArray ra = new StringArray();
        JDFResourcePool dummyResPool = (JDFResourcePool)new JDFDoc("ResourcePool").getRoot();
        JDFResource intRes = dummyResPool.appendResource("intent", JDFResource.EnumResourceClass.Intent, null);
        JDFResource physRes = dummyResPool.appendResource("physical", JDFResource.EnumResourceClass.Consumable, null);
        JDFResource paramRes = dummyResPool.appendResource("param", JDFResource.EnumResourceClass.Parameter, null);
        JDFPart part = (JDFPart)dummyResPool.appendElement("Part");
        ra.addAll(paramRes.knownAttributes());
        ra.appendUnique(physRes.knownAttributes());
        ra.appendUnique(intRes.knownAttributes());
        ra.appendUnique(part.knownAttributes());
        ra.appendUnique("ExternalID");
        return ra;
    }

    public static StringArray getElemAttribs() {
        return JDFToXJDFDataCache.getCache().elemAttribs;
    }

    public static HashSet<String> getInlineSet() {
        return JDFToXJDFDataCache.getCache().inlineSet;
    }

    public static StringArray getResAttribs() {
        return JDFToXJDFDataCache.getCache().resAttribs;
    }

    public static StringArray getPlacedObjectAttribs() {
        return JDFToXJDFDataCache.getCache().placedObjectAttribs;
    }

    public static StringArray getStripMarkElements() {
        return JDFToXJDFDataCache.getCache().stripMarkElements;
    }

    public static StringArray getAmountAttribs() {
        return JDFToXJDFDataCache.getCache().amountAttribs;
    }
}

