/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.node;

import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class LinkInfo {
    private final VString theInfo;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.theInfo == null ? 0 : this.theInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkInfo other = (LinkInfo)obj;
        return ContainerUtil.equals(other.theInfo, this.theInfo);
    }

    LinkInfo(LinkInfo info) {
        this.theInfo = new VString(info.getVString());
    }

    int size() {
        return this.theInfo == null ? 0 : this.theInfo.size();
    }

    LinkInfo(String info) {
        this.theInfo = new VString(info);
    }

    LinkInfo(VString info) {
        this.theInfo = new VString(info);
    }

    VString getVString() {
        return this.theInfo;
    }

    String getString() {
        return StringUtil.setvString(this.theInfo);
    }

    public String toString() {
        return "LinkInfo " + String.valueOf(this.theInfo);
    }

    void merge(LinkInfo value) {
        if (value != null) {
            for (int i = 0; i < value.size(); ++i) {
                boolean needAdd;
                boolean bl = needAdd = value.getProcessUsage(i) != null;
                if (!needAdd) {
                    JDFResourceLink.EnumUsage u = value.isInput(i) ? JDFResourceLink.EnumUsage.Input : JDFResourceLink.EnumUsage.Output;
                    boolean bl2 = needAdd = this.maxAllowed(u) < Integer.MAX_VALUE;
                    if (!needAdd) {
                        boolean bl3 = needAdd = value.isRequired(i) && !this.isRequired(u);
                    }
                }
                if (!needAdd) continue;
                this.add(value.theInfo.get(i));
            }
        }
    }

    private void add(String s) {
        if (!((s.equals("i*") || s.equals("i?")) && this.theInfo.contains("i*") || (s.equals("o*") || s.equals("o?")) && this.theInfo.contains("o*"))) {
            if ((s.equals("i+") || s.equals("i_")) && this.theInfo.contains("i*")) {
                this.theInfo.remove("i*");
                this.theInfo.add("i+");
            } else if ((s.equals("o+") || s.equals("o_")) && this.theInfo.contains("o*")) {
                this.theInfo.remove("o*");
                this.theInfo.add("o+");
            } else {
                this.theInfo.add(s);
            }
        }
    }

    public boolean hasInput(String processUsage) {
        for (String s : this.theInfo) {
            if (!s.startsWith("i") || processUsage != null && !processUsage.equals(StringUtil.rightStr(s, -2))) continue;
            return true;
        }
        return false;
    }

    boolean matchesUsage(int iPos, JDFResourceLink.EnumUsage usage) {
        if (JDFResourceLink.EnumUsage.Input.equals((Object)usage)) {
            return this.isInput(iPos);
        }
        if (JDFResourceLink.EnumUsage.Output.equals((Object)usage)) {
            return this.isOutput(iPos);
        }
        return this.theInfo.get(iPos) != null;
    }

    boolean isInput(int iPos) {
        String s = this.theInfo.get(iPos);
        return s != null && s.startsWith("i");
    }

    boolean isSingle(int iPos) {
        String s = this.get2(iPos);
        if (s != null) {
            return "?".equals(s = s.substring(1)) || "_".equals(s);
        }
        return false;
    }

    boolean isOutput(int iPos) {
        String s = this.theInfo.get(iPos);
        return s != null && s.startsWith("o");
    }

    String getProcessUsage(int iPos) {
        String pu = this.getPU(iPos);
        if (pu.length() > 0) {
            return pu;
        }
        return null;
    }

    JDFNode.EnumProcessUsage getEnumProcessUsage(int iPos) {
        String pu = this.getPU(iPos);
        if (pu.length() > 0) {
            return JDFNode.EnumProcessUsage.getEnum(pu);
        }
        if (this.isInput(iPos)) {
            return JDFNode.EnumProcessUsage.AnyInput;
        }
        if (this.isOutput(iPos)) {
            return JDFNode.EnumProcessUsage.AnyOutput;
        }
        return null;
    }

    public boolean hasOutput(String processUsage) {
        for (String s : this.theInfo) {
            if (!s.startsWith("o") || processUsage != null && !processUsage.equals(StringUtil.rightStr(s, -2))) continue;
            return true;
        }
        return false;
    }

    public JDFResourceLink.EnumUsage getUsage(String processUsage) {
        boolean bOutput;
        boolean bInput = this.hasInput(processUsage);
        if (bInput ^ (bOutput = this.hasOutput(processUsage))) {
            return bInput ? JDFResourceLink.EnumUsage.Input : JDFResourceLink.EnumUsage.Output;
        }
        return null;
    }

    public boolean isValidLink(JDFResourceLink.EnumUsage usage, String procU, int nLink) {
        int maxAllowed = this.maxAllowed(usage);
        if (nLink > maxAllowed) {
            return false;
        }
        if (!this.hasProcessUsage(procU)) {
            procU = null;
        }
        return usage == null || usage.isInput() ? this.hasInput(procU) : this.hasOutput(procU);
    }

    void makeOptional(boolean bIn, boolean bOut) {
        for (int i = 0; i < this.theInfo.size(); ++i) {
            String s = this.get2(i);
            if (bOut && s.startsWith("o")) {
                if ("o_".equals(s)) {
                    this.theInfo.set(i, "o?" + this.getPU(i));
                    continue;
                }
                if (!"o+".equals(s)) continue;
                this.theInfo.set(i, "o*" + this.getPU(i));
                continue;
            }
            if (!bIn || !s.startsWith("i")) continue;
            if ("i_".equals(s)) {
                this.theInfo.set(i, "i?" + this.getPU(i));
                continue;
            }
            if (!"i+".equals(s)) continue;
            this.theInfo.set(i, "i*" + this.getPU(i));
        }
    }

    private String getPU(int i) {
        String strWork = this.theInfo.get(i);
        return strWork.length() == 2 ? "" : strWork.substring(2);
    }

    public boolean isRequired(JDFResourceLink.EnumUsage usage) {
        for (int i = 0; i < this.theInfo.size(); ++i) {
            if (!this.matchesUsage(i, usage) || !this.isRequired(i)) continue;
            return true;
        }
        return false;
    }

    public int maxAllowed(JDFResourceLink.EnumUsage usage) {
        int n = 0;
        for (int i = 0; i < this.theInfo.size(); ++i) {
            if (!this.matchesUsage(i, usage)) continue;
            int nn = this.maxAllowed(i);
            if (nn == Integer.MAX_VALUE) {
                return nn;
            }
            n += nn;
        }
        return n;
    }

    int maxAllowed(int i) {
        String s = StringUtil.rightStr(this.get2(i), 1);
        if (s == null) {
            return 0;
        }
        if ("+".equals(s) || "*".equals(s)) {
            return Integer.MAX_VALUE;
        }
        if ("_".equals(s) || "?".equals(s)) {
            return 1;
        }
        return 0;
    }

    boolean isRequired(int i) {
        String s = this.get2(i);
        if ("i_".equals(s) || "i+".equals(s)) {
            return true;
        }
        return "o_".equals(s) || "o+".equals(s);
    }

    private String get2(int i) {
        return StringUtil.leftStr(this.theInfo.get(i), 2);
    }

    public boolean hasProcessUsage(String procU) {
        if (procU == null) {
            return this.theInfo.size() > 0;
        }
        for (String s : this.theInfo) {
            if (!procU.equals(StringUtil.rightStr(s, -2))) continue;
            return true;
        }
        return false;
    }
}

