/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.node;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.LinkInfo;
import org.cip4.jdflib.node.LinkInfoMap;
import org.cip4.jdflib.node.LinkValidatorMap;
import org.cip4.jdflib.pool.JDFResourceLinkPool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class LinkValidator {
    private final JDFNode node;
    private final LinkValidatorMap validatorMap;
    private LinkInfoMap theMap;

    LinkValidator(JDFNode n) {
        this.node = n;
        this.validatorMap = LinkValidatorMap.getLinkValidatorMap();
        this.theMap = null;
    }

    VString linkNames() {
        JDFNode.EnumType typ = JDFNode.EnumType.getEnum(this.node.getType());
        VString vTypes = this.node.getTypes();
        return this.validatorMap.getLinkNames(typ, vTypes);
    }

    LinkInfoMap getLinkInfoMap() {
        if (this.theMap == null) {
            JDFNode.EnumType typ = JDFNode.EnumType.getEnum(this.node.getType());
            VString vTypes = this.node.getTypes();
            this.theMap = this.validatorMap.getLinkInfoMap(typ, vTypes);
        }
        return this.theMap;
    }

    VString getInvalidLinks(JDFElement.EnumValidationLevel level, int nMax) {
        VElement vLinks;
        VString vElem = new VString();
        JDFResourceLinkPool linkPool = this.node.getResourceLinkPool();
        VElement vElement = vLinks = linkPool == null ? null : linkPool.getPoolChildren(null, null, null);
        if (vLinks != null) {
            for (KElement link : vLinks) {
                JDFResourceLink rl = (JDFResourceLink)link;
                if (this.isValidLink(level, rl)) continue;
                vElem.appendUnique(rl.getLinkedResourceName());
            }
        }
        if (JDFElement.EnumValidationLevel.isRequired(level)) {
            vElem.appendUnique(this.getMissingLinkVector(nMax));
        }
        return vElem;
    }

    VString getInsertLinkVector(int nMax) {
        LinkInfoMap map = this.getLinkInfoMap();
        VString vInsert = new VString();
        Vector<String> resNames = ContainerUtil.getKeyVector(map);
        block0: for (String resName : resNames) {
            LinkInfo li = (LinkInfo)map.get(resName);
            for (int j = 0; j < li.size(); ++j) {
                JDFNode.EnumProcessUsage pu = li.getEnumProcessUsage(j);
                if (li.isSingle(j) && this.getMatchingLink(resName, pu, 0) != null) continue;
                String s = resName + "Link";
                if (pu != null) {
                    s = s + ":" + pu.getName();
                }
                vInsert.add(s);
                if (vInsert.size() >= nMax) continue block0;
            }
        }
        return vInsert;
    }

    VString vLinkInfo(String name) {
        LinkInfoMap linkInfoMap = this.getLinkInfoMap();
        if (linkInfoMap == null) {
            return null;
        }
        Collection linkInfos = linkInfoMap.values();
        VString v = new VString();
        if (name == null) {
            for (LinkInfo li : linkInfos) {
                v.add(li.getString());
            }
        } else {
            LinkInfo kToken = (LinkInfo)linkInfoMap.get(name);
            if (kToken != null) {
                v.add(kToken.getString());
            }
        }
        return v.size() == 0 ? null : v;
    }

    boolean isValidLink(JDFElement.EnumValidationLevel level, JDFResourceLink rl) {
        JDFResourceLink.EnumUsage usage;
        JDFResourceLink.EnumUsage enumUsage = usage = rl == null ? null : rl.getUsage();
        if (usage == null) {
            return false;
        }
        if (!JDFElement.isInJDFNameSpaceStatic(rl)) {
            return true;
        }
        String nam = rl.getLinkedResourceName();
        String procU = StringUtil.getNonEmpty(rl.getProcessUsage());
        return this.isValidLink(nam, usage, procU);
    }

    VElement getMatchingLinks(String resName, boolean bLink, JDFNode.EnumProcessUsage processUsage) {
        VElement vE;
        block9: {
            JDFResourceLinkPool rlp;
            block11: {
                block10: {
                    block8: {
                        vE = null;
                        rlp = this.node.getResourceLinkPool();
                        if (rlp == null) {
                            return null;
                        }
                        LinkInfoMap map = this.getLinkInfoMap();
                        if (map == null) {
                            return rlp.getInOutLinks(null, bLink, resName, null);
                        }
                        LinkInfo li = map.getStar(resName);
                        if (li == null) {
                            return null;
                        }
                        if (processUsage == null || processUsage.getValue() <= JDFNode.EnumProcessUsage.AnyOutput.getValue()) break block8;
                        boolean pu = li.hasProcessUsage(processUsage.getName());
                        if (!pu) break block9;
                        JDFResourceLink.EnumUsage usage = li.getUsage(processUsage.getName());
                        vE = rlp.getInOutLinks(usage, bLink, resName, processUsage);
                        break block9;
                    }
                    if (processUsage != null) break block10;
                    String linkName = null;
                    if (resName != null && !resName.endsWith("Link")) {
                        linkName = resName + "Link";
                    }
                    vE = rlp.getPoolChildren(linkName, null, null);
                    if (bLink) break block9;
                    vE = JDFResourceLinkPool.resourceVector(vE, resName);
                    break block9;
                }
                if (processUsage != JDFNode.EnumProcessUsage.AnyInput) break block11;
                vE = rlp.getInOutLinks(JDFResourceLink.EnumUsage.Input, bLink, resName, null);
                if (!bLink || vE == null) break block9;
                Iterator vEIterator = vE.iterator();
                while (vEIterator.hasNext()) {
                    JDFResourceLink rl = (JDFResourceLink)vEIterator.next();
                    if (!rl.getPipeProtocol().equals("Internal")) continue;
                    vEIterator.remove();
                }
                break block9;
            }
            if (processUsage == JDFNode.EnumProcessUsage.AnyOutput) {
                vE = rlp.getInOutLinks(JDFResourceLink.EnumUsage.Output, bLink, resName, null);
                if (bLink && vE != null) {
                    Iterator vEIterator = vE.iterator();
                    while (vEIterator.hasNext()) {
                        JDFResourceLink rl = (JDFResourceLink)vEIterator.next();
                        if (!"Internal".equals(rl.getPipeProtocol())) continue;
                        vEIterator.remove();
                    }
                }
            }
        }
        return vE;
    }

    VString getMissingLinkVector(int nMax) {
        LinkInfoMap liMap = this.getLinkInfoMap();
        if (liMap == null) {
            return null;
        }
        if (this.node.getType().equals(JDFNode.EnumType.ProcessGroup.getName())) {
            return null;
        }
        VString vMissing = new VString();
        Vector<String> names = ContainerUtil.getKeyVector(liMap);
        block0: for (String nam : names) {
            LinkInfo li = (LinkInfo)liMap.get(nam);
            if (!li.isRequired(null)) continue;
            for (int i = 0; i < li.size(); ++i) {
                JDFNode.EnumProcessUsage pu;
                if (!li.isRequired(i) || this.getMatchingLink(nam, pu = li.getEnumProcessUsage(i), 0) != null) continue;
                String s = nam + "Link";
                if (pu != null) {
                    s = s + ":" + pu.getName();
                }
                vMissing.addElement(s);
                if (vMissing.size() >= nMax) continue block0;
            }
        }
        return vMissing;
    }

    JDFResourceLink linkMatchingResource(JDFResource resource, JDFNode.EnumProcessUsage processUsage, JDFAttributeMap partMap) {
        String resName = resource.getLocalName();
        JDFResourceLink.EnumUsage usage = this.extractUsage(resName, processUsage);
        JDFResourceLink rl = this.node.getLink(resource, usage);
        boolean exists = rl != null;
        String sProcessUsage = this.extractProcessUsage(processUsage);
        if (rl == null) {
            rl = this.node.ensureLink(resource, usage, null);
        }
        if (rl != null && !exists && !this.isValidLink(JDFElement.EnumValidationLevel.Complete, rl)) {
            rl.deleteNode();
            rl = null;
        } else if (rl != null) {
            if (partMap != null) {
                rl.setPartMap(partMap);
            }
            if (sProcessUsage != null) {
                rl.setProcessUsage(sProcessUsage);
            }
        }
        return rl;
    }

    private String extractProcessUsage(JDFNode.EnumProcessUsage processUsage) {
        if (processUsage == null) {
            return null;
        }
        if (JDFNode.EnumProcessUsage.AnyInput.equals((Object)processUsage) || JDFNode.EnumProcessUsage.AnyOutput.equals((Object)processUsage)) {
            return null;
        }
        return processUsage.getName();
    }

    private JDFResourceLink.EnumUsage extractUsage(String name, JDFNode.EnumProcessUsage processUsage) {
        if (JDFNode.EnumProcessUsage.AnyInput.equals((Object)processUsage)) {
            return JDFResourceLink.EnumUsage.Input;
        }
        if (JDFNode.EnumProcessUsage.AnyOutput.equals((Object)processUsage)) {
            return JDFResourceLink.EnumUsage.Output;
        }
        for (int i = 0; i < 2; ++i) {
            LinkInfo info = this.getLinkInfo(name, i == 1);
            if (info == null || info.size() <= 0) continue;
            JDFResourceLink.EnumUsage ret = null;
            if (processUsage != null) {
                ret = info.getUsage(processUsage.getName());
            }
            if (ret == null) {
                ret = info.getUsage(null);
            }
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private LinkInfo getLinkInfo(String name, boolean checkStar) {
        LinkInfoMap map = this.getLinkInfoMap();
        if (map == null) {
            return null;
        }
        return checkStar ? map.getStar(name) : (LinkInfo)map.get(name);
    }

    int numMatchingLinks(String resName, boolean bLink, JDFNode.EnumProcessUsage processUsage) {
        int iNumMatchingLinks = 0;
        VElement v = this.getMatchingLinks(resName, bLink, processUsage);
        if (v != null) {
            iNumMatchingLinks = v.size();
        }
        return iNumMatchingLinks;
    }

    JDFResourceLink getMatchingLink(String resName, JDFNode.EnumProcessUsage processUsage, int pos) {
        VElement vE = this.getMatchingLinks(resName, true, processUsage);
        return vE != null && vE.size() > pos ? (JDFResourceLink)vE.elementAt(pos) : null;
    }

    JDFResource appendMatchingResource(String resName, JDFNode.EnumProcessUsage processUsage, JDFNode resourceRoot) {
        JDFResource r;
        JDFResourceLink rl;
        if (resourceRoot == null) {
            resourceRoot = this.node;
        }
        if ((rl = this.linkMatchingResource(r = resourceRoot.addResource(resName, null), processUsage, null)) == null) {
            boolean mustZapp;
            JDFResourceLink.EnumUsage usage = this.extractUsage(resName, processUsage);
            boolean bl = mustZapp = usage != null;
            if (!mustZapp) {
                int maxAllowed;
                LinkInfo li = this.getLinkInfo(resName, true);
                boolean bl2 = mustZapp = li == null || li.size() == 0;
                if (!mustZapp && (maxAllowed = li.maxAllowed(null)) < Integer.MAX_VALUE) {
                    VElement resourceLinks = this.node.getResourceLinks(resName, null, null);
                    boolean bl3 = mustZapp = resourceLinks != null && resourceLinks.size() >= maxAllowed;
                }
            }
            if (mustZapp) {
                r.deleteNode();
                r = null;
            }
        }
        return r;
    }

    public String toString() {
        return "LinkValidator " + this.node.getTypesString() + " [theMap=" + String.valueOf(this.getLinkInfoMap()) + "]";
    }

    boolean isValidLink(String resName, JDFResourceLink.EnumUsage usage, String processUsage) {
        LinkInfo li = this.getLinkInfo(resName, true);
        if (li == null) {
            return false;
        }
        JDFAttributeMap uMap = usage == null ? null : new JDFAttributeMap("Usage", usage);
        VElement vExist = this.node.getResourceLinks(resName, uMap, null);
        return li.isValidLink(usage, processUsage, vExist == null ? 0 : vExist.size());
    }
}

