/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPart;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFSignature;
import org.cip4.jdflib.resource.process.JDFContentObject;
import org.cip4.jdflib.resource.process.JDFSurface;
import org.cip4.jdflib.resource.process.postpress.JDFSheet;
import org.cip4.jdflib.util.StringUtil;

public class JDFLayout
extends JDFSurface {
    private static final long serialVersionUID = 1L;

    public JDFLayout(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFLayout(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFLayout(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFLayout[  --> " + super.toString() + " ]";
    }

    public Vector<Integer> getAllOrds() {
        Vector<Integer> vi;
        Vector<JDFContentObject> v = this.getChildrenByClass(JDFContentObject.class, true, 0);
        if (v == null || v.size() == 0) {
            vi = null;
        } else {
            vi = new Vector<Integer>(v.size());
            for (JDFContentObject co : v) {
                String s = co.getAttribute("Ord", null, null);
                int i = StringUtil.parseInt(s, -123456);
                if (i == 123456) continue;
                vi.add(i);
            }
        }
        return vi;
    }

    public int calcMaxOrd() {
        Vector<Integer> v = this.getAllOrds();
        if (v == null) {
            return -1;
        }
        int maxOrd = -2;
        for (Integer ii : v) {
            if (ii <= maxOrd) continue;
            maxOrd = ii;
        }
        return maxOrd + 1;
    }

    public int calcNumSame() {
        Vector<Integer> v = this.getAllOrds();
        if (v == null) {
            return -1;
        }
        int maxOrd = -2;
        for (Integer ii : v) {
            if (ii <= maxOrd) continue;
            maxOrd = ii;
        }
        int minmax = -1;
        if (++maxOrd >= 0) {
            int[] iii = new int[maxOrd];
            for (int i : iii) {
                iii[i] = 0;
            }
            Object object = v.iterator();
            while (object.hasNext()) {
                Integer ii = (Integer)object.next();
                int n = ii;
                iii[n] = iii[n] + 1;
            }
            int max = -1;
            int min = Integer.MAX_VALUE;
            for (int i : iii) {
                if (i <= 0) continue;
                if (i > max) {
                    max = i;
                }
                if (i >= min) continue;
                min = i;
            }
            if (min == max) {
                minmax = min;
            }
        }
        return minmax;
    }

    public boolean toNewLayout() {
        VElement vSig = this.getChildElementVector("Signature", null, null, false, 0, false);
        for (int iSig = 0; iSig < vSig.size(); ++iSig) {
            JDFElement rSig = (JDFElement)vSig.elementAt(iSig);
            if (rSig instanceof JDFRefElement) {
                rSig = ((JDFRefElement)rSig).inlineRef();
            }
            JDFLayout newLO = (JDFLayout)rSig.renameElement("Layout", null);
            newLO.setPartIDKey(JDFResource.EnumPartIDKey.SignatureName, rSig.getAttribute("Name", null, "Sig" + String.valueOf(iSig)));
            newLO.cleanLayoutLeaf();
            VElement vSheet = newLO.getChildElementVector("Sheet", null, null, false, 0, false);
            for (int iSheet = 0; iSheet < vSheet.size(); ++iSheet) {
                JDFElement rSheet = (JDFElement)vSheet.elementAt(iSheet);
                if (rSheet instanceof JDFRefElement) {
                    rSheet = ((JDFRefElement)rSheet).inlineRef();
                }
                newLO = (JDFLayout)rSheet.renameElement("Layout", null);
                newLO.setPartIDKey(JDFResource.EnumPartIDKey.SheetName, rSheet.getAttribute("Name", null, "Sheet" + String.valueOf(iSheet)));
                newLO.cleanLayoutLeaf();
                VElement vSurf = newLO.getChildElementVector("Surface", null, null, false, 0, false);
                for (int iSurf = 0; iSurf < vSurf.size(); ++iSurf) {
                    JDFElement rSurf = (JDFElement)vSurf.elementAt(iSurf);
                    if (rSurf instanceof JDFRefElement) {
                        rSurf = ((JDFRefElement)rSurf).inlineRef();
                    }
                    newLO = (JDFLayout)rSurf.renameElement("Layout", null);
                    newLO.setPartIDKey(JDFResource.EnumPartIDKey.Side, rSurf.getAttribute("Side", null, "Surf" + String.valueOf(iSurf)));
                    newLO.cleanLayoutLeaf();
                }
            }
        }
        return true;
    }

    private void cleanLayoutLeaf() {
        this.removeAttribute("Name");
        this.removeAttribute("Class");
    }

    public boolean fromNewLayout() {
        VElement vLO = this.getChildElementVector_JDFElement("Layout", null, new JDFAttributeMap("SignatureName", ""), false, 0, false);
        VElement vSig = new VElement();
        if (vLO.isEmpty()) {
            JDFSignature signature = (JDFSignature)this.appendElement("Signature");
            signature.setName("Sig_00");
            vSig.add(signature);
            this.moveElementsTo((JDFLayout)signature);
        } else {
            JDFSignature sig = null;
            for (int i = 0; i < vLO.size(); ++i) {
                JDFElement lo = (JDFElement)vLO.elementAt(i);
                sig = null;
                if (lo.hasAttribute("SignatureName")) {
                    lo.renameAttribute("SignatureName", "Name", null, null);
                    sig = (JDFSignature)lo.renameElement("Signature", null);
                    sig.cleanResourceAttributes();
                    vSig.add(sig);
                } else if (vSig.isEmpty()) {
                    JDFSignature signature = (JDFSignature)this.appendElement("Signature");
                    signature.setName("Sig_00");
                    vSig.add(sig);
                }
                if (sig == null) continue;
                this.moveElement(sig, null);
            }
        }
        int nSheet = 0;
        for (int iSig = 0; iSig < vSig.size(); ++iSig) {
            JDFSignature sig = (JDFSignature)vSig.elementAt(iSig);
            vLO = sig.getChildElementVector_JDFElement("Layout", null, new JDFAttributeMap("SheetName", ""), false, 0, false);
            VElement vSheet = new VElement();
            if (vLO.isEmpty()) {
                sheet = (JDFSheet)sig.appendElement("Sheet");
                sheet.setName("Sheet_" + String.valueOf(++nSheet));
                vSheet.add(sheet);
                ((JDFLayout)sig).moveElementsTo((JDFLayout)sheet);
            } else {
                sheet = null;
                for (int i = 0; i < vLO.size(); ++i) {
                    sheet = null;
                    JDFElement lo = (JDFElement)vLO.elementAt(i);
                    if (lo.hasAttribute("SheetName")) {
                        lo.renameAttribute("SheetName", "Name", null, null);
                        sheet = (JDFSheet)lo.renameElement("Sheet", null);
                        sheet.cleanResourceAttributes();
                        vSheet.add(sheet);
                        ++nSheet;
                        continue;
                    }
                    if (vSheet.isEmpty()) {
                        sheet = (JDFSheet)sig.appendElement("Sheet");
                        sheet.setName("Sheet_" + String.valueOf(++nSheet));
                        vSheet.add(sheet);
                    }
                    if (sheet == null) continue;
                    sheet.moveElement(lo, null);
                }
            }
            for (int iSheet = 0; iSheet < vSheet.size(); ++iSheet) {
                JDFSheet sheet = (JDFSheet)vSheet.elementAt(iSheet);
                vLO = sheet.getChildElementVector_JDFElement("Layout", null, new JDFAttributeMap("Side", ""), false, 0, false);
                if (vLO.isEmpty()) {
                    JDFSurface surf = (JDFSurface)sheet.appendElement("Surface");
                    surf.setSide(JDFAutoPart.EnumSide.Front);
                    ((JDFLayout)sheet).moveElementsTo((JDFLayout)surf);
                    continue;
                }
                for (int i = 0; i < vLO.size(); ++i) {
                    JDFSurface surface = (JDFSurface)vLO.elementAt(i);
                    surface.renameElement("Surface", null);
                    JDFAutoPart.EnumSide sid = surface.getSide();
                    surface.cleanResourceAttributes();
                    surface.setSide(sid);
                }
            }
        }
        this.removeFromAttribute("PartIDKeys", "SignatureName", null, " ", -1);
        this.removeFromAttribute("PartIDKeys", "SheetName", null, " ", -1);
        this.removeFromAttribute("PartIDKeys", "Side", null, " ", -1);
        return true;
    }

    private void moveElementsTo(JDFLayout target) {
        int i;
        VElement vPO = this.getPlacedObjectVector();
        if (vPO != null) {
            for (i = 0; i < vPO.size(); ++i) {
                target.moveElement(vPO.elementAt(i), null);
            }
        }
        if ((vPO = this.getChildElementVector_JDFElement("Layout", null, null, false, 0, false)) != null) {
            for (i = 0; i < vPO.size(); ++i) {
                target.moveElement(vPO.elementAt(i), null);
            }
        }
    }

    public static boolean isNewLayout(JDFResource sheet) {
        if (!(sheet instanceof JDFLayout)) {
            return false;
        }
        if (!sheet.getLocalName().equals("Layout")) {
            return false;
        }
        if (sheet.getElement_KElement("Signature", null, 0) != null) {
            return false;
        }
        JDFResource resourceRoot = sheet.getResourceRoot();
        if (resourceRoot.hasAttribute("PartIDKeys")) {
            return true;
        }
        if (resourceRoot.hasChildElement("ContentObject", null) || resourceRoot.hasChildElement("MarkObject", null)) {
            return true;
        }
        JDFElement.EnumVersion v = sheet.getVersion(true);
        if (v == null) {
            return true;
        }
        return v.getValue() >= JDFElement.EnumVersion.Version_1_3.getValue();
    }

    @Override
    public JDFSignature appendSignature() throws JDFException {
        return JDFLayout.appendLayoutElement(this, "Signature", "SignatureName");
    }

    public int numSignatures() {
        return JDFLayout.numLayoutElements(this, "Signature", "SignatureName");
    }

    @Override
    public JDFSignature getCreateSignature(int iSkip) {
        JDFSignature s = this.getSignature(iSkip);
        if (s == null) {
            s = this.appendSignature();
        }
        return s;
    }

    @Override
    public JDFSignature getSignature(int iSkip) {
        return JDFLayout.getLayoutElement((JDFResource)this, "Signature", "SignatureName", iSkip);
    }

    public JDFSignature getSignature(String signatureName) {
        return JDFLayout.getLayoutElement((JDFResource)this, "Signature", "SignatureName", signatureName);
    }

    public JDFSignature getCreateSignature(String signatureName) throws JDFException {
        return JDFLayout.getCreateLayoutElement(this, "Signature", "SignatureName", signatureName);
    }

    public VElement getSignatureVector() {
        return JDFLayout.getLayoutElementVector(this, "Signature", "SignatureName");
    }
}

