/*
 * The CIP4 Software License, Version 1.0
 *
 *
 * Copyright (c) 2001-2025 The International Cooperation for the Integration of
 * Processes in  Prepress, Press and Postpress (CIP4).  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        The International Cooperation for the Integration of
 *        Processes in  Prepress, Press and Postpress (www.cip4.org)"
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "CIP4" and "The International Cooperation for the Integration of
 *    Processes in  Prepress, Press and Postpress" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact info@cip4.org.
 *
 * 5. Products derived from this software may not be called "CIP4",
 *    nor may "CIP4" appear in their name, without prior written
 *    permission of the CIP4 organization
 *
 * Usage of this software in commercial products is subject to restrictions. For
 * details please consult info@cip4.org.
  *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE INTERNATIONAL COOPERATION FOR
 * THE INTEGRATION OF PROCESSES IN PREPRESS, PRESS AND POSTPRESS OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the The International Cooperation for the Integration
 * of Processes in Prepress, Press and Postpress and was
 * originally based on software
 * copyright (c) 1999-2001, Heidelberger Druckmaschinen AG
 * copyright (c) 1999-2001, Agfa-Gevaert N.V.
 *
 * For more information on The International Cooperation for the
 * Integration of Processes in  Prepress, Press and Postpress , please see
 * <http://www.cip4.org/>.
 *
 *
 */

package org.cip4.jdflib.auto;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.AttributeName;
import org.cip4.jdflib.core.JDFCoreConstants;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.util.JavaEnumUtil;

/**
 ***************************************************************************** class JDFAutoFeatureAttribute : public JDFElement
 */

public abstract class JDFAutoFeatureAttribute extends JDFElement
{

	private static final long serialVersionUID = 1L;

	private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[3];
	static
	{
		atrInfoTable[0] = new AtrInfoTable(AttributeName.CURRENTVALUE, 0x3333333311l, AttributeInfo.EnumAttributeType.string, null, null);
		atrInfoTable[1] = new AtrInfoTable(AttributeName.EDITABLE, 0x3333333311l, AttributeInfo.EnumAttributeType.boolean_, null, null);
		atrInfoTable[2] = new AtrInfoTable(AttributeName.USERDISPLAY, 0x3333333311l, AttributeInfo.EnumAttributeType.enumeration, EnumUserDisplay.getEnum(0),
				null);
	}

	@Override
	protected AttributeInfo getTheAttributeInfo()
	{
		return super.getTheAttributeInfo().updateReplace(atrInfoTable);
	}

	/**
	 * Constructor for JDFAutoFeatureAttribute
	 *
	 * @param myOwnerDocument
	 * @param qualifiedName
	 */
	protected JDFAutoFeatureAttribute(CoreDocumentImpl myOwnerDocument, String qualifiedName)
	{
		super(myOwnerDocument, qualifiedName);
	}

	/**
	 * Constructor for JDFAutoFeatureAttribute
	 *
	 * @param myOwnerDocument
	 * @param myNamespaceURI
	 * @param qualifiedName
	 */
	protected JDFAutoFeatureAttribute(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName)
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName);
	}

	/**
	 * Constructor for JDFAutoFeatureAttribute
	 *
	 * @param myOwnerDocument
	 * @param myNamespaceURI
	 * @param qualifiedName
	 * @param myLocalName
	 */
	protected JDFAutoFeatureAttribute(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName)
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
	}

	/**
	 * Enumeration strings for UserDisplay
	 */

	public enum EUserDisplay
	{
		Display, Hide, Dependant;

		public static EUserDisplay getEnum(String val)
		{
			return JavaEnumUtil.getEnumIgnoreCase(EUserDisplay.class, val, null);
		}
	}

	/**
	 * Enumeration strings for UserDisplay
	 */

	@SuppressWarnings("rawtypes")
	public static class EnumUserDisplay extends ValuedEnum
	{
		private static final long serialVersionUID = 1L;
		private static int m_startValue = 0;

		protected EnumUserDisplay(String name)
		{
			super(name, m_startValue++);
		}

		/**
		 * @param enumName the string to convert
		 * @return the enum
		 */
		public static EnumUserDisplay getEnum(String enumName)
		{
			return (EnumUserDisplay) getEnum(EnumUserDisplay.class, enumName);
		}

		/**
		 * @param enumValue the integer to convert
		 * @return the enum
		 */
		public static EnumUserDisplay getEnum(int enumValue)
		{
			return (EnumUserDisplay) getEnum(EnumUserDisplay.class, enumValue);
		}

		/**
		 * @return the map of enums
		 */
		public static Map getEnumMap()
		{
			return getEnumMap(EnumUserDisplay.class);
		}

		/**
		 * @return the list of enums
		 */
		public static List getEnumList()
		{
			return getEnumList(EnumUserDisplay.class);
		}

		/**
		 * @return the iterator
		 */
		public static Iterator iterator()
		{
			return iterator(EnumUserDisplay.class);
		}

		/**  */
		public static final EnumUserDisplay Display = new EnumUserDisplay("Display");
		/**  */
		public static final EnumUserDisplay Hide = new EnumUserDisplay("Hide");
		/**  */
		public static final EnumUserDisplay Dependant = new EnumUserDisplay("Dependant");
	}

	/*
	 * ************************************************************************
	 * Attribute getter / setter
	 * ************************************************************************
	 */

	/*
	 * ---------------------------------------------------------------------
	 * Methods for Attribute CurrentValue
	 * ---------------------------------------------------------------------
	 */
	/**
	 * (36) set attribute CurrentValue
	 *
	 * @param value the value to set the attribute to
	 */
	public void setCurrentValue(String value)
	{
		setAttribute(AttributeName.CURRENTVALUE, value, null);
	}

	/**
	 * (23) get String attribute CurrentValue
	 *
	 * @return the value of the attribute
	 */
	public String getCurrentValue()
	{
		return getAttribute(AttributeName.CURRENTVALUE, null, JDFCoreConstants.EMPTYSTRING);
	}

	/*
	 * ---------------------------------------------------------------------
	 * Methods for Attribute Editable
	 * ---------------------------------------------------------------------
	 */
	/**
	 * (36) set attribute Editable
	 *
	 * @param value the value to set the attribute to
	 */
	public void setEditable(boolean value)
	{
		setAttribute(AttributeName.EDITABLE, value, null);
	}

	/**
	 * (18) get boolean attribute Editable
	 *
	 * @return boolean the value of the attribute
	 */
	public boolean getEditable()
	{
		return getBoolAttribute(AttributeName.EDITABLE, null, false);
	}

	/*
	 * ---------------------------------------------------------------------
	 * Methods for Attribute UserDisplay
	 * ---------------------------------------------------------------------
	 */
	/**
	 * (5) set attribute UserDisplay
	 *
	 * @param enumVar the enumVar to set the attribute to
	 */
	public void setUserDisplay(EUserDisplay enumVar)
	{
		setAttribute(AttributeName.USERDISPLAY, enumVar == null ? null : enumVar.name(), null);
	}

	/**
	 * (9) get attribute UserDisplay
	 *
	 * @return the value of the attribute
	 */
	public EUserDisplay getEUserDisplay()
	{
		return EUserDisplay.getEnum(getAttribute(AttributeName.USERDISPLAY, null, null));
	}

	/*
	 * ---------------------------------------------------------------------
	 * Methods for Attribute UserDisplay
	 * ---------------------------------------------------------------------
	 */
	/**
	 * (5) set attribute UserDisplay
	 *
	 * @param enumVar the enumVar to set the attribute to
	 * @deprecated use SetUserDisplay(EUserDisplay) based on java.lang.enum instead
	 */
	@Deprecated
	public void setUserDisplay(EnumUserDisplay enumVar)
	{
		setAttribute(AttributeName.USERDISPLAY, enumVar == null ? null : enumVar.getName(), null);
	}

	/**
	 * (9) get attribute UserDisplay
	 *
	 * @return the value of the attribute
	 * @deprecated use EUserDisplay GetEUserDisplay() based on java.lang.enum instead
	 */
	@Deprecated
	public EnumUserDisplay getUserDisplay()
	{
		return EnumUserDisplay.getEnum(getAttribute(AttributeName.USERDISPLAY, null, null));
	}

}
