/*
 * The CIP4 Software License, Version 1.0
 *
 *
 * Copyright (c) 2001-2025 The International Cooperation for the Integration of
 * Processes in  Prepress, Press and Postpress (CIP4).  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        The International Cooperation for the Integration of
 *        Processes in  Prepress, Press and Postpress (www.cip4.org)"
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "CIP4" and "The International Cooperation for the Integration of
 *    Processes in  Prepress, Press and Postpress" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact info@cip4.org.
 *
 * 5. Products derived from this software may not be called "CIP4",
 *    nor may "CIP4" appear in their name, without prior written
 *    permission of the CIP4 organization
 *
 * Usage of this software in commercial products is subject to restrictions. For
 * details please consult info@cip4.org.
  *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE INTERNATIONAL COOPERATION FOR
 * THE INTEGRATION OF PROCESSES IN PREPRESS, PRESS AND POSTPRESS OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the The International Cooperation for the Integration
 * of Processes in Prepress, Press and Postpress and was
 * originally based on software
 * copyright (c) 1999-2001, Heidelberger Druckmaschinen AG
 * copyright (c) 1999-2001, Agfa-Gevaert N.V.
 *
 * For more information on The International Cooperation for the
 * Integration of Processes in  Prepress, Press and Postpress , please see
 * <http://www.cip4.org/>.
 *
 *
 */

package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.AttributeName;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.ElementName;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.resource.process.JDFMISDetails;
import org.cip4.jdflib.util.JavaEnumUtil;

/**
 ***************************************************************************** class JDFAutoResourceAudit : public JDFAudit
 */

public abstract class JDFAutoResourceAudit extends JDFAudit
{

	private static final long serialVersionUID = 1L;

	private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[3];
	static
	{
		atrInfoTable[0] = new AtrInfoTable(AttributeName.CONTENTSMODIFIED, 0x3333333333l, AttributeInfo.EnumAttributeType.boolean_, null, null);
		atrInfoTable[1] = new AtrInfoTable(AttributeName.NODESTATUS, 0x3333333111l, AttributeInfo.EnumAttributeType.enumeration, EnumNodeStatus.getEnum(0),
				null);
		atrInfoTable[2] = new AtrInfoTable(AttributeName.REASON, 0x3333333331l, AttributeInfo.EnumAttributeType.enumeration, EnumReason.getEnum(0),
				"ProcessResult");
	}

	@Override
	protected AttributeInfo getTheAttributeInfo()
	{
		return super.getTheAttributeInfo().updateReplace(atrInfoTable);
	}

	private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[3];
	static
	{
		elemInfoTable[0] = new ElemInfoTable(ElementName.EMPLOYEE, 0x3333333333l);
		elemInfoTable[1] = new ElemInfoTable(ElementName.MISDETAILS, 0x6666666111l);
		elemInfoTable[2] = new ElemInfoTable(ElementName.PART, 0x3333333111l);
	}

	@Override
	protected ElementInfo getTheElementInfo()
	{
		return super.getTheElementInfo().updateReplace(elemInfoTable);
	}

	/**
	 * Constructor for JDFAutoResourceAudit
	 *
	 * @param myOwnerDocument
	 * @param qualifiedName
	 */
	protected JDFAutoResourceAudit(CoreDocumentImpl myOwnerDocument, String qualifiedName)
	{
		super(myOwnerDocument, qualifiedName);
	}

	/**
	 * Constructor for JDFAutoResourceAudit
	 *
	 * @param myOwnerDocument
	 * @param myNamespaceURI
	 * @param qualifiedName
	 */
	protected JDFAutoResourceAudit(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName)
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName);
	}

	/**
	 * Constructor for JDFAutoResourceAudit
	 *
	 * @param myOwnerDocument
	 * @param myNamespaceURI
	 * @param qualifiedName
	 * @param myLocalName
	 */
	protected JDFAutoResourceAudit(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName)
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
	}

	/**
	 * Enumeration strings for Reason
	 */

	public enum EReason
	{
		OperatorInput, PlanChange, ProcessResult;

		public static EReason getEnum(String val)
		{
			return JavaEnumUtil.getEnumIgnoreCase(EReason.class, val, EReason.ProcessResult);
		}
	}

	/**
	 * Enumeration strings for Reason
	 */

	@SuppressWarnings("rawtypes")
	public static class EnumReason extends ValuedEnum
	{
		private static final long serialVersionUID = 1L;
		private static int m_startValue = 0;

		protected EnumReason(String name)
		{
			super(name, m_startValue++);
		}

		/**
		 * @param enumName the string to convert
		 * @return the enum
		 */
		public static EnumReason getEnum(String enumName)
		{
			return (EnumReason) getEnum(EnumReason.class, enumName);
		}

		/**
		 * @param enumValue the integer to convert
		 * @return the enum
		 */
		public static EnumReason getEnum(int enumValue)
		{
			return (EnumReason) getEnum(EnumReason.class, enumValue);
		}

		/**
		 * @return the map of enums
		 */
		public static Map getEnumMap()
		{
			return getEnumMap(EnumReason.class);
		}

		/**
		 * @return the list of enums
		 */
		public static List getEnumList()
		{
			return getEnumList(EnumReason.class);
		}

		/**
		 * @return the iterator
		 */
		public static Iterator iterator()
		{
			return iterator(EnumReason.class);
		}

		/**  */
		public static final EnumReason OperatorInput = new EnumReason("OperatorInput");
		/**  */
		public static final EnumReason PlanChange = new EnumReason("PlanChange");
		/**  */
		public static final EnumReason ProcessResult = new EnumReason("ProcessResult");
	}

	/*
	 * ************************************************************************
	 * Attribute getter / setter
	 * ************************************************************************
	 */

	/*
	 * ---------------------------------------------------------------------
	 * Methods for Attribute ContentsModified
	 * ---------------------------------------------------------------------
	 */
	/**
	 * (36) set attribute ContentsModified
	 *
	 * @param value the value to set the attribute to
	 */
	public void setContentsModified(boolean value)
	{
		setAttribute(AttributeName.CONTENTSMODIFIED, value, null);
	}

	/**
	 * (18) get boolean attribute ContentsModified
	 *
	 * @return boolean the value of the attribute
	 */
	public boolean getContentsModified()
	{
		return getBoolAttribute(AttributeName.CONTENTSMODIFIED, null, false);
	}

	/*
	 * ---------------------------------------------------------------------
	 * Methods for Attribute NodeStatus
	 * ---------------------------------------------------------------------
	 */
	/**
	 * (5) set attribute NodeStatus
	 *
	 * @param enumVar the enumVar to set the attribute to
	 */
	public void setNodeStatus(ENodeStatus enumVar)
	{
		setAttribute(AttributeName.NODESTATUS, enumVar == null ? null : enumVar.name(), null);
	}

	/**
	 * (9) get attribute NodeStatus
	 *
	 * @return the value of the attribute
	 */
	public ENodeStatus getENodeStatus()
	{
		return ENodeStatus.getEnum(getAttribute(AttributeName.NODESTATUS, null, null));
	}

	/*
	 * ---------------------------------------------------------------------
	 * Methods for Attribute NodeStatus
	 * ---------------------------------------------------------------------
	 */
	/**
	 * (5) set attribute NodeStatus
	 *
	 * @param enumVar the enumVar to set the attribute to
	 * @deprecated use SetNodeStatus(ENodeStatus) based on java.lang.enum instead
	 */
	@Deprecated
	public void setNodeStatus(EnumNodeStatus enumVar)
	{
		setAttribute(AttributeName.NODESTATUS, enumVar == null ? null : enumVar.getName(), null);
	}

	/**
	 * (9) get attribute NodeStatus
	 *
	 * @return the value of the attribute
	 * @deprecated use ENodeStatus GetENodeStatus() based on java.lang.enum instead
	 */
	@Deprecated
	public EnumNodeStatus getNodeStatus()
	{
		return EnumNodeStatus.getEnum(getAttribute(AttributeName.NODESTATUS, null, null));
	}

	/*
	 * ---------------------------------------------------------------------
	 * Methods for Attribute Reason
	 * ---------------------------------------------------------------------
	 */
	/**
	 * (5) set attribute Reason
	 *
	 * @param enumVar the enumVar to set the attribute to
	 */
	public void setReason(EReason enumVar)
	{
		setAttribute(AttributeName.REASON, enumVar == null ? null : enumVar.name(), null);
	}

	/**
	 * (9) get attribute Reason
	 *
	 * @return the value of the attribute
	 */
	public EReason getEReason()
	{
		return EReason.getEnum(getAttribute(AttributeName.REASON, null, "ProcessResult"));
	}

	/*
	 * ---------------------------------------------------------------------
	 * Methods for Attribute Reason
	 * ---------------------------------------------------------------------
	 */
	/**
	 * (5) set attribute Reason
	 *
	 * @param enumVar the enumVar to set the attribute to
	 * @deprecated use SetReason(EReason) based on java.lang.enum instead
	 */
	@Deprecated
	public void setReason(EnumReason enumVar)
	{
		setAttribute(AttributeName.REASON, enumVar == null ? null : enumVar.getName(), null);
	}

	/**
	 * (9) get attribute Reason
	 *
	 * @return the value of the attribute
	 * @deprecated use EReason GetEReason() based on java.lang.enum instead
	 */
	@Deprecated
	public EnumReason getReason()
	{
		return EnumReason.getEnum(getAttribute(AttributeName.REASON, null, "ProcessResult"));
	}

	/*
	 * ***********************************************************************
	 * Element getter / setter
	 * ***********************************************************************
	 */

	/**
	 * (24) const get element Employee
	 *
	 * @return JDFEmployee the element
	 */
	public JDFEmployee getEmployee()
	{
		return (JDFEmployee) getElement(ElementName.EMPLOYEE, null, 0);
	}

	/**
	 * (25) getCreateEmployee
	 * 
	 * @return JDFEmployee the element
	 */
	public JDFEmployee getCreateEmployee()
	{
		return (JDFEmployee) getCreateElement_JDFElement(ElementName.EMPLOYEE, null, 0);
	}

	/**
	 * (26) getCreateEmployee
	 * 
	 * @param iSkip number of elements to skip
	 * @return JDFEmployee the element
	 */
	@Override
	public JDFEmployee getCreateEmployee(int iSkip)
	{
		return (JDFEmployee) getCreateElement_JDFElement(ElementName.EMPLOYEE, null, iSkip);
	}

	/**
	 * (27) const get element Employee
	 *
	 * @param iSkip number of elements to skip
	 * @return JDFEmployee the element
	 *         default is getEmployee(0)
	 */
	@Override
	public JDFEmployee getEmployee(int iSkip)
	{
		return (JDFEmployee) getElement(ElementName.EMPLOYEE, null, iSkip);
	}

	/**
	 * Get all Employee from the current element
	 * 
	 * @return Collection<JDFEmployee>, null if none are available
	 */
	@Override
	public Collection<JDFEmployee> getAllEmployee()
	{
		return getChildArrayByClass(JDFEmployee.class, false, 0);
	}

	/**
	 * (30) append element Employee
	 *
	 * @return JDFEmployee the element
	 */
	@Override
	public JDFEmployee appendEmployee()
	{
		return (JDFEmployee) appendElement(ElementName.EMPLOYEE, null);
	}

	/**
	 * (24) const get element MISDetails
	 *
	 * @return JDFMISDetails the element
	 */
	public JDFMISDetails getMISDetails()
	{
		return (JDFMISDetails) getElement(ElementName.MISDETAILS, null, 0);
	}

	/**
	 * (25) getCreateMISDetails
	 * 
	 * @return JDFMISDetails the element
	 */
	public JDFMISDetails getCreateMISDetails()
	{
		return (JDFMISDetails) getCreateElement_JDFElement(ElementName.MISDETAILS, null, 0);
	}

	/**
	 * (29) append element MISDetails
	 *
	 * @return JDFMISDetails the element
	 * @ if the element already exists
	 */
	public JDFMISDetails appendMISDetails()
	{
		return (JDFMISDetails) appendElementN(ElementName.MISDETAILS, 1, null);
	}

	/**
	 * (24) const get element Part
	 *
	 * @return JDFPart the element
	 */
	public JDFPart getPart()
	{
		return (JDFPart) getElement(ElementName.PART, null, 0);
	}

	/**
	 * (25) getCreatePart
	 * 
	 * @return JDFPart the element
	 */
	public JDFPart getCreatePart()
	{
		return (JDFPart) getCreateElement_JDFElement(ElementName.PART, null, 0);
	}

	/**
	 * (26) getCreatePart
	 * 
	 * @param iSkip number of elements to skip
	 * @return JDFPart the element
	 */
	public JDFPart getCreatePart(int iSkip)
	{
		return (JDFPart) getCreateElement_JDFElement(ElementName.PART, null, iSkip);
	}

	/**
	 * (27) const get element Part
	 *
	 * @param iSkip number of elements to skip
	 * @return JDFPart the element
	 *         default is getPart(0)
	 */
	public JDFPart getPart(int iSkip)
	{
		return (JDFPart) getElement(ElementName.PART, null, iSkip);
	}

	/**
	 * Get all Part from the current element
	 * 
	 * @return Collection<JDFPart>, null if none are available
	 */
	public Collection<JDFPart> getAllPart()
	{
		return getChildArrayByClass(JDFPart.class, false, 0);
	}

	/**
	 * (30) append element Part
	 *
	 * @return JDFPart the element
	 */
	public JDFPart appendPart()
	{
		return (JDFPart) appendElement(ElementName.PART, null);
	}

}
