/*
 * The CIP4 Software License, Version 1.0
 *
 *
 * Copyright (c) 2001-2025 The International Cooperation for the Integration of
 * Processes in  Prepress, Press and Postpress (CIP4).  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        The International Cooperation for the Integration of
 *        Processes in  Prepress, Press and Postpress (www.cip4.org)"
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "CIP4" and "The International Cooperation for the Integration of
 *    Processes in  Prepress, Press and Postpress" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact info@cip4.org.
 *
 * 5. Products derived from this software may not be called "CIP4",
 *    nor may "CIP4" appear in their name, without prior written
 *    permission of the CIP4 organization
 *
 * Usage of this software in commercial products is subject to restrictions. For
 * details please consult info@cip4.org.
  *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE INTERNATIONAL COOPERATION FOR
 * THE INTEGRATION OF PROCESSES IN PREPRESS, PRESS AND POSTPRESS OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the The International Cooperation for the Integration
 * of Processes in Prepress, Press and Postpress and was
 * originally based on software
 * copyright (c) 1999-2001, Heidelberger Druckmaschinen AG
 * copyright (c) 1999-2001, Agfa-Gevaert N.V.
 *
 * For more information on The International Cooperation for the
 * Integration of Processes in  Prepress, Press and Postpress , please see
 * <http://www.cip4.org/>.
 *
 *
 */

package org.cip4.jdflib.auto;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.AttributeName;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.ElementName;
import org.cip4.jdflib.resource.intent.JDFIntentResource;
import org.cip4.jdflib.span.JDFIntegerSpan;
import org.cip4.jdflib.span.JDFXYPairSpan;
import org.cip4.jdflib.util.JavaEnumUtil;

/**
 ***************************************************************************** class JDFAutoSizeIntent : public JDFIntentResource
 */

public abstract class JDFAutoSizeIntent extends JDFIntentResource
{

	private static final long serialVersionUID = 1L;

	private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[1];
	static
	{
		atrInfoTable[0] = new AtrInfoTable(AttributeName.TYPE, 0x4444444443l, AttributeInfo.EnumAttributeType.enumeration, EnumType.getEnum(0), "Folded");
	}

	@Override
	protected AttributeInfo getTheAttributeInfo()
	{
		return super.getTheAttributeInfo().updateReplace(atrInfoTable);
	}

	private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[2];
	static
	{
		elemInfoTable[0] = new ElemInfoTable(ElementName.DIMENSIONS, 0x7777777775l);
		elemInfoTable[1] = new ElemInfoTable(ElementName.PAGES, 0x7777777776l);
	}

	@Override
	protected ElementInfo getTheElementInfo()
	{
		return super.getTheElementInfo().updateReplace(elemInfoTable);
	}

	/**
	 * Constructor for JDFAutoSizeIntent
	 *
	 * @param myOwnerDocument
	 * @param qualifiedName
	 */
	protected JDFAutoSizeIntent(CoreDocumentImpl myOwnerDocument, String qualifiedName)
	{
		super(myOwnerDocument, qualifiedName);
	}

	/**
	 * Constructor for JDFAutoSizeIntent
	 *
	 * @param myOwnerDocument
	 * @param myNamespaceURI
	 * @param qualifiedName
	 */
	protected JDFAutoSizeIntent(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName)
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName);
	}

	/**
	 * Constructor for JDFAutoSizeIntent
	 *
	 * @param myOwnerDocument
	 * @param myNamespaceURI
	 * @param qualifiedName
	 * @param myLocalName
	 */
	protected JDFAutoSizeIntent(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName)
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
	}

	/**
	 * Enumeration strings for Type
	 */

	public enum EType
	{
		Folded, Flat;

		public static EType getEnum(String val)
		{
			return JavaEnumUtil.getEnumIgnoreCase(EType.class, val, EType.Folded);
		}
	}

	/**
	 * Enumeration strings for Type
	 */

	@SuppressWarnings("rawtypes")
	public static class EnumType extends ValuedEnum
	{
		private static final long serialVersionUID = 1L;
		private static int m_startValue = 0;

		protected EnumType(String name)
		{
			super(name, m_startValue++);
		}

		/**
		 * @param enumName the string to convert
		 * @return the enum
		 */
		public static EnumType getEnum(String enumName)
		{
			return (EnumType) getEnum(EnumType.class, enumName);
		}

		/**
		 * @param enumValue the integer to convert
		 * @return the enum
		 */
		public static EnumType getEnum(int enumValue)
		{
			return (EnumType) getEnum(EnumType.class, enumValue);
		}

		/**
		 * @return the map of enums
		 */
		public static Map getEnumMap()
		{
			return getEnumMap(EnumType.class);
		}

		/**
		 * @return the list of enums
		 */
		public static List getEnumList()
		{
			return getEnumList(EnumType.class);
		}

		/**
		 * @return the iterator
		 */
		public static Iterator iterator()
		{
			return iterator(EnumType.class);
		}

		/**  */
		public static final EnumType Folded = new EnumType("Folded");
		/**  */
		public static final EnumType Flat = new EnumType("Flat");
	}

	/*
	 * ************************************************************************
	 * Attribute getter / setter
	 * ************************************************************************
	 */

	/*
	 * ---------------------------------------------------------------------
	 * Methods for Attribute Type
	 * ---------------------------------------------------------------------
	 */
	/**
	 * (5) set attribute Type
	 *
	 * @param enumVar the enumVar to set the attribute to
	 */
	public void setType(EType enumVar)
	{
		setAttribute(AttributeName.TYPE, enumVar == null ? null : enumVar.name(), null);
	}

	/**
	 * (9) get attribute Type
	 *
	 * @return the value of the attribute
	 */
	public EType getEType()
	{
		return EType.getEnum(getAttribute(AttributeName.TYPE, null, "Folded"));
	}

	/*
	 * ---------------------------------------------------------------------
	 * Methods for Attribute Type
	 * ---------------------------------------------------------------------
	 */
	/**
	 * (5) set attribute Type
	 *
	 * @param enumVar the enumVar to set the attribute to
	 * @deprecated use SetType(EType) based on java.lang.enum instead
	 */
	@Deprecated
	public void setType(EnumType enumVar)
	{
		setAttribute(AttributeName.TYPE, enumVar == null ? null : enumVar.getName(), null);
	}

	/**
	 * (9) get attribute Type
	 *
	 * @return the value of the attribute
	 * @deprecated use EType GetEType() based on java.lang.enum instead
	 */
	@Deprecated
	public EnumType getType()
	{
		return EnumType.getEnum(getAttribute(AttributeName.TYPE, null, "Folded"));
	}

	/*
	 * ***********************************************************************
	 * Element getter / setter
	 * ***********************************************************************
	 */

	/**
	 * (24) const get element Dimensions
	 *
	 * @return JDFXYPairSpan the element
	 */
	public JDFXYPairSpan getDimensions()
	{
		return (JDFXYPairSpan) getElement(ElementName.DIMENSIONS, null, 0);
	}

	/**
	 * (25) getCreateDimensions
	 * 
	 * @return JDFXYPairSpan the element
	 */
	public JDFXYPairSpan getCreateDimensions()
	{
		return (JDFXYPairSpan) getCreateElement_JDFElement(ElementName.DIMENSIONS, null, 0);
	}

	/**
	 * (29) append element Dimensions
	 *
	 * @return JDFXYPairSpan the element
	 * @ if the element already exists
	 */
	public JDFXYPairSpan appendDimensions()
	{
		return (JDFXYPairSpan) appendElementN(ElementName.DIMENSIONS, 1, null);
	}

	/**
	 * (24) const get element Pages
	 *
	 * @return JDFIntegerSpan the element
	 */
	public JDFIntegerSpan getPages()
	{
		return (JDFIntegerSpan) getElement(ElementName.PAGES, null, 0);
	}

	/**
	 * (25) getCreatePages
	 * 
	 * @return JDFIntegerSpan the element
	 */
	public JDFIntegerSpan getCreatePages()
	{
		return (JDFIntegerSpan) getCreateElement_JDFElement(ElementName.PAGES, null, 0);
	}

	/**
	 * (29) append element Pages
	 *
	 * @return JDFIntegerSpan the element
	 * @ if the element already exists
	 */
	public JDFIntegerSpan appendPages()
	{
		return (JDFIntegerSpan) appendElementN(ElementName.PAGES, 1, null);
	}

}
