/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFCompany;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.resource.process.JDFDrop;
import org.cip4.jdflib.resource.process.JDFFileSpec;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JDFDuration;
import org.cip4.jdflib.util.JavaEnumUtil;

public abstract class JDFAutoDeliveryParams
extends JDFResource {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[9];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoDeliveryParams(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoDeliveryParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoDeliveryParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public boolean init() {
        boolean bRet = super.init();
        this.setResourceClass(JDFResource.EnumResourceClass.Parameter);
        return bRet;
    }

    @Override
    public JDFResource.EnumResourceClass getValidClass() {
        return JDFResource.EnumResourceClass.Parameter;
    }

    public void setDeliveryID(String value) {
        this.setAttribute("DeliveryID", value, null);
    }

    public String getDeliveryID() {
        return this.getAttribute("DeliveryID", null, "");
    }

    public void setEarliest(JDFDate value) {
        JDFDate date = value;
        if (date == null) {
            date = new JDFDate();
        }
        this.setAttribute("Earliest", date.getDateTimeISO(), null);
    }

    public JDFDate getEarliest() {
        String str = this.getAttribute("Earliest", null, null);
        JDFDate ret = JDFDate.createDate(str);
        return ret;
    }

    public void setEarliestDuration(JDFDuration value) {
        this.setAttribute("EarliestDuration", value, null);
    }

    public JDFDuration getEarliestDuration() {
        String strAttrName = this.getAttribute("EarliestDuration", null, null);
        JDFDuration nPlaceHolder = JDFDuration.createDuration(strAttrName);
        return nPlaceHolder;
    }

    public void setMethod(String value) {
        this.setAttribute("Method", value, null);
    }

    public String getMethod() {
        return this.getAttribute("Method", null, "");
    }

    public void setPickup(boolean value) {
        this.setAttribute("Pickup", value, null);
    }

    public boolean getPickup() {
        return this.getBoolAttribute("Pickup", null, false);
    }

    public void setRequired(JDFDate value) {
        JDFDate date = value;
        if (date == null) {
            date = new JDFDate();
        }
        this.setAttribute("Required", date.getDateTimeISO(), null);
    }

    public JDFDate getRequired() {
        String str = this.getAttribute("Required", null, null);
        JDFDate ret = JDFDate.createDate(str);
        return ret;
    }

    public void setRequiredDuration(JDFDuration value) {
        this.setAttribute("RequiredDuration", value, null);
    }

    public JDFDuration getRequiredDuration() {
        String strAttrName = this.getAttribute("RequiredDuration", null, null);
        JDFDuration nPlaceHolder = JDFDuration.createDuration(strAttrName);
        return nPlaceHolder;
    }

    public void setServiceLevel(String value) {
        this.setAttribute("ServiceLevel", value, null);
    }

    public String getServiceLevel() {
        return this.getAttribute("ServiceLevel", null, "");
    }

    public void setTransfer(ETransfer enumVar) {
        this.setAttribute("Transfer", enumVar == null ? null : enumVar.name(), null);
    }

    public ETransfer getETransfer() {
        return ETransfer.getEnum(this.getAttribute("Transfer", null, null));
    }

    @Deprecated
    public void setTransfer(EnumTransfer enumVar) {
        this.setAttribute("Transfer", enumVar == null ? null : enumVar.getName(), null);
    }

    @Deprecated
    public EnumTransfer getTransfer() {
        return EnumTransfer.getEnum(this.getAttribute("Transfer", null, null));
    }

    public JDFCompany getCompany() {
        return (JDFCompany)this.getElement("Company", null, 0);
    }

    public JDFCompany getCreateCompany() {
        return (JDFCompany)this.getCreateElement_JDFElement("Company", null, 0);
    }

    public JDFCompany appendCompany() {
        return (JDFCompany)this.appendElementN("Company", 1, null);
    }

    public void refCompany(JDFCompany refTarget) {
        this.refElement(refTarget);
    }

    @Override
    public JDFContact getContact() {
        return (JDFContact)this.getElement("Contact", null, 0);
    }

    @Override
    public JDFContact getCreateContact() {
        return (JDFContact)this.getCreateElement_JDFElement("Contact", null, 0);
    }

    public JDFContact getCreateContact(int iSkip) {
        return (JDFContact)this.getCreateElement_JDFElement("Contact", null, iSkip);
    }

    public JDFContact getContact(int iSkip) {
        return (JDFContact)this.getElement("Contact", null, iSkip);
    }

    public Collection<JDFContact> getAllContact() {
        return this.getChildArrayByClass(JDFContact.class, false, 0);
    }

    @Override
    public JDFContact appendContact() {
        return (JDFContact)this.appendElement("Contact", null);
    }

    public void refContact(JDFContact refTarget) {
        this.refElement(refTarget);
    }

    public JDFDrop getDrop() {
        return (JDFDrop)this.getElement("Drop", null, 0);
    }

    public JDFDrop getCreateDrop() {
        return (JDFDrop)this.getCreateElement_JDFElement("Drop", null, 0);
    }

    public JDFDrop getCreateDrop(int iSkip) {
        return (JDFDrop)this.getCreateElement_JDFElement("Drop", null, iSkip);
    }

    public JDFDrop getDrop(int iSkip) {
        return (JDFDrop)this.getElement("Drop", null, iSkip);
    }

    public Collection<JDFDrop> getAllDrop() {
        return this.getChildArrayByClass(JDFDrop.class, false, 0);
    }

    public JDFDrop appendDrop() {
        return (JDFDrop)this.appendElement("Drop", null);
    }

    public JDFFileSpec getFileSpec() {
        return (JDFFileSpec)this.getElement("FileSpec", null, 0);
    }

    public JDFFileSpec getCreateFileSpec() {
        return (JDFFileSpec)this.getCreateElement_JDFElement("FileSpec", null, 0);
    }

    public JDFFileSpec getCreateFileSpec(int iSkip) {
        return (JDFFileSpec)this.getCreateElement_JDFElement("FileSpec", null, iSkip);
    }

    public JDFFileSpec getFileSpec(int iSkip) {
        return (JDFFileSpec)this.getElement("FileSpec", null, iSkip);
    }

    public Collection<JDFFileSpec> getAllFileSpec() {
        return this.getChildArrayByClass(JDFFileSpec.class, false, 0);
    }

    public JDFFileSpec appendFileSpec() {
        return (JDFFileSpec)this.appendElement("FileSpec", null);
    }

    public void refFileSpec(JDFFileSpec refTarget) {
        this.refElement(refTarget);
    }

    static {
        JDFAutoDeliveryParams.atrInfoTable[0] = new AtrInfoTable("DeliveryID", 0x3333111111L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoDeliveryParams.atrInfoTable[1] = new AtrInfoTable("Earliest", 0x3333333333L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFAutoDeliveryParams.atrInfoTable[2] = new AtrInfoTable("EarliestDuration", 0x3333333333L, AttributeInfo.EnumAttributeType.duration, null, null);
        JDFAutoDeliveryParams.atrInfoTable[3] = new AtrInfoTable("Method", 0x3333333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoDeliveryParams.atrInfoTable[4] = new AtrInfoTable("Pickup", 0x4444444433L, AttributeInfo.EnumAttributeType.boolean_, null, null);
        JDFAutoDeliveryParams.atrInfoTable[5] = new AtrInfoTable("Required", 0x3333333333L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFAutoDeliveryParams.atrInfoTable[6] = new AtrInfoTable("RequiredDuration", 0x3333333333L, AttributeInfo.EnumAttributeType.duration, null, null);
        JDFAutoDeliveryParams.atrInfoTable[7] = new AtrInfoTable("ServiceLevel", 0x3333333311L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoDeliveryParams.atrInfoTable[8] = new AtrInfoTable("Transfer", 0x3333333311L, AttributeInfo.EnumAttributeType.enumeration, EnumTransfer.getEnum(0), null);
        elemInfoTable = new ElemInfoTable[4];
        JDFAutoDeliveryParams.elemInfoTable[0] = new ElemInfoTable("Company", 0x7777777776L);
        JDFAutoDeliveryParams.elemInfoTable[1] = new ElemInfoTable("Contact", 0x3333333331L);
        JDFAutoDeliveryParams.elemInfoTable[2] = new ElemInfoTable("Drop", 0x2222222222L);
        JDFAutoDeliveryParams.elemInfoTable[3] = new ElemInfoTable("FileSpec", 0x3333111111L);
    }

    public static enum ETransfer {
        BuyerToPrinterDeliver,
        BuyerToPrinterPickup,
        PrinterToBuyerDeliver,
        PrinterToBuyerPickup;


        public static ETransfer getEnum(String val) {
            return JavaEnumUtil.getEnumIgnoreCase(ETransfer.class, val, null);
        }
    }

    public static class EnumTransfer
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumTransfer BuyerToPrinterDeliver = new EnumTransfer("BuyerToPrinterDeliver");
        public static final EnumTransfer BuyerToPrinterPickup = new EnumTransfer("BuyerToPrinterPickup");
        public static final EnumTransfer PrinterToBuyerDeliver = new EnumTransfer("PrinterToBuyerDeliver");
        public static final EnumTransfer PrinterToBuyerPickup = new EnumTransfer("PrinterToBuyerPickup");

        protected EnumTransfer(String name) {
            super(name, m_startValue++);
        }

        public static EnumTransfer getEnum(String enumName) {
            return (EnumTransfer)EnumTransfer.getEnum(EnumTransfer.class, enumName);
        }

        public static EnumTransfer getEnum(int enumValue) {
            return (EnumTransfer)EnumTransfer.getEnum(EnumTransfer.class, enumValue);
        }

        public static Map getEnumMap() {
            return EnumTransfer.getEnumMap(EnumTransfer.class);
        }

        public static List getEnumList() {
            return EnumTransfer.getEnumList(EnumTransfer.class);
        }

        public static Iterator iterator() {
            return EnumTransfer.iterator(EnumTransfer.class);
        }
    }
}

