/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.datatypes.JDFLabColor;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFRGBColor;
import org.cip4.jdflib.datatypes.JDFTransferFunction;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.resource.JDFSeparationTint;
import org.cip4.jdflib.util.JavaEnumUtil;

public abstract class JDFAutoPatch
extends JDFElement {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[9];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoPatch(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoPatch(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoPatch(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    public void setCenter(JDFXYPair value) {
        this.setAttribute("Center", (JDFNumList)value, (String)null);
    }

    public JDFXYPair getCenter() {
        String strAttrName = this.getAttribute("Center", null, null);
        JDFXYPair nPlaceHolder = JDFXYPair.createXYPair(strAttrName);
        return nPlaceHolder;
    }

    public void setDensity(double value) {
        this.setAttribute("Density", value, null);
    }

    public double getDensity() {
        return this.getRealAttribute("Density", null, 0.0);
    }

    public void setLab(JDFLabColor value) {
        this.setAttribute("Lab", (JDFNumList)value, (String)null);
    }

    public JDFLabColor getLab() {
        String strAttrName = this.getAttribute("Lab", null, null);
        JDFLabColor nPlaceHolder = JDFLabColor.createLabColor(strAttrName);
        return nPlaceHolder;
    }

    public void setNeutralDensity(double value) {
        this.setAttribute("NeutralDensity", value, null);
    }

    public double getNeutralDensity() {
        return this.getRealAttribute("NeutralDensity", null, 0.0);
    }

    public void setPatchUsage(EPatchUsage enumVar) {
        this.setAttribute("PatchUsage", enumVar == null ? null : enumVar.name(), null);
    }

    public EPatchUsage getEPatchUsage() {
        return EPatchUsage.getEnum(this.getAttribute("PatchUsage", null, null));
    }

    @Deprecated
    public void setPatchUsage(EnumPatchUsage enumVar) {
        this.setAttribute("PatchUsage", enumVar == null ? null : enumVar.getName(), null);
    }

    @Deprecated
    public EnumPatchUsage getPatchUsage() {
        return EnumPatchUsage.getEnum(this.getAttribute("PatchUsage", null, null));
    }

    public void setRGB(JDFRGBColor value) {
        this.setAttribute("RGB", (JDFNumList)value, (String)null);
    }

    public JDFRGBColor getRGB() {
        String strAttrName = this.getAttribute("RGB", null, null);
        JDFRGBColor nPlaceHolder = JDFRGBColor.createRGBColor(strAttrName);
        return nPlaceHolder;
    }

    public void setSize(JDFXYPair value) {
        this.setAttribute("Size", (JDFNumList)value, (String)null);
    }

    public JDFXYPair getSize() {
        String strAttrName = this.getAttribute("Size", null, null);
        JDFXYPair nPlaceHolder = JDFXYPair.createXYPair(strAttrName);
        return nPlaceHolder;
    }

    public void setSpectrum(JDFTransferFunction value) {
        this.setAttribute("Spectrum", (JDFNumList)value, (String)null);
    }

    public JDFTransferFunction getSpectrum() {
        String strAttrName = this.getAttribute("Spectrum", null, null);
        JDFTransferFunction nPlaceHolder = JDFTransferFunction.createTransferFunction(strAttrName);
        return nPlaceHolder;
    }

    public void setSpotType(ESpotType enumVar) {
        this.setAttribute("SpotType", enumVar == null ? null : enumVar.name(), null);
    }

    public ESpotType getESpotType() {
        return ESpotType.getEnum(this.getAttribute("SpotType", null, null));
    }

    @Deprecated
    public void setSpotType(EnumSpotType enumVar) {
        this.setAttribute("SpotType", enumVar == null ? null : enumVar.getName(), null);
    }

    @Deprecated
    public EnumSpotType getSpotType() {
        return EnumSpotType.getEnum(this.getAttribute("SpotType", null, null));
    }

    public JDFSeparationTint getSeparationTint() {
        return (JDFSeparationTint)this.getElement("SeparationTint", null, 0);
    }

    public JDFSeparationTint getCreateSeparationTint() {
        return (JDFSeparationTint)this.getCreateElement_JDFElement("SeparationTint", null, 0);
    }

    public JDFSeparationTint getCreateSeparationTint(int iSkip) {
        return (JDFSeparationTint)this.getCreateElement_JDFElement("SeparationTint", null, iSkip);
    }

    public JDFSeparationTint getSeparationTint(int iSkip) {
        return (JDFSeparationTint)this.getElement("SeparationTint", null, iSkip);
    }

    public Collection<JDFSeparationTint> getAllSeparationTint() {
        return this.getChildArrayByClass(JDFSeparationTint.class, false, 0);
    }

    public JDFSeparationTint appendSeparationTint() {
        return (JDFSeparationTint)this.appendElement("SeparationTint", null);
    }

    static {
        JDFAutoPatch.atrInfoTable[0] = new AtrInfoTable("Center", 0x3331111111L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFAutoPatch.atrInfoTable[1] = new AtrInfoTable("Density", 0x3331111111L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoPatch.atrInfoTable[2] = new AtrInfoTable("Lab", 0x3331111111L, AttributeInfo.EnumAttributeType.LabColor, null, null);
        JDFAutoPatch.atrInfoTable[3] = new AtrInfoTable("NeutralDensity", 0x3331111111L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoPatch.atrInfoTable[4] = new AtrInfoTable("PatchUsage", 0x2221111111L, AttributeInfo.EnumAttributeType.enumeration, EnumPatchUsage.getEnum(0), null);
        JDFAutoPatch.atrInfoTable[5] = new AtrInfoTable("RGB", 0x3331111111L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoPatch.atrInfoTable[6] = new AtrInfoTable("Size", 0x3331111111L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFAutoPatch.atrInfoTable[7] = new AtrInfoTable("Spectrum", 0x3331111111L, AttributeInfo.EnumAttributeType.TransferFunction, null, null);
        JDFAutoPatch.atrInfoTable[8] = new AtrInfoTable("SpotType", 0x3311111111L, AttributeInfo.EnumAttributeType.enumeration, EnumSpotType.getEnum(0), null);
        elemInfoTable = new ElemInfoTable[1];
        JDFAutoPatch.elemInfoTable[0] = new ElemInfoTable("SeparationTint", 0x3331111111L);
    }

    public static enum EPatchUsage {
        Color,
        Image,
        Technical,
        Ignore;


        public static EPatchUsage getEnum(String val) {
            return JavaEnumUtil.getEnumIgnoreCase(EPatchUsage.class, val, null);
        }
    }

    public static class EnumPatchUsage
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumPatchUsage Color = new EnumPatchUsage("Color");
        public static final EnumPatchUsage Image = new EnumPatchUsage("Image");
        public static final EnumPatchUsage Technical = new EnumPatchUsage("Technical");
        public static final EnumPatchUsage Ignore = new EnumPatchUsage("Ignore");

        protected EnumPatchUsage(String name) {
            super(name, m_startValue++);
        }

        public static EnumPatchUsage getEnum(String enumName) {
            return (EnumPatchUsage)EnumPatchUsage.getEnum(EnumPatchUsage.class, enumName);
        }

        public static EnumPatchUsage getEnum(int enumValue) {
            return (EnumPatchUsage)EnumPatchUsage.getEnum(EnumPatchUsage.class, enumValue);
        }

        public static Map getEnumMap() {
            return EnumPatchUsage.getEnumMap(EnumPatchUsage.class);
        }

        public static List getEnumList() {
            return EnumPatchUsage.getEnumList(EnumPatchUsage.class);
        }

        public static Iterator iterator() {
            return EnumPatchUsage.iterator(EnumPatchUsage.class);
        }
    }

    public static enum ESpotType {
        Emulated,
        Spot;


        public static ESpotType getEnum(String val) {
            return JavaEnumUtil.getEnumIgnoreCase(ESpotType.class, val, null);
        }
    }

    public static class EnumSpotType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumSpotType Emulated = new EnumSpotType("Emulated");
        public static final EnumSpotType Spot = new EnumSpotType("Spot");

        protected EnumSpotType(String name) {
            super(name, m_startValue++);
        }

        public static EnumSpotType getEnum(String enumName) {
            return (EnumSpotType)EnumSpotType.getEnum(EnumSpotType.class, enumName);
        }

        public static EnumSpotType getEnum(int enumValue) {
            return (EnumSpotType)EnumSpotType.getEnum(EnumSpotType.class, enumValue);
        }

        public static Map getEnumMap() {
            return EnumSpotType.getEnumMap(EnumSpotType.class);
        }

        public static List getEnumList() {
            return EnumSpotType.getEnumList(EnumSpotType.class);
        }

        public static Iterator iterator() {
            return EnumSpotType.iterator(EnumSpotType.class);
        }
    }
}

