/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFNumberList;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.JavaEnumUtil;

public abstract class JDFAutoThreadSealingParams
extends JDFResource {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[6];

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    protected JDFAutoThreadSealingParams(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoThreadSealingParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoThreadSealingParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public boolean init() {
        boolean bRet = super.init();
        this.setResourceClass(JDFResource.EnumResourceClass.Parameter);
        return bRet;
    }

    @Override
    public JDFResource.EnumResourceClass getValidClass() {
        return JDFResource.EnumResourceClass.Parameter;
    }

    public void setBlindStitch(boolean value) {
        this.setAttribute("BlindStitch", value, null);
    }

    public boolean getBlindStitch() {
        return this.getBoolAttribute("BlindStitch", null, false);
    }

    public void setThreadMaterial(EThreadMaterial enumVar) {
        this.setAttribute("ThreadMaterial", enumVar == null ? null : enumVar.name(), null);
    }

    public EThreadMaterial getEThreadMaterial() {
        return EThreadMaterial.getEnum(this.getAttribute("ThreadMaterial", null, null));
    }

    @Deprecated
    public void setThreadMaterial(EnumThreadMaterial enumVar) {
        this.setAttribute("ThreadMaterial", enumVar == null ? null : enumVar.getName(), null);
    }

    @Deprecated
    public EnumThreadMaterial getThreadMaterial() {
        return EnumThreadMaterial.getEnum(this.getAttribute("ThreadMaterial", null, null));
    }

    public void setThreadPositions(JDFNumberList value) {
        this.setAttribute("ThreadPositions", (JDFNumList)value, (String)null);
    }

    public JDFNumberList getThreadPositions() {
        String strAttrName = this.getAttribute("ThreadPositions", null, null);
        JDFNumberList nPlaceHolder = JDFNumberList.createNumberList(strAttrName);
        return nPlaceHolder;
    }

    public void setThreadLength(double value) {
        this.setAttribute("ThreadLength", value, null);
    }

    public double getThreadLength() {
        return this.getRealAttribute("ThreadLength", null, 0.0);
    }

    public void setThreadStitchWidth(double value) {
        this.setAttribute("ThreadStitchWidth", value, null);
    }

    public double getThreadStitchWidth() {
        return this.getRealAttribute("ThreadStitchWidth", null, 0.0);
    }

    public void setSealingTemperature(int value) {
        this.setAttribute("SealingTemperature", value, (String)null);
    }

    public int getSealingTemperature() {
        return this.getIntAttribute("SealingTemperature", null, 0);
    }

    static {
        JDFAutoThreadSealingParams.atrInfoTable[0] = new AtrInfoTable("BlindStitch", 0x3333333331L, AttributeInfo.EnumAttributeType.boolean_, null, null);
        JDFAutoThreadSealingParams.atrInfoTable[1] = new AtrInfoTable("ThreadMaterial", 0x3333333331L, AttributeInfo.EnumAttributeType.enumeration, EnumThreadMaterial.getEnum(0), null);
        JDFAutoThreadSealingParams.atrInfoTable[2] = new AtrInfoTable("ThreadPositions", 0x3333333331L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoThreadSealingParams.atrInfoTable[3] = new AtrInfoTable("ThreadLength", 0x3333333331L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoThreadSealingParams.atrInfoTable[4] = new AtrInfoTable("ThreadStitchWidth", 0x3333333331L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoThreadSealingParams.atrInfoTable[5] = new AtrInfoTable("SealingTemperature", 0x4444333331L, AttributeInfo.EnumAttributeType.integer, null, null);
    }

    public static enum EThreadMaterial {
        Cotton,
        Nylon,
        Polyester;


        public static EThreadMaterial getEnum(String val) {
            return JavaEnumUtil.getEnumIgnoreCase(EThreadMaterial.class, val, null);
        }
    }

    public static class EnumThreadMaterial
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumThreadMaterial Cotton = new EnumThreadMaterial("Cotton");
        public static final EnumThreadMaterial Nylon = new EnumThreadMaterial("Nylon");
        public static final EnumThreadMaterial Polyester = new EnumThreadMaterial("Polyester");

        protected EnumThreadMaterial(String name) {
            super(name, m_startValue++);
        }

        public static EnumThreadMaterial getEnum(String enumName) {
            return (EnumThreadMaterial)EnumThreadMaterial.getEnum(EnumThreadMaterial.class, enumName);
        }

        public static EnumThreadMaterial getEnum(int enumValue) {
            return (EnumThreadMaterial)EnumThreadMaterial.getEnum(EnumThreadMaterial.class, enumValue);
        }

        public static Map getEnumMap() {
            return EnumThreadMaterial.getEnumMap(EnumThreadMaterial.class);
        }

        public static List getEnumList() {
            return EnumThreadMaterial.getEnumList(EnumThreadMaterial.class);
        }

        public static Iterator iterator() {
            return EnumThreadMaterial.iterator(EnumThreadMaterial.class);
        }
    }
}

