/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.cformat;

import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.StringUtil;

@Deprecated
public class PrintfFormat {
    private static char[] ddigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static char[] xdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static char[] Xdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    boolean addBlank = false;
    boolean addSign = false;
    boolean alternate = false;
    boolean leftAdjust = false;
    int prec = -1;
    String prefix = null;
    String suffix = null;
    char type = '\u0000';
    int width = 0;
    boolean zeropad = false;
    private DecDouble dd;
    private int idx;
    private final OutBuffer output = new OutBuffer(1024);
    private final String validTypes = "diouxXeEfFgGaAcs";

    public PrintfFormat(String fmt) throws IllegalArgumentException {
        this.set(fmt);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void set(String fmt) throws IllegalArgumentException {
        char[] buf = new char[fmt.length()];
        this.prefix = "";
        this.suffix = "";
        this.idx = 0;
        int n = this.scanRegularChars(buf, fmt);
        if (n > 0) {
            this.prefix = new String(buf, 0, n);
        }
        if (this.idx == fmt.length()) {
            return;
        }
        boolean parsingFlags = true;
        do {
            char c = fmt.charAt(this.idx);
            switch (c) {
                case '+': {
                    this.addSign = true;
                    break;
                }
                case ' ': {
                    this.addBlank = true;
                    break;
                }
                case '-': {
                    this.leftAdjust = true;
                    break;
                }
                case '#': {
                    this.alternate = true;
                    break;
                }
                case '0': {
                    this.zeropad = true;
                    break;
                }
                default: {
                    parsingFlags = false;
                }
            }
            if (!parsingFlags || ++this.idx != fmt.length()) continue;
            parsingFlags = false;
        } while (parsingFlags);
        if (this.idx < fmt.length() && Character.isDigit(fmt.charAt(this.idx))) {
            this.width = this.scanUnsignedInt(fmt);
        }
        if (this.idx < fmt.length() && fmt.charAt(this.idx) == '.') {
            if (++this.idx < fmt.length() && Character.isDigit(fmt.charAt(this.idx))) {
                this.prec = this.scanUnsignedInt(fmt);
            } else {
                throw new IllegalArgumentException("'.' in conversion spec not followed by precision value");
            }
        }
        if (this.idx == fmt.length()) {
            throw new IllegalArgumentException("Format string ends prematurely");
        }
        this.type = fmt.charAt(this.idx++);
        switch (this.type) {
            case 'X': 
            case 'd': 
            case 'i': 
            case 'o': 
            case 'u': 
            case 'x': {
                if (this.prec == -1 || !this.zeropad) break;
                this.zeropad = false;
                break;
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                break;
            }
            case 'c': {
                break;
            }
            case 's': {
                break;
            }
            default: {
                if ("diouxXeEfFgGaAcs".indexOf(this.type) != -1) break;
                throw new IllegalArgumentException("Conversion character '" + this.type + "' not one of 'diouxXeEfFgGaAcs'");
            }
        }
        if ((n = this.scanRegularChars(buf, fmt)) > 0) {
            this.suffix = new String(buf, 0, n);
        }
        if (this.idx != fmt.length()) {
            throw new IllegalArgumentException("Format string has more than one conversion spec");
        }
        if (this.leftAdjust && this.zeropad) {
            this.zeropad = false;
        }
        if (this.addSign && this.addBlank) {
            this.addBlank = false;
        }
    }

    public String setPrefix(String s) {
        String old = this.prefix;
        this.prefix = s;
        return old;
    }

    public String setSuffix(String s) {
        String old = this.suffix;
        this.suffix = s;
        return old;
    }

    public String tostr(float x) {
        return this.tostr((double)x);
    }

    public String tostr(Double x) {
        return this.tostr((double)x);
    }

    public String tostr(Integer x) {
        return this.tostr((int)x);
    }

    public String tostr(double x) {
        if ("diuoxX".indexOf(this.type) > -1) {
            return this.tostr((long)x);
        }
        if (this.dd == null) {
            this.dd = new DecDouble();
        }
        if (this.type != 'a' && this.type != 'A') {
            this.dd.set(x);
        } else {
            this.dd.setSignAndAlt(x);
        }
        char p = '\u0000';
        this.output.init(this.width + 1);
        if (this.dd.alt != null) {
            this.output.append(this.dd.alt);
        } else if (this.type == 'f') {
            this.fixedFormat(this.dd, this.prec < 0 ? 6 : this.prec);
        } else if (this.type == 'e' || this.type == 'E') {
            this.expFormat(this.dd, this.prec < 0 ? 6 : this.prec);
        } else if (this.type == 'a' || this.type == 'A') {
            this.expHexFormat(x, this.prec);
        } else if (this.type == 'g' || this.type == 'G') {
            this.freeFormat(this.dd, this.prec < 0 ? 6 : this.prec);
        } else {
            LogFactory.getLog(this.getClass()).error((Object)("f = " + this.type));
            throw new IllegalArgumentException();
        }
        if (this.dd.sign == -1) {
            p = '-';
        } else if (this.addSign) {
            p = '+';
        } else if (this.addBlank) {
            p = ' ';
        }
        if (this.zeropad) {
            int nz = this.width - (this.output.kn - this.output.k0);
            if (p != '\u0000') {
                --nz;
            }
            this.output.prepend('0', nz);
        }
        if (p != '\u0000') {
            this.output.prepend(p);
        }
        return this.pad();
    }

    public String tostr(int x) {
        long lx = x;
        String intStr = this.type == 'd' || this.type == 'i' ? this.tostr(lx) : this.tostr(lx & 0xFFFFFFFFL);
        return intStr;
    }

    public String tostr(long x) {
        long xLocal = x;
        String p = null;
        this.output.init(Math.max(this.width, 32));
        if (this.type == 'd' || this.type == 'i') {
            if (xLocal < 0L) {
                xLocal = -xLocal;
                p = "-";
            } else if (this.addSign) {
                p = "+";
            } else if (this.addBlank) {
                p = " ";
            }
            if (this.prec != 0 || xLocal != 0L) {
                this.output.append(Long.toString(xLocal));
            }
        } else if (this.type == 'u') {
            this.uconv(xLocal, 10, ddigits);
        } else if (this.type == 'o') {
            this.uconv(xLocal, 8, ddigits);
            if (this.alternate && this.output.buf[this.output.k0] != '0') {
                p = "0";
            }
        } else if (this.type == 'x') {
            this.uconv(xLocal, 16, xdigits);
            if (this.alternate) {
                p = "0x";
            }
        } else if (this.type == 'X') {
            this.uconv(xLocal, 16, Xdigits);
            if (this.alternate) {
                p = "0X";
            }
        } else {
            throw new IllegalArgumentException();
        }
        int nz = 0;
        if (this.zeropad) {
            nz = this.width - (this.output.kn - this.output.k0);
        } else if (this.prec > 0) {
            nz = this.prec - (this.output.kn - this.output.k0);
        }
        if (nz > 0) {
            if (p != null) {
                nz -= p.length();
            }
            this.output.prepend('0', nz);
        }
        if (p != null) {
            this.output.prepend(p);
        }
        return this.pad();
    }

    public String tostr(char x) {
        if (this.type != 'c') {
            throw new IllegalArgumentException();
        }
        this.output.init(Math.max(this.width, 1));
        this.output.append(String.valueOf(x));
        return this.pad();
    }

    public String tostr(String x) {
        if (this.type != 's') {
            if (StringUtil.isInteger(x)) {
                return this.tostr(StringUtil.parseInt(x, 0));
            }
            if (StringUtil.isNumber(x)) {
                return this.tostr(StringUtil.parseDouble(x, 0.0));
            }
            throw new IllegalArgumentException();
        }
        this.output.init(Math.max(this.width, 1));
        if (this.prec >= 0) {
            this.output.append(x.substring(0, this.prec));
        } else {
            this.output.append(x);
        }
        return this.pad();
    }

    private void expFormat(DecDouble pdd, int p) {
        int i = 0;
        this.output.append(pdd.digits[i++]);
        if (p > 0 || this.alternate) {
            this.output.append('.');
        }
        if (p > 0) {
            int kend = p + this.output.k0 + 2;
            while (i < pdd.numd && this.output.kn < kend) {
                this.output.append(pdd.digits[i++]);
            }
            if (i == pdd.numd && this.output.kn < kend && (this.type != 'g' && this.type != 'G' || this.alternate)) {
                this.output.append('0', kend - this.output.kn);
            }
        }
        if (i < pdd.numd && pdd.digits[i] >= '5') {
            this.roundUpFixedOutput(this.output);
            if (this.output.buf[this.output.k0 + 1] == '0') {
                this.output.buf[this.output.k0 + 1] = 46;
                this.output.buf[this.output.k0 + 2] = 48;
                ++pdd.exp;
                --this.output.kn;
            }
        }
        this.output.append((char)(this.type == 'G' || this.type == 'E' ? 69 : 101));
        this.output.append(pdd.exp >= 0 ? (char)'+' : '-');
        String expStr = Long.toString(Math.abs(pdd.exp));
        if (expStr.length() < 2) {
            this.output.append('0');
        }
        this.output.append(expStr);
    }

    private void expHexFormat(double d, int p) {
        long m;
        int pLocal = p;
        char[] digits = null;
        long bits = Double.doubleToLongBits(d);
        int e = (int)(bits >> 52 & 0x7FFL);
        long l = m = e == 0 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        e = m == 0L ? 0 : (e -= 1023);
        if (m != 0L) {
            while ((m & 0x10000000000000L) == 0L) {
                m <<= 1;
                --e;
            }
        }
        if (pLocal > 0 && pLocal < 13 && (0xFL & m >> 4 * (12 - pLocal)) >= 8L && ((m += 1L << 4 * (13 - pLocal)) & 0x20000000000000L) != 0L) {
            m >>= 1;
            ++e;
        }
        this.output.append('0');
        if (this.type == 'A') {
            this.output.append('X');
            digits = Xdigits;
        } else {
            this.output.append('x');
            digits = xdigits;
        }
        this.output.append((m & 0x10000000000000L) != 0L ? (char)'1' : '0');
        if (pLocal > 0 || pLocal == -1 && m != 0L || this.alternate) {
            this.output.append('.');
        }
        while (pLocal > 0 || pLocal == -1 && (m & 0xFFFFFFFFFFFFFL) != 0L) {
            this.output.append(digits[(int)((m & 0xF000000000000L) >> 48)]);
            m <<= 4;
            if (pLocal <= 0) continue;
            --pLocal;
        }
        this.output.append(this.type == 'A' ? (char)'P' : 'p');
        this.output.append(e >= 0 ? (char)'+' : '-');
        String expStr = Long.toString(Math.abs(e));
        this.output.append(expStr);
    }

    private void fixedFormat(DecDouble pdd, int p) {
        boolean freeFormat = this.type == 'g' || this.type == 'G';
        int i = 0;
        if (pdd.exp >= 0) {
            while (this.output.kn <= this.output.k0 + pdd.exp && i < pdd.numd) {
                this.output.append(pdd.digits[i++]);
            }
            if (this.output.kn <= this.output.k0 + pdd.exp) {
                this.output.append('0', this.output.k0 + 1 + pdd.exp - this.output.kn);
            }
        } else {
            this.output.append('0');
        }
        if (p > 0 && (!freeFormat || i < pdd.numd) || this.alternate) {
            this.output.append('.');
        }
        if (p > 0) {
            int kend = this.output.kn + p;
            if (pdd.exp < -1) {
                this.output.append('0', Math.min(p, -pdd.exp - 1));
            }
            while (this.output.kn < kend && i < pdd.numd) {
                this.output.append(pdd.digits[i++]);
            }
            if (this.output.kn < kend && (!freeFormat || this.alternate)) {
                this.output.append('0', kend - this.output.kn);
            }
        }
        if (i < pdd.numd && pdd.digits[i] >= '5') {
            this.roundUpFixedOutput(this.output);
        }
    }

    private void freeFormat(DecDouble pdd, int pprec) {
        int p = Math.max(1, pprec);
        if (pdd.exp >= -4 && pdd.exp < p) {
            this.fixedFormat(pdd, p - pdd.exp - 1);
        } else {
            this.expFormat(pdd, p - 1);
        }
    }

    private String pad() {
        int padcnt = this.width - (this.output.kn - this.output.k0);
        if (this.leftAdjust) {
            this.output.append(' ', padcnt);
        } else {
            this.output.prepend(' ', padcnt);
        }
        return this.prefix + this.output.getString() + this.suffix;
    }

    private void roundUpFixedOutput(OutBuffer out) {
        int i;
        for (i = out.kn - 1; i >= out.k0; --i) {
            if (out.buf[i] == '9') {
                out.buf[i] = 48;
                continue;
            }
            if (out.buf[i] == '.') continue;
            int n = i;
            out.buf[n] = (char)(out.buf[n] + '\u0001');
            break;
        }
        if (i < out.k0) {
            out.buf[--out.k0] = 49;
        }
    }

    private int scanRegularChars(char[] buf, String fmt) {
        int n = 0;
        while (this.idx < fmt.length()) {
            char c = fmt.charAt(this.idx);
            if (c == '%') {
                ++this.idx;
                if (this.idx == fmt.length()) {
                    throw new IllegalArgumentException("Format string terminates with '%'");
                }
                c = fmt.charAt(this.idx);
                if (c != '%') break;
            }
            buf[n++] = c;
            ++this.idx;
        }
        return n;
    }

    private int scanUnsignedInt(String fmt) {
        int value = 0;
        char c = fmt.charAt(this.idx);
        while (Character.isDigit(c)) {
            value = 10 * value + c - 48;
            if (++this.idx == fmt.length()) break;
            c = fmt.charAt(this.idx);
        }
        return value;
    }

    private void uconv(long val, int radix, char[] digits) {
        long valLocal = val;
        if (valLocal == 0L) {
            if (this.prec != 0) {
                this.output.append('0');
            }
            return;
        }
        if (valLocal < 0L) {
            long halfval = valLocal >>> 1;
            int mod = (int)(2L * (halfval % (long)radix) + (valLocal & 1L));
            valLocal = 2L * (halfval / (long)radix);
            if (mod >= radix) {
                mod -= radix;
                ++valLocal;
            }
            this.output.prepend(digits[mod]);
        }
        while (valLocal != 0L) {
            this.output.prepend(digits[(int)(valLocal % (long)radix)]);
            valLocal /= (long)radix;
        }
    }

    private class OutBuffer {
        char[] buf;
        int k0;
        int kn;

        OutBuffer(int n) {
            this.buf = new char[n];
            this.k0 = 0;
            this.kn = 0;
        }

        final void append(char c) {
            this.buf[this.kn++] = c;
        }

        final int append(String s) {
            for (int i = 0; i < s.length(); ++i) {
                this.buf[this.kn++] = s.charAt(i);
            }
            return this.kn;
        }

        final int append(char c, int n) {
            int nLocal = n;
            while (nLocal-- > 0) {
                this.buf[this.kn++] = c;
            }
            return this.kn;
        }

        final String getString() {
            return String.valueOf(this.buf, this.k0, this.kn - this.k0);
        }

        final void init(int base) {
            this.kn = this.k0 = base;
        }

        final void prepend(char c) {
            this.buf[--this.k0] = c;
        }

        final int prepend(String s) {
            for (int i = s.length() - 1; i >= 0; --i) {
                this.buf[--this.k0] = s.charAt(i);
            }
            return this.k0;
        }

        final int prepend(char c, int n) {
            int nLocal = n;
            while (nLocal-- > 0) {
                this.buf[--this.k0] = c;
            }
            return this.k0;
        }
    }

    private class DecDouble {
        String alt = null;
        char[] digits = null;
        int exp = 0;
        int numd = 0;
        int sign = 1;

        DecDouble() {
            this.init();
            this.set(0.0);
        }

        DecDouble(double d) {
            this.init();
            this.set(d);
        }

        void set(double d) {
            double dLocal = d;
            this.numd = 0;
            this.exp = 0;
            this.setSignAndAlt(dLocal);
            if (this.alt != null) {
                return;
            }
            if (dLocal == 0.0) {
                this.digits[0] = 48;
                this.numd = 1;
            } else {
                char c;
                int k;
                if (dLocal < 0.0) {
                    dLocal = -dLocal;
                }
                String s = Double.toString(dLocal);
                int len = s.length();
                int idec = -1;
                for (k = 0; k < len; ++k) {
                    c = s.charAt(k);
                    if (c == '.') {
                        idec = k;
                        continue;
                    }
                    if (c != '0') break;
                }
                this.numd = 0;
                while (k < len) {
                    c = s.charAt(k);
                    if (c == '.') {
                        idec = k;
                    } else {
                        if (c == 'e' || c == 'E') break;
                        this.digits[this.numd++] = c;
                    }
                    ++k;
                }
                this.exp = k < len ? Integer.parseInt(s.substring(k + 1)) : 0;
                this.exp = idec == -1 ? (this.exp += this.numd - 1) : (this.exp += idec - (k - this.numd));
            }
        }

        void setSignAndAlt(double d) {
            this.alt = null;
            this.sign = 1;
            if (Double.isNaN(d)) {
                this.alt = "nan";
            } else if (d == Double.POSITIVE_INFINITY) {
                this.alt = "inf";
            } else if (d == Double.NEGATIVE_INFINITY) {
                this.alt = "inf";
                this.sign = -1;
            } else if (d == 0.0) {
                this.sign = (Double.doubleToLongBits(d) & Long.MIN_VALUE) == 0L ? 1 : -1;
            } else if (d < 0.0) {
                this.sign = -1;
            }
        }

        private void init() {
            this.digits = new char[256];
            this.numd = 0;
        }
    }
}

