/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class JDFVersion {
    public static final String LIB_ARTIFACT_ID = JDFVersion.getBuildProp("lib.artifactId");
    public static final String LIB_NAME = JDFVersion.getBuildProp("lib.name");
    public static final String LIB_VERSION = JDFVersion.getBuildProp("lib.version");
    public static final String LIB_RELEASE_DATE = JDFVersion.getBuildProp("lib.release.date");
    public static final String LIB_MAJOR_VERSION = JDFVersion.getMajorVersion(LIB_VERSION);
    public static final String LIB_MINOR_VERSION = JDFVersion.getMinorVersion(LIB_VERSION);
    public static final String JDF_VERSION = JDFVersion.getBuildProp("jdf.version");
    private static final String RES_BUILD_PROPS = "/org/cip4/jdflib/build.properties";
    private static Properties props = null;

    private JDFVersion() {
    }

    private static String getBuildProp(String key) {
        if (props == null) {
            props = new Properties();
            try {
                InputStream is = JDFVersion.class.getResourceAsStream(RES_BUILD_PROPS);
                props.load(is);
            }
            catch (Exception e) {
                props = null;
                return null;
            }
        }
        return props.getProperty(key);
    }

    private static String getMajorVersion(String mvnVersion) {
        if (mvnVersion == null) {
            return null;
        }
        String version = StringUtils.substringBefore((String)mvnVersion, (String)"-");
        int i = version.lastIndexOf(".");
        return version.substring(0, i);
    }

    private static String getMinorVersion(String mvnVersion) {
        if (mvnVersion == null) {
            return null;
        }
        String version = StringUtils.substringBefore((String)mvnVersion, (String)"-");
        int i = version.lastIndexOf(".");
        return version.substring(i + 1);
    }
}

