/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.core.DocumentJDFImpl;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.w3c.dom.Attr;

public class XMLDocUserData {
    private Object m_userData = null;
    private static boolean useIDCache = true;
    private final VString m_vDirtyID;
    private final DocumentJDFImpl m_Parent;
    private final HashMap<String, KElement> m_mapTarget = new HashMap();
    private EnumDirtyPolicy dirtyPolicy;

    public XMLDocUserData(DocumentJDFImpl parent) {
        this.m_vDirtyID = new VString();
        this.m_Parent = parent;
        this.setDirtyPolicy(EnumDirtyPolicy.None);
        this.clearDirtyIDs();
        this.clearTargets();
    }

    public static void setIDCache(boolean bCache) {
        useIDCache = bCache;
    }

    public static boolean getIDCache() {
        return useIDCache;
    }

    public boolean hasTargetCache() {
        return this.m_mapTarget != null;
    }

    public void setDirtyPolicy(EnumDirtyPolicy dirtPol) {
        this.dirtyPolicy = dirtPol;
        this.m_Parent.bGlobalDirtyPolicy = EnumDirtyPolicy.None.equals(dirtPol);
    }

    public Object getUserData() {
        return this.m_userData;
    }

    public void setUserData(Object objUserData) {
        this.m_userData = objUserData;
    }

    public VString getDirtyIDs() {
        if (this.dirtyPolicy == EnumDirtyPolicy.ID) {
            return this.m_vDirtyID;
        }
        return null;
    }

    public VString getDirtyXPaths() {
        if (this.dirtyPolicy == EnumDirtyPolicy.XPath) {
            return this.m_vDirtyID;
        }
        return null;
    }

    public void clearDirtyIDs() {
        this.m_Parent.clearDirty();
        if (this.dirtyPolicy == EnumDirtyPolicy.ID) {
            this.m_vDirtyID.clear();
        }
        if (this.dirtyPolicy == EnumDirtyPolicy.XPath) {
            this.m_vDirtyID.clear();
        }
    }

    VString setDirty(KElement e, boolean bAttribute) {
        if (this.dirtyPolicy == EnumDirtyPolicy.XPath) {
            int i;
            Object x = e.buildXPath(null, 1);
            if (bAttribute) {
                x = (String)x + "/@";
            }
            int size = this.m_vDirtyID.size();
            for (i = 0; i < size; ++i) {
                String s = this.m_vDirtyID.elementAt(i);
                if (s.startsWith((String)x)) {
                    if (s.equals(x)) {
                        return this.m_vDirtyID;
                    }
                    this.m_vDirtyID.remove(i);
                    --i;
                    continue;
                }
                if (((String)x).startsWith(s)) {
                    return this.m_vDirtyID;
                }
                if (((String)x).compareTo(s) > 0) break;
            }
            this.m_vDirtyID.insertElementAt(x, i);
        } else if (this.dirtyPolicy == EnumDirtyPolicy.ID) {
            this.m_vDirtyID.appendUnique(e.getInheritedAttribute("ID", null, ""));
        }
        return this.m_vDirtyID;
    }

    public boolean isDirty(KElement element) {
        if (element == null) {
            return false;
        }
        if (this.dirtyPolicy == EnumDirtyPolicy.Doc) {
            return this.m_Parent.isDirty();
        }
        if (this.dirtyPolicy == EnumDirtyPolicy.ID) {
            String id = element.getInheritedAttribute("ID", null, null);
            return this.isDirty(id);
        }
        if (this.dirtyPolicy == EnumDirtyPolicy.XPath) {
            String xPath = element.buildXPath(null, 1);
            return this.isDirty(xPath);
        }
        return false;
    }

    public boolean isDirty(String strID) {
        if (this.dirtyPolicy == EnumDirtyPolicy.ID) {
            if (strID == null) {
                return this.m_vDirtyID.size() > 0;
            }
            return this.m_vDirtyID.contains(strID);
        }
        if (this.dirtyPolicy == EnumDirtyPolicy.XPath) {
            int size = this.m_vDirtyID.size();
            if (strID == null) {
                return size > 0;
            }
            for (int i = 0; i < size; ++i) {
                String s = this.m_vDirtyID.elementAt(i);
                if (strID.startsWith(s)) {
                    return true;
                }
                if (strID.compareTo(s) > 0) break;
            }
            return false;
        }
        return this.m_Parent.isDirty();
    }

    public void setTarget(KElement targetElement, String id) {
        String idLocal = id;
        if (!useIDCache || this.m_mapTarget == null) {
            return;
        }
        if (idLocal == null) {
            idLocal = targetElement.getAttribute("ID", null, null);
        }
        if (idLocal != null) {
            this.m_mapTarget.put(idLocal, targetElement);
        }
    }

    public void removeTarget(KElement targetElement) {
        KElement kelem;
        if (!useIDCache || this.m_mapTarget == null) {
            return;
        }
        String id = targetElement.getAttribute("ID", null, null);
        if (id != null && (kelem = this.m_mapTarget.get(id)) != null) {
            this.m_mapTarget.remove(id);
        }
    }

    public void removeTarget(String id) {
        if (useIDCache && this.m_mapTarget != null) {
            this.m_mapTarget.remove(id);
        }
    }

    public KElement getTarget(String strID) {
        KElement elem;
        if (useIDCache && this.m_mapTarget != null && strID != null && (elem = this.m_mapTarget.get(strID)) != null) {
            Attr a = elem.getAttributeNode("ID");
            if (a != null && strID.equals(a.getValue())) {
                return elem;
            }
            this.m_mapTarget.remove(strID);
        }
        return null;
    }

    public void clearTargets() {
        if (useIDCache && this.m_mapTarget != null) {
            this.m_mapTarget.clear();
        }
    }

    public void fillIDCache() {
        this.clearTargets();
        if (!useIDCache) {
            return;
        }
        KElement root = (KElement)this.m_Parent.getDocumentElement();
        if (root != null) {
            this.fillIDCache(root);
        }
    }

    private void fillIDCache(KElement root) {
        Attr attr = root.getAttributeNode("ID");
        if (attr != null) {
            this.m_mapTarget.put(attr.getValue(), root);
        }
        for (KElement e = root.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            this.fillIDCache(e);
        }
    }

    public Object getDirtyPolicy() {
        return this.dirtyPolicy;
    }

    public static final class EnumDirtyPolicy
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumDirtyPolicy None = new EnumDirtyPolicy("None");
        public static final EnumDirtyPolicy ID = new EnumDirtyPolicy("ID");
        public static final EnumDirtyPolicy Doc = new EnumDirtyPolicy("Doc");
        public static final EnumDirtyPolicy XPath = new EnumDirtyPolicy("XPath");

        private EnumDirtyPolicy(String name) {
            super(name, m_startValue++);
        }

        public static EnumDirtyPolicy getEnum(String enumName) {
            return (EnumDirtyPolicy)EnumDirtyPolicy.getEnum(EnumDirtyPolicy.class, enumName);
        }

        public static EnumDirtyPolicy getEnum(int enumValue) {
            return (EnumDirtyPolicy)EnumDirtyPolicy.getEnum(EnumDirtyPolicy.class, enumValue);
        }

        public static Map getEnumMap() {
            return EnumDirtyPolicy.getEnumMap(EnumDirtyPolicy.class);
        }

        public static List getEnumList() {
            return EnumDirtyPolicy.getEnumList(EnumDirtyPolicy.class);
        }

        public static Iterator iterator() {
            return EnumDirtyPolicy.iterator(EnumDirtyPolicy.class);
        }
    }
}

