/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.util.HashUtil;

public class JDFMatrix
extends JDFNumList {
    private static final long serialVersionUID = 1L;
    private static final JDFMatrix unitMatrix = new JDFMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);

    public static JDFMatrix getUnitMatrix() {
        return new JDFMatrix(unitMatrix);
    }

    public JDFMatrix() {
        super(6);
    }

    @Override
    public synchronized JDFMatrix clone() {
        return (JDFMatrix)super.clone();
    }

    @Deprecated
    public JDFMatrix(Vector v) throws DataFormatException {
        super(v);
    }

    public JDFMatrix(double degrees, double x, double y) {
        super(6);
        this.setA(1.0);
        this.setD(1.0);
        this.shift(x, y);
        this.rotate(degrees);
    }

    public JDFMatrix(JDFElement.EnumOrientation orientation, double w, double h) {
        super(6);
        if (orientation == null || orientation.equals(JDFElement.EnumOrientation.Rotate0)) {
            this.setA(1.0);
            this.setD(1.0);
        } else if (orientation.equals(JDFElement.EnumOrientation.Rotate90)) {
            this.setB(1.0);
            this.setC(-1.0);
            this.setTx(h);
        } else if (orientation.equals(JDFElement.EnumOrientation.Rotate180)) {
            this.setA(-1.0);
            this.setD(-1.0);
            this.setTx(w);
            this.setTy(h);
        } else if (orientation.equals(JDFElement.EnumOrientation.Rotate270)) {
            this.setB(-1.0);
            this.setC(1.0);
            this.setTy(w);
        } else if (orientation.equals(JDFElement.EnumOrientation.Flip0)) {
            this.setA(1.0);
            this.setD(-1.0);
            this.setTy(h);
        } else if (orientation.equals(JDFElement.EnumOrientation.Flip90)) {
            this.setB(-1.0);
            this.setC(-1.0);
            this.setTx(h);
            this.setTy(w);
        } else if (orientation.equals(JDFElement.EnumOrientation.Flip180)) {
            this.setA(-1.0);
            this.setD(1.0);
            this.setTx(w);
        } else if (orientation.equals(JDFElement.EnumOrientation.Flip270)) {
            this.setB(1.0);
            this.setC(1.0);
        }
    }

    public JDFMatrix(String s) throws DataFormatException {
        super(s);
    }

    public static JDFMatrix createMatrix(String s) {
        if (s != null && s.length() >= 11) {
            try {
                return new JDFMatrix(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFMatrix(JDFNumList nl) throws DataFormatException {
        super(nl);
    }

    public JDFMatrix(JDFMatrix matrix) {
        this.addAll(matrix);
    }

    public JDFMatrix(JDFRectangle rect) {
        this(unitMatrix);
        if (rect != null) {
            this.shift(rect.getLlx(), rect.getLly());
        }
    }

    public JDFMatrix(double a, double b, double c, double d, double tx, double ty) {
        super(6);
        this.setA(a);
        this.setB(b);
        this.setC(c);
        this.setD(d);
        this.setTx(tx);
        this.setTy(ty);
    }

    @Override
    public boolean isValid() throws DataFormatException {
        if (this.size() != 6) {
            throw new DataFormatException("wrong size! " + this.size());
        }
        for (Object o : this) {
            if (o instanceof Double) continue;
            throw new DataFormatException("Data format exception!");
        }
        return true;
    }

    public double getA() {
        return this.doubleAt(0);
    }

    public void setA(double p_a) {
        this.set(0, p_a);
    }

    public double getB() {
        return this.doubleAt(1);
    }

    public void setB(double p_b) {
        this.set(1, p_b);
    }

    public double getC() {
        return this.doubleAt(2);
    }

    public void setC(double p_c) {
        this.set(2, p_c);
    }

    public double getD() {
        return this.doubleAt(3);
    }

    public void setD(double p_d) {
        this.set(3, p_d);
    }

    public double getTx() {
        return this.doubleAt(4);
    }

    public JDFXYPair getShift() {
        return new JDFXYPair(this.getTx(), this.getTy());
    }

    public JDFElement.EnumOrientation getOrientation() {
        boolean isFlip = this.isFlip();
        double angle = this.getAngle();
        if (Math.abs(angle) < 1.0) {
            return isFlip ? JDFElement.EnumOrientation.Flip0 : JDFElement.EnumOrientation.Rotate0;
        }
        if (Math.abs(angle - 90.0) < 1.0) {
            return isFlip ? JDFElement.EnumOrientation.Flip90 : JDFElement.EnumOrientation.Rotate90;
        }
        if (Math.abs(angle - 180.0) < 1.0) {
            return isFlip ? JDFElement.EnumOrientation.Flip180 : JDFElement.EnumOrientation.Rotate180;
        }
        if (Math.abs(angle - 270.0) < 1.0) {
            return isFlip ? JDFElement.EnumOrientation.Flip270 : JDFElement.EnumOrientation.Rotate270;
        }
        return null;
    }

    public double getAngle() {
        double det = this.getAffineTransform().getDeterminant();
        double aDet = Math.abs(det);
        if (aDet < 1.0E-5) {
            return 0.0;
        }
        double a = this.getA() / aDet;
        double b = this.getB() / det;
        double angleb = Math.asin(b) * 180.0 / Math.PI;
        double angleA = Math.acos(a) * 180.0 / Math.PI;
        if (angleb < 0.0) {
            angleA += 180.0;
        }
        return angleA;
    }

    public boolean isFlip() {
        double det = this.getAffineTransform().getDeterminant();
        return det < 0.0;
    }

    public void setTx(double p_tx) {
        this.set(4, p_tx);
    }

    public double getTy() {
        return this.doubleAt(5);
    }

    public void setTy(double p_ty) {
        this.set(5, p_ty);
    }

    @Override
    public synchronized boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        JDFMatrix m = (JDFMatrix)other;
        return Math.abs(this.getA() - m.getA()) <= 1.0E-6 && Math.abs(this.getB() - m.getB()) <= 1.0E-6 && Math.abs(this.getC() - m.getC()) <= 1.0E-6 && Math.abs(this.getD() - m.getD()) <= 1.0E-6 && Math.abs(this.getTx() - m.getTx()) <= 1.0E-6 && Math.abs(this.getTy() - m.getTy()) <= 1.0E-6;
    }

    @Override
    public synchronized int hashCode() {
        return HashUtil.hashCode(super.hashCode(), this.toString());
    }

    public AffineTransform getAffineTransform() {
        return new AffineTransform(this.getA(), this.getB(), this.getC(), this.getD(), this.getTx(), this.getTy());
    }

    public void setAffineTransform(AffineTransform affineTrans) {
        double[] flatMatrix = new double[6];
        affineTrans.getMatrix(flatMatrix);
        this.setA(flatMatrix[0]);
        this.setB(flatMatrix[1]);
        this.setC(flatMatrix[2]);
        this.setD(flatMatrix[3]);
        this.setTx(flatMatrix[4]);
        this.setTy(flatMatrix[5]);
    }

    public JDFXYPair transform(JDFXYPair inCoordinate) {
        if (inCoordinate == null) {
            return null;
        }
        Point2D p = inCoordinate.getPoint2D();
        this.getAffineTransform().transform(p, p);
        return new JDFXYPair(p.getX(), p.getY());
    }

    public JDFMatrix shift(double tx, double ty) {
        this.setTx(this.getTx() + tx);
        this.setTy(this.getTy() + ty);
        return this;
    }

    public JDFMatrix rotate(double degrees) {
        AffineTransform at = this.getAffineTransform();
        at.rotate(degrees * Math.PI / 180.0);
        this.setAffineTransform(at);
        return this;
    }

    public JDFMatrix concat(JDFMatrix m) {
        AffineTransform a = this.getAffineTransform();
        AffineTransform ma = m.getAffineTransform();
        a.concatenate(ma);
        this.setAffineTransform(a);
        return this;
    }

    public JDFMatrix invert() {
        AffineTransform a = this.getAffineTransform();
        try {
            this.setAffineTransform(a.createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return this;
    }

    public JDFMatrix shift(JDFXYPair point) {
        if (point != null) {
            this.shift(point.getX(), point.getY());
        }
        return this;
    }

    public JDFMatrix setShift(JDFXYPair point) {
        this.setTx(point == null ? 0.0 : point.getX());
        this.setTy(point == null ? 0.0 : point.getY());
        return this;
    }

    public JDFRectangle transform(JDFRectangle jdfRectangle) {
        if (jdfRectangle == null) {
            return null;
        }
        JDFXYPair ll = this.transform(jdfRectangle.getLL());
        JDFXYPair ur = this.transform(jdfRectangle.getUR());
        return new JDFRectangle(ll, ur);
    }
}

