/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.util.HashMap;
import java.util.List;
import org.apache.xerces.dom.AttrNSImpl;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.util.BiHashMap;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.Attr;

public class EnsureNSUri
extends BaseElementWalker {
    protected final BiHashMap<String, String> nsMap = new BiHashMap();
    protected final HashMap<String, String> aliasMap = new HashMap();

    public void addNS(String prefix, String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri MUST NOT be null");
        }
        if (prefix == null) {
            prefix = "";
        }
        this.nsMap.put(prefix, uri);
    }

    public void addAlias(String badPrefix, String goodPrefix) {
        if (goodPrefix == null) {
            goodPrefix = "<";
        }
        this.aliasMap.put(badPrefix, goodPrefix);
    }

    public void walk(KElement root) {
        root.clearNSMap();
        for (String next : this.nsMap.keySet()) {
            String strNameSpaceURI = this.nsMap.get(next);
            root.addNameSpace(next, strNameSpaceURI);
        }
        for (String next : this.aliasMap.keySet()) {
            Object zappAtt = next == null ? "xmlns" : "xmlns:" + next;
            root.removeAttribute((String)zappAtt);
        }
        this.walkTree(root, null);
    }

    public EnsureNSUri() {
        super(new BaseWalkerFactory());
        this.addAlias("", null);
        new BaseWalker(this.getFactory());
    }

    @Override
    public String toString() {
        return super.toString() + " nsMap=" + String.valueOf(this.nsMap) + " aliasMap=" + String.valueOf(this.aliasMap);
    }

    public class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(EnsureNSUri.this.getFactory());
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            String uri;
            String prefix = e1.getPrefix();
            String destPrefix = this.getAlias(prefix, uri = e1.getNamespaceURI());
            if (EnsureNSUri.this.nsMap.get(destPrefix) != null) {
                e1.setNamespaceURI(EnsureNSUri.this.nsMap.get(destPrefix));
            }
            if ("".equals(destPrefix)) {
                destPrefix = null;
            }
            if (destPrefix != null && !destPrefix.equals(prefix) || prefix != null && destPrefix == null) {
                e1.setPrefix(destPrefix);
            }
            List<String> atts = e1.getAttributeArray_KElement();
            for (String att : atts) {
                this.processAttribute(e1, att);
            }
            return e1;
        }

        private void processAttribute(KElement e1, String att) {
            String origPrefix = KElement.xmlnsPrefix(att);
            String prefix = this.getAlias(origPrefix, null);
            String uri = EnsureNSUri.this.nsMap.get(prefix);
            if ("".equals(prefix)) {
                prefix = null;
            }
            if (uri != null && !"xmlns".equals(att)) {
                this.processStandardAttribute(e1, att, origPrefix, prefix, uri);
            } else if ("xmlns".equals(prefix) || "xmlns".equals(att)) {
                this.processXmlns(e1, att);
            }
        }

        private void processStandardAttribute(KElement e1, String att, String origPrefix, String prefix, String uri) {
            Attr attr = e1.getDOMAttr(att, null, false);
            if (!(uri.equals(attr.getNamespaceURI()) && ContainerUtil.equals(prefix, origPrefix) || !(attr instanceof AttrNSImpl))) {
                String val = e1.getAttribute(att);
                e1.removeAttribute(att);
                if (origPrefix != null && !origPrefix.equals(prefix)) {
                    att = StringUtil.replaceToken(att, 0, ":", prefix);
                }
                if (prefix == null) {
                    e1.setAttribute(att, val);
                } else {
                    e1.setAttributeNS(uri, att, val);
                }
            }
        }

        private void processXmlns(KElement e1, String att) {
            String alias;
            String prefix = KElement.xmlnsLocalName(att);
            if ("xmlns".equals(prefix)) {
                prefix = "";
            }
            if ((alias = this.getAlias(prefix, null)) != null && !alias.equals(prefix)) {
                e1.removeAttribute(att);
            } else {
                Attr attr;
                String uri;
                if (prefix == null) {
                    prefix = ":";
                }
                if ((uri = EnsureNSUri.this.nsMap.get(prefix)) != null && (attr = e1.getDOMAttr(att, null, false)) != null && !uri.equals(attr.getValue())) {
                    attr.setNodeValue(uri);
                }
            }
        }

        private String getAlias(String prefix, String uri) {
            String s2;
            if (prefix == null) {
                prefix = "";
            }
            if ("<".equals(s2 = EnsureNSUri.this.aliasMap.get(prefix))) {
                String newPrefix = uri == null ? null : EnsureNSUri.this.nsMap.getKey(uri);
                return newPrefix == null ? "" : newPrefix;
            }
            if (s2 == null && uri != null) {
                String newPrefix = EnsureNSUri.this.nsMap.getKey(uri);
                String newURI = EnsureNSUri.this.nsMap.get(prefix);
                if (newURI == null && newPrefix != null && !ContainerUtil.equals(prefix, newPrefix)) {
                    EnsureNSUri.this.addAlias(prefix, newPrefix);
                    s2 = newPrefix;
                }
            }
            return s2 == null ? prefix : s2;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return true;
        }
    }
}

