/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.ifaces.IElementConverter;
import org.cip4.jdflib.ifaces.IURLSetter;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.UrlUtil;

public class URLExtractor
extends BaseElementWalker
implements IElementConverter {
    protected final File dir;
    protected final String baseURL;
    protected Set<UrlUtil.URLProtocol> protocols;
    protected final String currentURL;
    protected final Map<String, String> saved;
    protected boolean deleteFile;
    private boolean wantLog;

    public boolean isDeleteFile() {
        return this.deleteFile;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.deleteFile = deleteFile;
    }

    public Set<String> getSaved() {
        return this.saved.keySet();
    }

    public URLExtractor(File dumpDir, String currentURL, String baseURL) {
        super(new BaseWalkerFactory());
        this.dir = dumpDir;
        this.baseURL = baseURL;
        this.currentURL = currentURL;
        this.saved = new HashMap<String, String>();
        this.protocols = null;
        this.setDeleteFile(false);
        this.setWantLog(false);
    }

    public void setWantLog(boolean bWant) {
        this.wantLog = bWant;
    }

    public void addProtocol(UrlUtil.URLProtocol protocol) {
        if (this.protocols == null) {
            this.protocols = new HashSet<UrlUtil.URLProtocol>();
        }
        this.protocols.add(protocol);
    }

    @Override
    public KElement convert(KElement root) {
        this.walkTree(root, null);
        return root;
    }

    @Override
    public String toString() {
        return super.toString() + String.valueOf(this.protocols) + " baseURL: " + this.baseURL + " currentURL: " + this.currentURL + " dir: " + String.valueOf(this.dir) + " delete: " + this.deleteFile;
    }

    public class WalkURL
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            UrlUtil.URLProtocol protocol;
            IURLSetter urlSetter = (IURLSetter)((Object)e);
            String url = StringUtil.getNonEmpty(urlSetter.getURL());
            if (url == null) {
                return e;
            }
            String newUrl = URLExtractor.this.saved.get(url);
            if (!StringUtil.isEmpty(newUrl)) {
                urlSetter.setURL(newUrl);
                return e;
            }
            if (URLExtractor.this.baseURL != null && url.startsWith(URLExtractor.this.baseURL) || newUrl != null) {
                return e;
            }
            if (URLExtractor.this.protocols != null && !URLExtractor.this.protocols.contains((Object)(protocol = UrlUtil.getProtocol(url)))) {
                return e;
            }
            boolean fileOK = this.checkFile(url);
            if (fileOK) {
                File newFile = UrlUtil.moveToDir(urlSetter, URLExtractor.this.dir, URLExtractor.this.currentURL, true, URLExtractor.this.deleteFile);
                for (int i = 1; i < 4 && newFile == null && !UrlUtil.isRelativeURL(url); ++i) {
                    if (!ThreadUtil.sleep(1234)) {
                        return null;
                    }
                    newFile = UrlUtil.moveToDir(urlSetter, URLExtractor.this.dir, URLExtractor.this.currentURL, true, URLExtractor.this.deleteFile);
                    this.log.warn((Object)("attempting download # " + i + " of URL " + url));
                }
                if (newFile != null) {
                    if (URLExtractor.this.baseURL != null) {
                        String s = UrlUtil.isRelativeURL(url) ? url : UrlUtil.escape(newFile.getName(), false, false);
                        String urlWithDirectory = UrlUtil.getURLWithDirectory(URLExtractor.this.baseURL, s);
                        urlSetter.setURL(urlWithDirectory);
                    }
                    URLExtractor.this.saved.put(url, urlSetter.getURL());
                    if (URLExtractor.this.wantLog) {
                        this.log.info((Object)((URLExtractor.this.deleteFile ? "moved" : "copied ") + url + " to " + urlSetter.getURL()));
                    }
                } else {
                    this.log.warn((Object)((URLExtractor.this.deleteFile ? "could not move " : "could not copy ") + url + " to " + String.valueOf(URLExtractor.this.dir)));
                    URLExtractor.this.saved.put(url, "");
                }
            }
            return e;
        }

        protected boolean checkFile(String url) {
            if (!UrlUtil.isFile(url) && !UrlUtil.isUNC(url)) {
                return true;
            }
            File f = UrlUtil.urlToFile(url);
            if (URLExtractor.this.currentURL != null && UrlUtil.isRelativeURL(url)) {
                f = FileUtil.cleanDots(new File(URLExtractor.this.currentURL, f.getPath()));
            }
            if (f != null) {
                if (!f.exists()) {
                    File parentDir = f.getParentFile();
                    if (parentDir != null && !parentDir.exists()) {
                        this.log.warn((Object)("No such parent directory: " + String.valueOf(parentDir)));
                    } else if (parentDir != null && !parentDir.canRead()) {
                        this.log.warn((Object)("Cannot read parent directory: " + String.valueOf(parentDir)));
                    }
                    this.log.warn((Object)("No such file: " + String.valueOf(f)));
                    return false;
                }
                if (!f.canRead()) {
                    this.log.warn((Object)("Cannot read file: " + String.valueOf(f)));
                    return false;
                }
                if (f.isDirectory()) {
                    this.log.warn((Object)("Cannot copy directory: " + String.valueOf(f)));
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof IURLSetter;
        }
    }

    public class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(URLExtractor.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            return e;
        }
    }
}

