/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.ListMap;

public class UnLinkFinder
extends BaseElementWalker {
    protected LinkData linkData = new LinkData();
    boolean ignoreForeign = true;

    public UnLinkFinder() {
        super(new BaseWalkerFactory());
        new BaseWalker(this.getFactory());
    }

    public void setIgnoreForeign(boolean ignoreForeign) {
        this.ignoreForeign = ignoreForeign;
    }

    public VElement getUnlinkedResources(JDFNode n) {
        this.linkData.clear();
        this.walkTree(n, null);
        Vector<KElement> toValueVector = ContainerUtil.toValueVector(this.linkData.resMap, false);
        return toValueVector == null ? null : new VElement(toValueVector);
    }

    public VElement getUnlinkedRefs(JDFNode n) {
        this.linkData.clear();
        this.walkTree(n, null);
        List<KElement> toValueVector = this.linkData.refMap.getAllValues();
        if (toValueVector == null) {
            return null;
        }
        VElement ret = new VElement();
        ret.addAll(toValueVector);
        return ret;
    }

    public VElement getAllUnlinked(JDFNode n) {
        this.linkData.clear();
        this.walkTree(n, null);
        List toValueVector = ContainerUtil.toArrayList(this.linkData.resMap, false);
        List<KElement> toValueVectorRef = this.linkData.refMap.getAllValues();
        toValueVector = (List)ContainerUtil.addAll(toValueVector, toValueVectorRef);
        if (toValueVector == null) {
            return null;
        }
        VElement ret = new VElement();
        ret.addAll(toValueVector);
        return ret;
    }

    public int eraseUnlinkedResources(JDFNode n) {
        return this.eraseUnlinked(n, false, true);
    }

    public int eraseUnlinkedRefs(JDFNode n) {
        return this.eraseUnlinked(n, true, false);
    }

    public int eraseUnlinked(JDFNode n) {
        return this.eraseUnlinked(n, true, true);
    }

    private int eraseUnlinked(JDFNode n, boolean ref, boolean res) {
        VElement v = null;
        if (ref && res) {
            v = this.getAllUnlinked(n);
        } else if (ref) {
            v = this.getUnlinkedRefs(n);
        } else if (res) {
            v = this.getUnlinkedResources(n);
        }
        int siz = ContainerUtil.size(v);
        if (siz > 0 && v != null) {
            for (KElement e : v) {
                e.deleteNode();
            }
            siz += this.eraseUnlinked(n, ref, res);
        }
        return siz;
    }

    protected class LinkData {
        HashMap<String, KElement> resMap = new HashMap();
        ListMap<String, KElement> refMap = new ListMap();
        HashSet<String> doneSet = new HashSet();

        protected void clear() {
            this.resMap.clear();
            this.refMap.clear();
            this.doneSet.clear();
        }
    }

    public class WalkRef
    extends BaseWalker {
        public WalkRef() {
            super(UnLinkFinder.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String id = e.getAttribute("rRef", null, null);
            if (id == null) {
                return e;
            }
            if (UnLinkFinder.this.linkData.doneSet.contains(id)) {
                return e;
            }
            if (UnLinkFinder.this.linkData.resMap.containsKey(id)) {
                UnLinkFinder.this.linkData.doneSet.add(id);
                UnLinkFinder.this.linkData.resMap.remove(id);
                return e;
            }
            UnLinkFinder.this.linkData.refMap.putOne(id, e);
            return e;
        }

        @Override
        public boolean matches(KElement toCheck) {
            if (UnLinkFinder.this.ignoreForeign && !JDFElement.isInJDFNameSpaceStatic(toCheck)) {
                return false;
            }
            return JDFResourceLink.isResourceLink(toCheck) || toCheck instanceof JDFRefElement;
        }
    }

    public class WalkRes
    extends BaseWalker {
        public WalkRes() {
            super(UnLinkFinder.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            JDFElement r = (JDFElement)e;
            String id = r.getID();
            if (UnLinkFinder.this.linkData.doneSet.contains(id)) {
                return e;
            }
            if (UnLinkFinder.this.linkData.refMap.containsKey(id)) {
                UnLinkFinder.this.linkData.doneSet.add(id);
                UnLinkFinder.this.linkData.refMap.remove(id);
                return e;
            }
            UnLinkFinder.this.linkData.resMap.put(id, r);
            return e;
        }

        @Override
        public boolean matches(KElement toCheck) {
            if (UnLinkFinder.this.ignoreForeign && !JDFElement.isInJDFNameSpaceStatic(toCheck)) {
                return false;
            }
            return toCheck.getParentNode() instanceof JDFResourcePool && toCheck instanceof JDFElement && !(toCheck instanceof JDFComment) && !(toCheck instanceof JDFGeneralID);
        }
    }
}

