/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.List;
import java.util.Vector;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.XJDFCombiner;

public class MultiXJDFCombiner {
    private final List<XJDFHelper> helpers;
    final XJDFHelper helper;

    public MultiXJDFCombiner(List<XJDFHelper> helpers) {
        this.helpers = helpers;
        this.helper = helpers.remove(0).clone();
    }

    public XJDFHelper getCombinedHelper() {
        this.prepareHelper();
        for (XJDFHelper h : this.helpers) {
            this.mergeHelper(h);
        }
        this.helper.cleanUp();
        return this.helper;
    }

    private void prepareHelper() {
        Vector<SetHelper> vsh = this.helper.getSets();
        VString typs = this.helper.getTypes();
        if (typs != null) {
            JDFIntegerList il = new JDFIntegerList();
            for (int i = 0; i < typs.size(); ++i) {
                il.add(i);
            }
            if (vsh != null) {
                for (SetHelper sh : vsh) {
                    if (sh.getCombinedProcessIndex() != null) continue;
                    sh.setCombinedProcessIndex(il);
                }
            }
        }
    }

    private void mergeHelper(XJDFHelper h) {
        XJDFCombiner xjdfCombiner = new XJDFCombiner(this.helper, h);
        xjdfCombiner.combine();
    }

    public String toString() {
        return "MultiXJDFCombiner [" + (String)(this.helper != null ? "helper=" + String.valueOf(this.helper) : "") + "]";
    }
}

