/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.ArrayList;
import java.util.List;
import org.cip4.jdflib.auto.JDFAutoMedia;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.JDFToXJDFDataCache;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkElement;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFPageList;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFLayout;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.resource.process.JDFPageData;
import org.cip4.jdflib.resource.process.JDFSeparationSpec;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class WalkJDFElement
extends WalkElement {
    final String m_spawnInfo = "SpawnInfo";

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFElement je = (JDFElement)jdf;
        this.makeRefElements(je);
        return super.walk(jdf, xjdf);
    }

    void makeRefElements(JDFElement je) {
        this.removeUnusedElements(je);
        List<KElement> v = je.getChildList();
        for (KElement e : v) {
            if (!(e instanceof JDFResource) || !JDFElement.isInJDFNameSpaceStatic(e) || this.mustInline(e.getLocalName())) continue;
            this.cleanRefs(je, (JDFResource)e);
        }
    }

    protected boolean matchesRootID(JDFNode node) {
        boolean matchesID = node.getID().equals(this.jdfToXJDF.rootID);
        if (!matchesID && !this.jdfToXJDF.isSingleNode()) {
            for (JDFNode parent = node.getParentJDF(); parent != null && !matchesID; parent = parent.getParentJDF()) {
                matchesID = parent.getID().equals(this.jdfToXJDF.rootID);
            }
        }
        return matchesID;
    }

    void cleanRefs(JDFElement je, JDFResource r) {
        if (r.isResourceElement()) {
            JDFNode parentJDF = je.getParentJDF();
            if (parentJDF != null) {
                r = r.makeRootResource(null, parentJDF, false);
                JDFResourcePool prevPool = parentJDF.getResourcePool();
                if (prevPool != null) {
                    r = this.removeDuplicateRefs(r, prevPool);
                }
                this.jdfToXJDF.getResourceAlias().add(r.getID());
            } else if (je.getJMFRoot() != null) {
                JDFResource resourceRoot = r.getResourceRoot();
                JDFElement parent = (JDFElement)(resourceRoot == null ? null : resourceRoot.getParentNode_KElement());
                r = r.makeRootResource(null, parent, false);
            }
            r.setResStatus(JDFResource.EResStatus.Available, true);
            je.refElement(r);
        }
    }

    private JDFResource removeDuplicateRefs(JDFResource r, JDFResourcePool prevPool) {
        JDFAttributeMap m = r.getAttributeMap();
        m.remove("ID");
        VElement prevs = prevPool.getChildrenByTagName(this.jdfToXJDF.getSetName(r), null, m, true, true, 0);
        if (prevs != null) {
            for (KElement e : prevs) {
                JDFResource prev = (JDFResource)e;
                if (r == prev) continue;
                String pid = prev.getID();
                String rid = r.getID();
                prev.removeAttribute("ID");
                r.removeAttribute("ID");
                if (r.isEqual(prev)) {
                    r.deleteNode();
                    r = prev;
                    prev.setID(pid);
                    break;
                }
                r.setID(rid);
                prev.setID(pid);
            }
        }
        return r;
    }

    protected String getRefName(JDFRefElement re) {
        Object name = re.getLocalName();
        if (this.jdfToXJDF.isMergeRunList() && "LayoutElementRef".equals(name)) {
            name = "RunListRef";
        }
        if ("ContactRef".equals(name) || "ContentRef".equals(name)) {
            name = (String)name + "s";
        }
        name = this.getMediaRefName(re, (String)name);
        return name;
    }

    String getMediaRefName(JDFRefElement re, String name) {
        JDFMedia m;
        KElement parent;
        if ("MediaRef".equals(name) && ((parent = re.getParentNode_KElement()) instanceof JDFLayout || parent instanceof JDFStrippingParams) && (m = (JDFMedia)re.getTarget()) != null) {
            JDFAutoMedia.EnumMediaType t = m.getMediaType();
            if (JDFAutoMedia.EnumMediaType.Paper.equals(t)) {
                name = "PaperRef";
            }
            if (JDFAutoMedia.EnumMediaType.Plate.equals(t)) {
                name = "PlateRef";
            }
        }
        return name;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFElement;
    }

    KElement getProductForElement(KElement xjdf, JDFElement rl) {
        JDFNode rlParent = rl instanceof JDFNode ? (JDFNode)rl : rl.getParentJDF();
        String parentID = this.getXJDFProductID(rlParent);
        KElement product = new XJDFHelper(xjdf).getCreateProduct(parentID, null).getProduct();
        if (this.jdfToXJDF.isRetainAll()) {
            product.copyAttribute("JobPartID", rlParent);
        }
        return product;
    }

    String getXJDFProductID(JDFNode node) {
        JDFComponent c = (JDFComponent)node.getResource("Component", JDFResourceLink.EnumUsage.Output, 0);
        String jpID = node.getJobPartID(false);
        if (c != null) {
            VString cid = c.getAssemblyIDs();
            if (ContainerUtil.size(cid) == 1) {
                jpID = cid.get(0);
            } else {
                String productID = c.getProductID();
                if (!StringUtil.isEmpty(productID)) {
                    jpID = productID;
                }
            }
        }
        String id = StringUtil.isEmpty(jpID) ? node.getID() : jpID;
        return "IDP_" + id;
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        if (!this.jdfToXJDF.isRetainAll()) {
            map.remove("BestEffortExceptions");
            map.remove("Locked");
            map.remove("MaxVersion");
            map.remove("MustHonorExceptions");
            map.remove("OperatorInterventionExceptions");
            map.remove("PipePartIDKeys");
            map.remove("PipePause");
            map.remove("PipeResume");
            map.remove("RemotePipeEndPause");
            map.remove("RemotePipeEndResume");
            map.remove("SettingsPolicy");
            map.remove("SourceWorkStyle");
            map.remove("SpawnID");
            super.updateAttributes(map);
        }
    }

    protected void updateModule(JDFAttributeMap map) {
        String oldModule = map.remove("ModuleIndex");
        if (!StringUtil.isEmpty(oldModule) && map.getNonEmpty("ModuleID") == null) {
            map.put("ModuleID", "Mod" + oldModule);
        }
    }

    void updateColorPoolColors(JDFResource r) {
        VElement v = r.getChildElementVector("Color", null);
        for (KElement e : v) {
            if (!e.hasAttribute("ActualColorName")) {
                e.copyAttribute("ActualColorName", e, "Name", null, null);
            }
            String sep = StringUtil.replaceChar(e.getAttribute("Name"), ' ', "_", 0);
            e.setAttribute("Separation", sep);
            e.removeAttribute("Name");
        }
        KElement cNew = this.safeRename(r, "Color");
        cNew.setAttribute("PartIDKeys", "Separation");
    }

    protected List<KElement> setResource(JDFElement rl, JDFResource linkTarget, KElement xRoot) {
        JDFResourceLink resLink;
        String className = this.jdfToXJDF.getClassName(linkTarget);
        if (className == null || xRoot == null || linkTarget == null) {
            return null;
        }
        JDFResourceLink jDFResourceLink = resLink = rl instanceof JDFResourceLink ? (JDFResourceLink)rl : null;
        if (this.isExchangeResource(resLink, linkTarget)) {
            return null;
        }
        boolean expandLink = rl instanceof JDFResourceLink;
        if (expandLink) {
            linkTarget.getResourceRoot().expand(false);
        } else {
            linkTarget.expand(false);
        }
        String resID = this.getResID(linkTarget, rl);
        KElement resourceSet = this.getSet(resID, xRoot, className);
        if (resourceSet == null) {
            resourceSet = xRoot.appendElement(className + "Set");
            resourceSet.setID(resID);
        }
        this.setSetAttributes(resourceSet, rl, linkTarget);
        int nLeaves = resourceSet.numChildElements(className, null);
        VElement vRes = this.getLeaves(rl, linkTarget, expandLink);
        return this.loopLeaves(rl, className, resourceSet, nLeaves, vRes);
    }

    protected VElement getLeaves(JDFElement rl, JDFResource linkTarget, boolean expandLink) {
        if (expandLink) {
            VElement rawTargetVector = ((JDFResourceLink)rl).getRawTargetVector(0);
            VElement newTargetVector = new VElement();
            boolean changed = false;
            for (KElement e : rawTargetVector) {
                if (((JDFResource)e).isLeaf()) {
                    newTargetVector.add(e);
                    continue;
                }
                newTargetVector.addAll(((JDFResource)e).getLeaves(this.checkAllLeaves(linkTarget)));
                changed = true;
            }
            if (changed) {
                ContainerUtil.unify(newTargetVector);
            }
            return newTargetVector;
        }
        return linkTarget.getLeaves(false);
    }

    protected boolean checkAllLeaves(JDFResource linkTarget) {
        boolean implicit = this.jdfToXJDF.wantImplicit() && JDFResource.EnumPartUsage.Implicit.equals(linkTarget.getPartUsage());
        boolean isLayout = linkTarget instanceof JDFLayout || linkTarget instanceof JDFStrippingParams;
        return implicit && (!isLayout || !ContainerUtil.contains(linkTarget.getPartIDKeyList(), "SheetName"));
    }

    List<KElement> loopLeaves(JDFElement rl, String className, KElement resourceSet, int nLeaves, VElement vRes) {
        ArrayList<KElement> v = new ArrayList<KElement>();
        SetHelper setHelper = new SetHelper(resourceSet);
        int currentLeaves = nLeaves;
        for (KElement e : vRes) {
            JDFResource r = (JDFResource)e;
            List<JDFResource> vLeaves = r.getLeafArray(this.checkAllLeaves(r));
            for (JDFResource leaf : vLeaves) {
                KElement newBaseRes;
                if ("SignatureName".equals(leaf.getLocalPartitionKey()) || (newBaseRes = this.setBaseResource(rl, leaf, setHelper)) == null) continue;
                int nn = resourceSet.numChildElements_KElement(className, null);
                if (nn > currentLeaves) {
                    this.jdfToXJDF.walkTree(leaf, newBaseRes);
                    currentLeaves = nn;
                }
                v.add(newBaseRes);
            }
        }
        return v;
    }

    protected String getResID(JDFResource linkTarget, JDFElement rl) {
        Object resID = linkTarget.getID();
        if (this.jdfToXJDF.getResourceAlias().contains(resID) && rl instanceof JDFRefElement) {
            String localName = rl.getParentNode_KElement().getLocalName();
            resID = localName + "_" + localName.hashCode() % 100000;
        }
        return resID;
    }

    boolean isExchangeResource(JDFResourceLink resLink, JDFResource linkTarget) {
        if (!this.jdfToXJDF.isSingleNode() || resLink != null && JDFResourceLink.EnumUsage.Input.equals(resLink.getUsage()) && resLink.hasNonEmpty("CombinedProcessIndex") && !resLink.getCombinedProcessIndex().contains(0)) {
            VElement vCreators;
            JDFResource resInRoot;
            JDFResource jDFResource = resInRoot = linkTarget == null ? null : linkTarget.getResourceRoot();
            if (resInRoot != null && !ContainerUtil.isEmpty(vCreators = resInRoot.getCreator(true))) {
                VElement vConsumers = resInRoot.getCreator(false);
                return !ContainerUtil.isEmpty(vConsumers);
            }
        }
        return false;
    }

    protected KElement getSet(String resID, KElement xRoot, String className) {
        KElement resourceSet = xRoot.getChildWithAttribute(className + "Set", "ID", null, resID, 0, true);
        return resourceSet;
    }

    protected KElement setBaseResource(JDFElement rl, JDFResource r, SetHelper sh) {
        KElement newLeaf;
        if (this.jdfToXJDF.getResourceAlias().contains(r.getID())) {
            newLeaf = sh.appendPartition(null, false).getPartition();
        } else {
            JDFAttributeMap map = r.getPartMap();
            ResourceHelper tmp = sh.getExactPartition(map = this.convertRanges(map, r));
            if (tmp != null) {
                return tmp.getRoot();
            }
            newLeaf = sh.getCreateExactPartition(map, false).getPartition();
        }
        this.setLeafAttributes(r, rl, newLeaf);
        return newLeaf;
    }

    protected void setLeafAttributes(JDFResource leaf, JDFElement rl, KElement newLeaf) {
        JDFAttributeMap partMap = leaf.getPartMap();
        this.setAmountPool(rl, newLeaf, partMap);
        if (this.jdfToXJDF.isRetainSpawnInfo() && leaf.hasAttribute("SpawnIDs")) {
            KElement spawnInfo = newLeaf.getDocRoot().getCreateElement("SpawnInfo", null, 0);
            KElement spawnID = spawnInfo.appendElement("SpawnID");
            spawnID.moveAttribute("SpawnIDs", newLeaf, null, null, null);
            spawnID.moveAttribute("SpawnStatus", newLeaf, null, null, null);
            spawnID.copyAttribute("ResourceID", newLeaf, "ID", null, null);
        }
    }

    protected void setAmountPool(JDFElement rl, KElement newLeaf, JDFAttributeMap partMap) {
        if (rl != null) {
            JDFAmountPool ap = (JDFAmountPool)rl.getElement("AmountPool");
            if (ap == null) {
                JDFAttributeMap amounts = rl.getAttributeMap().reduceMap(JDFToXJDFDataCache.getAmountAttribs());
                if (!amounts.isEmpty()) {
                    ap = (JDFAmountPool)newLeaf.getCreateElement("AmountPool");
                    for (String key : amounts.keySet()) {
                        ap.setPartAttribute(key, amounts.get(key), null, partMap);
                        rl.removeAttribute(key);
                    }
                }
            } else {
                this.processAmountPool(newLeaf, partMap, ap);
            }
        }
    }

    void processAmountPool(KElement newLeaf, JDFAttributeMap partMap, JDFAmountPool ap) {
        VElement vPartAmounts = ap.getMatchingPartAmountVector(partMap);
        if (vPartAmounts != null && vPartAmounts.size() > 0) {
            ap = (JDFAmountPool)newLeaf.getCreateElement("AmountPool");
            for (KElement e : vPartAmounts) {
                JDFPartAmount pa = (JDFPartAmount)e;
                this.moveToAmountPool(ap, pa);
            }
        }
    }

    void setSeparations(KElement jdf, KElement xjdf, String attName) {
        VElement v = jdf.getChildElementVector("SeparationSpec", null, null, false, 0, false);
        VString vsep = new VString();
        for (KElement e : v) {
            JDFSeparationSpec sep = (JDFSeparationSpec)e;
            String sepName = sep.getName();
            if (!StringUtil.isEmpty(sepName)) {
                vsep.add(StringUtil.replaceChar(sepName, ' ', "_", 0));
            }
            e.deleteNode();
        }
        if (!vsep.isEmpty() && xjdf != null) {
            xjdf.setAttribute(attName, StringUtil.setvString(vsep));
        }
    }

    protected void moveToAmountPool(JDFAmountPool newAP, JDFPartAmount pa) {
        JDFAttributeMap partMap = pa.getPartMap();
        partMap = this.convertRanges(partMap, pa);
        VJDFAttributeMap partMapVector = pa.getPartMapVector();
        if (partMap != null && this.jdfToXJDF.isExplicitWaste()) {
            boolean bWaste;
            String condition = partMap.get("Condition");
            boolean bl = bWaste = StringUtil.getNonEmpty(condition) != null && !"Good".equals(condition);
            if (partMapVector != null) {
                partMapVector.removeKey("Condition");
                VJDFAttributeMap converted = new VJDFAttributeMap();
                for (JDFAttributeMap m : partMapVector) {
                    converted.add(this.convertRanges(m, pa.getPart(0)));
                }
                partMapVector = converted;
            }
            JDFPartAmount paNew = newAP.getCreatePartAmount(partMapVector);
            JDFAttributeMap map = pa.getAttributeMap();
            if (bWaste) {
                map.remove("Amount");
                map.remove("ActualAmount");
                paNew.setAttributes(map);
                String wasteName = "Waste".equals(condition) ? null : condition;
                paNew.copyAttribute("ActualWaste", pa, "ActualAmount", null, null);
                paNew.copyAttribute("Waste", pa, "Amount", null, null);
                paNew.setAttribute("WasteDetails", wasteName);
            } else {
                paNew.setAttributes(map);
            }
        } else {
            JDFPartAmount paNew = newAP.getCreatePartAmount(partMapVector);
            paNew.setAttributes(pa);
        }
    }

    protected void setSetAttributes(KElement resourceSet, KElement rl, JDFResource linkRoot) {
        resourceSet.setAttribute("Name", this.jdfToXJDF.getSetName(linkRoot));
        if (rl instanceof JDFResourceLink) {
            resourceSet.setAttributes(rl);
        }
        JDFResource rootroot = linkRoot == null ? null : linkRoot.getResourceRoot();
        resourceSet.copyAttribute("DescriptiveName", rootroot);
        resourceSet.moveAttribute("CommentURL", rootroot);
        resourceSet.copyAttribute("Unit", rootroot);
        resourceSet.removeAttribute("rRef");
        resourceSet.removeAttribute("rSubRef");
        resourceSet.removeAttribute("Amount");
        resourceSet.removeAttribute("AmountProduced");
        resourceSet.removeAttribute("AmountRequired");
        resourceSet.removeAttribute("MinStatus");
        resourceSet.removeAttribute("MinAmount");
        resourceSet.removeAttribute("MaxAmount");
        resourceSet.removeAttribute("ActualAmount");
        resourceSet.removeAttribute("PipeProtocol");
        resourceSet.removeAttribute("PipePause");
        resourceSet.removeAttribute("PipeResume");
        if (rl instanceof JDFResourceInfo) {
            resourceSet.copyAttribute("Usage", rl);
            resourceSet.copyAttribute("ProcessUsage", rl);
        }
        if (this.jdfToXJDF.isSingleNode() && this.jdfToXJDF.wantDependent()) {
            this.setDependent(resourceSet, rl, linkRoot);
        }
    }

    private void setDependent(KElement resourceSet, KElement rl, JDFResource linkRoot) {
        JDFResourceLink resLink;
        VElement vResInRoot;
        if (JDFResourceLink.isResourceLink(rl) && (vResInRoot = (resLink = (JDFResourceLink)rl).getTargetVector(0)) != null) {
            VElement vCreators = new VElement();
            for (KElement r : vResInRoot) {
                VElement vTmp = ((JDFResource)r).getCreator(JDFResourceLink.EnumUsage.Input.equals(resLink.getUsage()));
                if (vTmp == null) continue;
                vCreators.addAll(vTmp);
            }
            vCreators.unify();
            if (vCreators.isEmpty()) {
                this.createNewDependent(resourceSet, linkRoot, resLink);
            } else {
                for (KElement creator : vCreators) {
                    this.processCreator(resourceSet, linkRoot, resLink, creator);
                }
            }
        }
    }

    void createNewDependent(KElement resourceSet, JDFResource linkRoot, JDFResourceLink resLink) {
        KElement dependent = resourceSet.appendElement("Dependent");
        dependent.moveAttribute("PipePause", linkRoot);
        dependent.moveAttribute("PipePause", resLink);
        dependent.moveAttribute("PipeResume", linkRoot);
        dependent.moveAttribute("PipeResume", resLink);
        dependent.moveAttribute("PipeProtocol", linkRoot);
        dependent.moveAttribute("PipeProtocol", resLink);
        dependent.moveAttribute("PipeID", linkRoot);
        dependent.copyAttribute("PipePartIDKeys", resLink);
        this.removeDuplicateDependents(resourceSet);
    }

    void processCreator(KElement resourceSet, JDFResource linkRoot, JDFResourceLink resLink, KElement creator) {
        JDFNode depNode = (JDFNode)creator;
        if (!depNode.isGroupNode()) {
            KElement dependent = resourceSet.appendElement("Dependent");
            dependent.setAttribute("JobID", depNode.getJobID(true));
            dependent.copyAttribute("JMFURL", depNode);
            dependent.copyAttribute("JobPartID", depNode);
            dependent.moveAttribute("PipeProtocol", linkRoot);
            dependent.moveAttribute("PipeProtocol", resLink);
            dependent.moveAttribute("PipeID", linkRoot);
            this.removeDuplicateDependents(resourceSet);
        }
    }

    void removeDuplicateDependents(KElement resourceSet) {
        VElement exist = resourceSet.getChildElementVector("Dependent", null);
        if (exist.size() > 1) {
            KElement newDep = exist.get(-1);
            for (int i = exist.size() - 2; i >= 0; --i) {
                KElement old = exist.get(i);
                if (!old.isEqual(newDep)) continue;
                newDep.deleteNode();
                break;
            }
        }
    }

    void moveToContent(JDFPageList pl) {
        if (!pl.isIndexed()) {
            pl.uniqueIndex();
        }
        KElement cNew = this.safeRename(pl, "Content");
        cNew.appendAttribute("PartIDKeys", "PageNumber", null, null, true);
        List<JDFPageData> vpd = cNew.getChildArrayByClass(JDFPageData.class, true, 0);
        if (vpd != null) {
            int i = 0;
            for (JDFPageData pd : vpd) {
                if (!pd.hasNonEmpty("PageIndex")) {
                    pd.setPageIndex(i);
                }
                pd.renameAttribute("PageIndex", "PageNumber", null, null);
                pd.setAttribute("ContentType", "Page");
                this.safeRename(pd, "Content");
                ++i;
            }
        }
    }
}

