/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.auto.JDFAutoMedia;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.extensions.XJDFEnums;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkIntentResource;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.util.JavaEnumUtil;
import org.cip4.jdflib.util.StringUtil;

public class WalkMedia
extends WalkIntentResource {
    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll();
    }

    @Override
    public VString getElementNames() {
        return new VString("Media", null);
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        map.remove("HoleType");
        map.remove("PrePrinted");
        String mediaType = map.get("MediaType");
        if (mediaType == null || JDFAutoMedia.EnumMediaType.Unknown.getName().equals(mediaType)) {
            map.put("MediaType", (ValuedEnum)JDFAutoMedia.EnumMediaType.Other);
        }
        WalkMedia.updateCoating(map, "FrontCoatings", "Coating");
        WalkMedia.updateCoating(map, "BackCoatings", "BackCoating");
        WalkMedia.updateGrade(map, "Grade", "ISOPaperSubstrate", "Coating");
        WalkMedia.updateGrade(map, "BackGrade", "BackISOPaperSubstrate", "BackCoating");
        this.updateFluteGrain("FluteDirection", map);
        this.updateFluteGrain("GrainDirection", map);
        map.renameKey("FrontCoatingDetail", "CoatingDetail");
        map.renameKey("FrontGlossValue", "GlossValue");
        super.updateAttributes(map);
    }

    static void updateGrade(JDFAttributeMap map, String oldGrade, String newGrade, String coatkey) {
        int igrade;
        JDFAutoMedia.EnumISOPaperSubstrate ips;
        String grade = map.remove(oldGrade);
        if (map.getNonEmpty(newGrade) == null && (ips = JDFMedia.getIsoPaperFromGrade(igrade = StringUtil.parseInt(grade, 0), XJDFEnums.eCoating.getEnum(map.get(coatkey)))) != null) {
            map.put(newGrade, ips.getName());
        }
    }

    static void updateCoating(JDFAttributeMap map, String oldCoat, String newCoat) {
        String coat = map.remove(oldCoat);
        if (map.getNonEmpty(newCoat) == null) {
            map.putNotNull(newCoat, JavaEnumUtil.getName(XJDFEnums.eCoating.getEnum(coat)));
        }
    }

    private void updateFluteGrain(String att, JDFAttributeMap map) {
        String value = map.getNonEmpty(att);
        if (JDFAutoMedia.EnumGrainDirection.LongEdge.getName().equals(value)) {
            JDFXYPair dim = JDFXYPair.createXYPair(map.get("Dimension"));
            value = dim != null ? (dim.getX() > dim.getY() ? JDFAutoMedia.EnumGrainDirection.XDirection.getName() : JDFAutoMedia.EnumGrainDirection.YDirection.getName()) : null;
        } else if (JDFAutoMedia.EnumGrainDirection.ShortEdge.getName().equals(value)) {
            JDFXYPair dim = JDFXYPair.createXYPair(map.get("Dimension"));
            value = dim != null ? (dim.getX() < dim.getY() ? JDFAutoMedia.EnumGrainDirection.XDirection.getName() : JDFAutoMedia.EnumGrainDirection.YDirection.getName()) : null;
        }
        map.remove(att);
        map.putNotNull(att, value);
    }

    @Override
    protected void setAttributes(KElement jdf, KElement xjdf) {
        this.movePattern((JDFMedia)jdf, xjdf);
        super.setAttributes(jdf, xjdf);
    }

    void movePattern(JDFMedia media, KElement xjdf) {
        Vector<JDFAutoMedia.EnumHoleType> pattern = media.getHoleType();
        if (pattern != null) {
            pattern.remove(JDFAutoMedia.EnumHoleType.None);
            pattern.remove(JDFAutoMedia.EnumHoleType.Explicit);
            for (ValuedEnum valuedEnum : pattern) {
                xjdf.appendElement("HolePattern").setAttribute("Pattern", valuedEnum.getName());
            }
        }
    }
}

